/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.TokenCanceler;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TokenRenewer;
import org.apache.rahas.TokenRequestDispatcherConfig;
import org.apache.rahas.TokenValidator;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;

public class TokenRequestDispatcher {
    private TokenRequestDispatcherConfig config;
    private static Log mlog = LogFactory.getLog((String)"org.apache.rampart.messages");
    private static Log log = LogFactory.getLog((String)TokenRequestDispatcher.class.getName());

    public TokenRequestDispatcher(TokenRequestDispatcherConfig config) throws TrustException {
        this.config = config;
    }

    public TokenRequestDispatcher(OMElement config) throws TrustException {
        this(TokenRequestDispatcherConfig.load(config));
    }

    public TokenRequestDispatcher(String configFilePath) throws TrustException {
        this(TokenRequestDispatcherConfig.load(configFilePath));
    }

    public SOAPEnvelope handle(MessageContext inMsgCtx, MessageContext outMsgCtx) throws TrustException {
        if (mlog.isDebugEnabled()) {
            mlog.debug((Object)("*********************** TokenRequestDispatcher received \n" + inMsgCtx.getEnvelope()));
        }
        RahasData data = new RahasData(inMsgCtx);
        String reqType = data.getRequestType();
        String tokenType = data.getTokenType();
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue".equals(reqType)) {
            log.debug((Object)"issue");
            TokenIssuer issuer = tokenType == null || tokenType.trim().length() == 0 ? this.config.getDefaultIssuerInstace() : this.config.getIssuer(tokenType);
            SOAPEnvelope response = issuer.issue(data);
            outMsgCtx.getOptions().setAction(issuer.getResponseAction(data));
            if (mlog.isDebugEnabled()) {
                mlog.debug((Object)("*********************** TokenRequestDispatcher sent out \n" + response));
            }
            return response;
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Validate".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate".equals(reqType)) {
            log.debug((Object)"validate");
            TokenValidator validator = tokenType == null || tokenType.trim().length() == 0 ? this.config.getDefaultValidatorInstance() : this.config.getValidator(tokenType);
            SOAPEnvelope response = validator.validate(data);
            outMsgCtx.getOptions().setAction(TrustUtil.getActionValue(data.getVersion(), "/RSTR/Validate"));
            return response;
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Renew".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew".equals(reqType)) {
            log.debug((Object)"renew");
            TokenRenewer renewer = tokenType == null || tokenType.trim().length() == 0 ? this.config.getDefaultRenewerInstance() : this.config.getRenewer(tokenType);
            SOAPEnvelope response = renewer.renew(data);
            outMsgCtx.getOptions().setAction(TrustUtil.getActionValue(data.getVersion(), "/RSTR/Renew"));
            return response;
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel".equals(reqType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel".equals(reqType)) {
            log.debug((Object)"cancel");
            TokenCanceler canceler = this.config.getDefaultCancelerInstance();
            SOAPEnvelope response = canceler.cancel(data);
            outMsgCtx.getOptions().setAction(canceler.getResponseAction(data));
            return response;
        }
        throw new TrustException("InvalidRequest");
    }
}

