/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class HttpsToken
extends Token {
    private boolean requireClientCertificate = false;
    private boolean httpBasicAuthentication = false;
    private boolean httpDigestAuthentication = false;

    public HttpsToken(int version) {
        this.setVersion(version);
    }

    public boolean isRequireClientCertificate() {
        return this.requireClientCertificate;
    }

    public void setRequireClientCertificate(boolean requireClientCertificate) {
        this.requireClientCertificate = requireClientCertificate;
    }

    public boolean isHttpBasicAuthentication() {
        return this.httpBasicAuthentication;
    }

    public void setHttpBasicAuthentication(boolean httpBasicAuthentication) {
        this.httpBasicAuthentication = httpBasicAuthentication;
    }

    public boolean isHttpDigestAuthentication() {
        return this.httpDigestAuthentication;
    }

    public void setHttpDigestAuthentication(boolean httpDigestAuthentication) {
        this.httpDigestAuthentication = httpDigestAuthentication;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.HTTPS_TOKEN;
        }
        return SP11Constants.HTTPS_TOKEN;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        HttpsToken.writeStartElement(writer, prefix, localname, namespaceURI);
        if (this.version == 2) {
            if (this.isRequireClientCertificate() || this.isHttpBasicAuthentication() || this.isHttpDigestAuthentication()) {
                HttpsToken.writeStartElement(writer, SPConstants.POLICY);
                if (this.isHttpBasicAuthentication()) {
                    HttpsToken.writeEmptyElement(writer, prefix, SPConstants.HTTP_BASIC_AUTHENTICATION.getLocalPart(), namespaceURI);
                } else if (this.isHttpDigestAuthentication()) {
                    HttpsToken.writeEmptyElement(writer, prefix, SPConstants.HTTP_DIGEST_AUTHENTICATION.getLocalPart(), namespaceURI);
                } else if (this.isRequireClientCertificate()) {
                    HttpsToken.writeEmptyElement(writer, prefix, SPConstants.REQUIRE_CLIENT_CERTIFICATE.getLocalPart(), namespaceURI);
                }
                writer.writeEndElement();
            }
        } else {
            writer.writeAttribute(SPConstants.REQUIRE_CLIENT_CERTIFICATE.getLocalPart(), Boolean.toString(this.isRequireClientCertificate()));
        }
        writer.writeEndElement();
    }
}

