/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.TemplateParameter;

public class TemplateParameterSerializer {
    private static final Log log = LogFactory.getLog(TemplateParameterSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");
    protected static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");

    public static void serializeTemplateParameters(OMElement parent, Collection<TemplateParameter> params) {
        TemplateParameterSerializer.serializeTemplateParameters(parent, params, PARAMETER_Q);
    }

    public static void serializeTemplateParameters(OMElement parent, Collection<TemplateParameter> params, QName childElementName) {
        for (TemplateParameter tp : params) {
            TemplateParameterSerializer.serializeTemplateParameter(parent, tp, childElementName);
        }
    }

    public static void serializeTemplateParameter(OMElement parent, TemplateParameter tp, QName childElementName) {
        OMElement param = fac.createOMElement(childElementName, (OMContainer)parent);
        if (tp.getName() == null) {
            String msg = "Template parameter name missing";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        param.addAttribute(fac.createOMAttribute("name", nullNS, tp.getName()));
        if (tp.getDefaultValue() != null) {
            new ValueSerializer().serializeValue(tp.getDefaultValue(), "default", param);
            if (tp.isOptional()) {
                param.addAttribute(fac.createOMAttribute("optional", nullNS, "true"));
            }
        }
    }
}

