/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.Ctable;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.LongLongDoubleHashMap;

public class CtableCPInstruction
extends ComputationCPInstruction {
    private final String _outDim1;
    private final String _outDim2;
    private final boolean _dim1Literal;
    private final boolean _dim2Literal;
    private final boolean _isExpand;
    private final boolean _ignoreZeros;

    private CtableCPInstruction(CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String outputDim1, boolean dim1Literal, String outputDim2, boolean dim2Literal, boolean isExpand, boolean ignoreZeros, String opcode, String istr) {
        super(CPInstruction.CPType.Ctable, null, in1, in2, in3, out, opcode, istr);
        this._outDim1 = outputDim1;
        this._dim1Literal = dim1Literal;
        this._outDim2 = outputDim2;
        this._dim2Literal = dim2Literal;
        this._isExpand = isExpand;
        this._ignoreZeros = ignoreZeros;
    }

    public static CtableCPInstruction parseInstruction(String inst) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst);
        InstructionUtils.checkNumFields(parts, 7);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("ctable") && !opcode.equalsIgnoreCase("ctableexpand")) {
            throw new DMLRuntimeException("Unexpected opcode in TertiaryCPInstruction: " + inst);
        }
        boolean isExpand = opcode.equalsIgnoreCase("ctableexpand");
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        String[] dim1Fields = parts[4].split("\u00b7");
        String[] dim2Fields = parts[5].split("\u00b7");
        CPOperand out = new CPOperand(parts[6]);
        boolean ignoreZeros = Boolean.parseBoolean(parts[7]);
        return new CtableCPInstruction(in1, in2, in3, out, dim1Fields[0], Boolean.parseBoolean(dim1Fields[1]), dim2Fields[0], Boolean.parseBoolean(dim2Fields[1]), isExpand, ignoreZeros, opcode, inst);
    }

    private Ctable.OperationTypes findCtableOperation() {
        Expression.DataType dt1 = this.input1.getDataType();
        Expression.DataType dt2 = this.input2.getDataType();
        Expression.DataType dt3 = this.input3.getDataType();
        return Ctable.findCtableOperationByInputDataTypes(dt1, dt2, dt3);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        int inputCols;
        int inputRows;
        boolean sparse;
        boolean outputDimsKnown;
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock2 = null;
        MatrixBlock wtBlock = null;
        CTableMap resultMap = new CTableMap(LongLongDoubleHashMap.EntryType.INT);
        MatrixBlock resultBlock = null;
        Ctable.OperationTypes ctableOp = this.findCtableOperation();
        ctableOp = this._isExpand ? Ctable.OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT : ctableOp;
        long outputDim1 = this._dim1Literal ? (long)Double.parseDouble(this._outDim1) : ec.getScalarInput(this._outDim1, Expression.ValueType.DOUBLE, false).getLongValue();
        long outputDim2 = this._dim2Literal ? (long)Double.parseDouble(this._outDim2) : ec.getScalarInput(this._outDim2, Expression.ValueType.DOUBLE, false).getLongValue();
        boolean bl = outputDimsKnown = outputDim1 != -1L && outputDim2 != -1L;
        if (outputDimsKnown && !(sparse = MatrixBlock.evalSparseFormatInMemory(outputDim1, outputDim2, (inputRows = matBlock1.getNumRows()) * (inputCols = matBlock1.getNumColumns())))) {
            resultBlock = new MatrixBlock((int)outputDim1, (int)outputDim2, false);
        }
        if (this._isExpand) {
            resultBlock = new MatrixBlock(matBlock1.getNumRows(), Integer.MAX_VALUE, true);
        }
        switch (ctableOp) {
            case CTABLE_TRANSFORM: {
                matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
                wtBlock = ec.getMatrixInput(this.input3.getName(), this.getExtendedOpcode());
                matBlock1.ctableOperations((Operator)((SimpleOperator)this._optr), matBlock2, (MatrixValue)wtBlock, resultMap, resultBlock);
                break;
            }
            case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
                double cst1 = ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral()).getDoubleValue();
                matBlock1.ctableOperations((SimpleOperator)this._optr, matBlock2, cst1, this._ignoreZeros, resultMap, resultBlock);
                break;
            }
            case CTABLE_EXPAND_SCALAR_WEIGHT: {
                matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
                double cst1 = ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral()).getDoubleValue();
                matBlock1.ctableSeqOperations(matBlock2, cst1, resultBlock);
                break;
            }
            case CTABLE_TRANSFORM_HISTOGRAM: {
                double cst1 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral()).getDoubleValue();
                double cst2 = ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral()).getDoubleValue();
                matBlock1.ctableOperations((Operator)((SimpleOperator)this._optr), cst1, cst2, resultMap, resultBlock);
                break;
            }
            case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                wtBlock = ec.getMatrixInput(this.input3.getName(), this.getExtendedOpcode());
                double cst1 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral()).getDoubleValue();
                matBlock1.ctableOperations((Operator)((SimpleOperator)this._optr), cst1, (MatrixValue)wtBlock, resultMap, resultBlock);
                break;
            }
            default: {
                throw new DMLRuntimeException("Encountered an invalid ctable operation (" + (Object)((Object)ctableOp) + ") while executing instruction: " + this.toString());
            }
        }
        if (this.input1.getDataType() == Expression.DataType.MATRIX) {
            ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        }
        if (this.input2.getDataType() == Expression.DataType.MATRIX) {
            ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        }
        if (this.input3.getDataType() == Expression.DataType.MATRIX) {
            ec.releaseMatrixInput(this.input3.getName(), this.getExtendedOpcode());
        }
        if (resultBlock == null) {
            resultBlock = outputDimsKnown ? DataConverter.convertToMatrixBlock(resultMap, (int)outputDim1, (int)outputDim2) : DataConverter.convertToMatrixBlock(resultMap);
        } else {
            resultBlock.examSparsity();
        }
        if (this.checkGuardedRepresentationChange(matBlock1, matBlock2, resultBlock)) {
            resultBlock.examSparsity();
        }
        ec.setMatrixOutput(this.output.getName(), resultBlock, this.getExtendedOpcode());
    }
}

