/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AppendFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MMChainFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MultiReturnParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TsmmFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGAlignedSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;

public class FEDInstructionUtils {
    public static Instruction checkAndReplaceCP(Instruction inst, ExecutionContext ec) {
        FEDInstruction fedinst = null;
        if (inst instanceof AggregateBinaryCPInstruction) {
            AggregateBinaryCPInstruction instruction = (AggregateBinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && instruction.input2.isMatrix()) {
                MatrixObject mo1 = ec.getMatrixObject(instruction.input1);
                MatrixObject mo2 = ec.getMatrixObject(instruction.input2);
                if (mo1.isFederated(FederationMap.FType.ROW) || mo2.isFederated(FederationMap.FType.ROW)) {
                    fedinst = AggregateBinaryFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            }
        } else if (inst instanceof MMChainCPInstruction) {
            MMChainCPInstruction linst = (MMChainCPInstruction)inst;
            MatrixObject mo = ec.getMatrixObject(linst.input1);
            if (mo.isFederated()) {
                fedinst = MMChainFEDInstruction.parseInstruction(linst.getInstructionString());
            }
        } else if (inst instanceof MMTSJCPInstruction) {
            MMTSJCPInstruction linst = (MMTSJCPInstruction)inst;
            MatrixObject mo = ec.getMatrixObject(linst.input1);
            if (mo.isFederated()) {
                fedinst = TsmmFEDInstruction.parseInstruction(linst.getInstructionString());
            }
        } else if (inst instanceof AggregateUnaryCPInstruction) {
            MatrixObject mo1;
            AggregateUnaryCPInstruction instruction = (AggregateUnaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && ec.containsVariable(instruction.input1) && (mo1 = ec.getMatrixObject(instruction.input1)).isFederated() && instruction.getAUType() == AggregateUnaryCPInstruction.AUType.DEFAULT) {
                fedinst = AggregateUnaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        } else if (inst instanceof BinaryCPInstruction) {
            BinaryCPInstruction instruction = (BinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && ec.getMatrixObject(instruction.input1).isFederated() || instruction.input2.isMatrix() && ec.getMatrixObject(instruction.input2).isFederated()) {
                fedinst = instruction.getOpcode().equals("append") ? AppendFEDInstruction.parseInstruction(inst.getInstructionString()) : BinaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        } else if (inst instanceof ParameterizedBuiltinCPInstruction) {
            ParameterizedBuiltinCPInstruction pinst = (ParameterizedBuiltinCPInstruction)inst;
            if (pinst.getOpcode().equals("replace") && pinst.getTarget(ec).isFederated()) {
                fedinst = ParameterizedBuiltinFEDInstruction.parseInstruction(pinst.getInstructionString());
            } else if ((pinst.getOpcode().equals("transformdecode") || pinst.getOpcode().equals("transformapply")) && pinst.getTarget(ec).isFederated()) {
                return ParameterizedBuiltinFEDInstruction.parseInstruction(pinst.getInstructionString());
            }
        } else if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction) {
            CacheableData<?> fo;
            MultiReturnParameterizedBuiltinCPInstruction minst = (MultiReturnParameterizedBuiltinCPInstruction)inst;
            if (minst.getOpcode().equals("transformencode") && minst.input1.isFrame() && (fo = ec.getCacheableData(minst.input1)).isFederated()) {
                fedinst = MultiReturnParameterizedBuiltinFEDInstruction.parseInstruction(minst.getInstructionString());
            }
        } else if (inst instanceof ReorgCPInstruction && inst.getOpcode().equals("r'")) {
            ReorgCPInstruction rinst = (ReorgCPInstruction)inst;
            CacheableData<?> mo = ec.getCacheableData(rinst.input1);
            if (mo.isFederated()) {
                fedinst = ReorgFEDInstruction.parseInstruction(rinst.getInstructionString());
            }
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }

    public static Instruction checkAndReplaceSP(Instruction inst, ExecutionContext ec) {
        FEDInstruction fedinst = null;
        if (inst instanceof MapmmSPInstruction) {
            MapmmSPInstruction instruction = (MapmmSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = new AggregateBinaryFEDInstruction(instruction.getOperator(), instruction.input1, instruction.input2, instruction.output, "ba+*", "FED...");
            }
        } else if (inst instanceof AggregateUnarySPInstruction) {
            AggregateUnarySPInstruction instruction = (AggregateUnarySPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = AggregateUnaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        } else if (inst instanceof WriteSPInstruction) {
            WriteSPInstruction instruction = (WriteSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return VariableCPInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof AppendGAlignedSPInstruction) {
            AppendGAlignedSPInstruction instruction = (AppendGAlignedSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = AppendFEDInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof AppendGSPInstruction) {
            AppendGSPInstruction instruction = (AppendGSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = AppendFEDInstruction.parseInstruction(instruction.getInstructionString());
            }
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }
}

