/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Append;
import org.apache.sysds.lops.AppendG;
import org.apache.sysds.lops.AppendGAlignedSP;
import org.apache.sysds.lops.AppendM;
import org.apache.sysds.lops.AppendR;
import org.apache.sysds.lops.Binary;
import org.apache.sysds.lops.BinaryM;
import org.apache.sysds.lops.BinaryScalar;
import org.apache.sysds.lops.BinaryUAggChain;
import org.apache.sysds.lops.CentralMoment;
import org.apache.sysds.lops.CoVariance;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.DnnTransform;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.PickByCount;
import org.apache.sysds.lops.SortKeys;
import org.apache.sysds.lops.Unary;
import org.apache.sysds.lops.UnaryCP;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class BinaryOp
extends MultiThreadedHop {
    public static final double APPEND_MEM_MULTIPLIER = 1.0;
    private Types.OpOp2 op;
    private boolean outer = false;
    public static AppendMethod FORCED_APPEND_METHOD = null;
    public static MMBinaryMethod FORCED_BINARY_METHOD = null;

    private BinaryOp() {
    }

    public BinaryOp(String l, Types.DataType dt, Types.ValueType vt, Types.OpOp2 o, Hop inp1, Hop inp2) {
        super(l, dt, vt);
        this.op = o;
        this.getInput().add(0, inp1);
        this.getInput().add(1, inp2);
        inp1.getParent().add(this);
        inp2.getParent().add(this);
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
        HopsException.check(this._input.size() == 2, this, "should have arity 2 but has arity %d", this._input.size());
    }

    public Types.OpOp2 getOp() {
        return this.op;
    }

    public void setOp(Types.OpOp2 iop) {
        this.op = iop;
    }

    public void setOuterVectorOperation(boolean flag) {
        this.outer = flag;
    }

    public boolean isOuter() {
        return this.outer;
    }

    @Override
    public boolean isGPUEnabled() {
        if (!DMLScript.USE_ACCELERATOR) {
            return false;
        }
        switch (this.op) {
            case IQM: 
            case MOMENT: 
            case COV: 
            case QUANTILE: 
            case INTERQUANTILE: 
            case MEDIAN: {
                return false;
            }
            case CBIND: 
            case RBIND: {
                Types.DataType dt1 = this.getInput().get(0).getDataType();
                return dt1 == Types.DataType.MATRIX;
            }
        }
        Types.DataType dt1 = this.getInput().get(0).getDataType();
        Types.DataType dt2 = this.getInput().get(1).getDataType();
        boolean isMatrixScalar = dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR || dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX;
        boolean isMatrixMatrix = dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX;
        Types.OpOp2[] supportedOps = new Types.OpOp2[]{Types.OpOp2.MULT, Types.OpOp2.PLUS, Types.OpOp2.MINUS, Types.OpOp2.DIV, Types.OpOp2.POW, Types.OpOp2.MINUS1_MULT, Types.OpOp2.MODULUS, Types.OpOp2.INTDIV, Types.OpOp2.LESS, Types.OpOp2.LESSEQUAL, Types.OpOp2.EQUAL, Types.OpOp2.NOTEQUAL, Types.OpOp2.GREATER, Types.OpOp2.GREATEREQUAL};
        if (isMatrixScalar && (this.op == Types.OpOp2.MINUS_NZ || this.op == Types.OpOp2.MIN || this.op == Types.OpOp2.MAX)) {
            return true;
        }
        if (isMatrixMatrix && this.op == Types.OpOp2.SOLVE) {
            return true;
        }
        if (isMatrixScalar || isMatrixMatrix) {
            for (Types.OpOp2 supportedOp : supportedOps) {
                if (this.op != supportedOp) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isMultiThreadedOpType() {
        return !this.getDataType().isScalar();
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        switch (this.op) {
            case IQM: {
                this.constructLopsIQM(et);
                break;
            }
            case MOMENT: {
                this.constructLopsCentralMoment(et);
                break;
            }
            case COV: {
                this.constructLopsCovariance(et);
                break;
            }
            case QUANTILE: 
            case INTERQUANTILE: {
                this.constructLopsQuantile(et);
                break;
            }
            case MEDIAN: {
                this.constructLopsMedian(et);
                break;
            }
            case CBIND: 
            case RBIND: {
                this.constructLopsAppend(et);
                break;
            }
            default: {
                this.constructLopsBinaryDefault();
            }
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private void constructLopsIQM(LopProperties.ExecType et) {
        SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), SortKeys.OperationTypes.WithWeights, this.getInput().get(0).getDataType(), this.getInput().get(0).getValueType(), et);
        sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getBlocksize(), this.getInput().get(0).getNnz());
        PickByCount pick = new PickByCount(sort, null, this.getDataType(), this.getValueType(), PickByCount.OperationTypes.IQM, et, true);
        this.setOutputDimensions(pick);
        this.setLineNumbers(pick);
        this.setLops(pick);
    }

    private void constructLopsMedian(LopProperties.ExecType et) {
        SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), SortKeys.OperationTypes.WithWeights, this.getInput().get(0).getDataType(), this.getInput().get(0).getValueType(), et);
        sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getBlocksize(), this.getInput().get(0).getNnz());
        PickByCount pick = new PickByCount(sort, Data.createLiteralLop(Types.ValueType.FP64, Double.toString(0.5)), this.getDataType(), this.getValueType(), PickByCount.OperationTypes.MEDIAN, et, true);
        pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getBlocksize(), this.getNnz());
        pick.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        this.setLops(pick);
    }

    private void constructLopsCentralMoment(LopProperties.ExecType et) {
        Types.DataType dt = Types.DataType.SCALAR;
        CentralMoment cm = new CentralMoment(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), dt, this.getValueType(), et);
        this.setLineNumbers(cm);
        cm.getOutputParameters().setDimensions(0L, 0L, 0L, -1L);
        this.setLops(cm);
    }

    private void constructLopsCovariance(LopProperties.ExecType et) {
        CoVariance cov = new CoVariance(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getDataType(), this.getValueType(), et);
        cov.getOutputParameters().setDimensions(0L, 0L, 0L, -1L);
        this.setLineNumbers(cov);
        this.setLops(cov);
    }

    private void constructLopsQuantile(LopProperties.ExecType et) {
        PickByCount.OperationTypes pick_op = null;
        pick_op = this.op == Types.OpOp2.QUANTILE ? PickByCount.OperationTypes.VALUEPICK : PickByCount.OperationTypes.RANGEPICK;
        SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), SortKeys.OperationTypes.WithoutWeights, Types.DataType.MATRIX, Types.ValueType.FP64, et);
        sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getBlocksize(), this.getInput().get(0).getNnz());
        PickByCount pick = new PickByCount(sort, this.getInput().get(1).constructLops(), this.getDataType(), this.getValueType(), pick_op, et, true);
        this.setOutputDimensions(pick);
        this.setLineNumbers(pick);
        this.setLops(pick);
    }

    private void constructLopsAppend(LopProperties.ExecType et) {
        boolean cbind;
        Types.DataType dt1 = this.getInput().get(0).getDataType();
        Types.DataType dt2 = this.getInput().get(1).getDataType();
        Types.ValueType vt1 = this.getInput().get(0).getValueType();
        Types.ValueType vt2 = this.getInput().get(1).getValueType();
        boolean bl = cbind = this.op == Types.OpOp2.CBIND;
        if (!(dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX || dt1 == Types.DataType.FRAME && dt2 == Types.DataType.FRAME || dt1 == Types.DataType.LIST || dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.SCALAR && vt1 == Types.ValueType.STRING && vt2 == Types.ValueType.STRING)) {
            throw new HopsException("Append can only apply to two matrices, two frames, two scalar strings, or anything to a list!");
        }
        Lop append = null;
        if (dt1 == Types.DataType.MATRIX || dt1 == Types.DataType.FRAME) {
            long clen;
            long rlen;
            long l = cbind ? this.getInput().get(0).getDim1() : (rlen = this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? this.getInput().get(0).getDim1() + this.getInput().get(1).getDim1() : -1L);
            long l2 = cbind ? (this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? this.getInput().get(0).getDim2() + this.getInput().get(1).getDim2() : -1L) : (clen = this.getInput().get(0).getDim2());
            if (et == LopProperties.ExecType.SPARK) {
                append = BinaryOp.constructSPAppendLop(this.getInput().get(0), this.getInput().get(1), this.getDataType(), this.getValueType(), cbind, this);
                append.getOutputParameters().setDimensions(rlen, clen, this.getBlocksize(), this.getNnz());
            } else {
                Lop offset = BinaryOp.createOffsetLop(this.getInput().get(0), cbind);
                append = new Append(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), offset, this.getDataType(), this.getValueType(), cbind, et);
                append.getOutputParameters().setDimensions(rlen, clen, this.getBlocksize(), this.getNnz());
            }
        } else if (dt1 == Types.DataType.LIST) {
            long len = this.getInput().get(0).getLength() + 1L;
            append = new Append(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), new LiteralOp(-1L).constructLops(), this.getDataType(), this.getValueType(), cbind, et);
            append.getOutputParameters().setDimensions(1L, len, this.getBlocksize(), len);
        } else {
            append = new Append(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Data.createLiteralLop(Types.ValueType.INT64, "-1"), this.getDataType(), this.getValueType(), cbind, LopProperties.ExecType.CP);
            append.getOutputParameters().setDimensions(0L, 0L, -1L, -1L);
        }
        this.setLineNumbers(append);
        this.setLops(append);
    }

    private void constructLopsBinaryDefault() {
        Types.DataType dt2;
        Types.DataType dt1 = this.getInput().get(0).getDataType();
        if (dt1 == (dt2 = this.getInput().get(1).getDataType()) && dt1 == Types.DataType.SCALAR) {
            BinaryScalar binScalar1 = new BinaryScalar(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.op, this.getDataType(), this.getValueType());
            binScalar1.getOutputParameters().setDimensions(0L, 0L, 0L, -1L);
            this.setLineNumbers(binScalar1);
            this.setLops(binScalar1);
        } else if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR || dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX) {
            LopProperties.ExecType et = this.optFindExecType();
            Hop right = this.getInput().get(1);
            Types.OpOp1 ot = this.op == Types.OpOp2.POW && HopRewriteUtils.isLiteralOfValue(right, 2.0) ? Types.OpOp1.POW2 : (this.op == Types.OpOp2.MULT && HopRewriteUtils.isLiteralOfValue(right, 2.0) ? Types.OpOp1.MULT2 : null);
            Lop tmp = null;
            tmp = ot != null ? new Unary(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), ot, this.getDataType(), this.getValueType(), et) : new Binary(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.op, this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(tmp);
            this.setLineNumbers(tmp);
            this.setLops(tmp);
        } else {
            boolean isGPUSoftmax;
            LopProperties.ExecType et = this.optFindExecType();
            boolean bl = isGPUSoftmax = et == LopProperties.ExecType.GPU && this.op == Types.OpOp2.DIV && this.getInput().get(0) instanceof UnaryOp && this.getInput().get(1) instanceof AggUnaryOp && ((UnaryOp)this.getInput().get(0)).getOp() == Types.OpOp1.EXP && ((AggUnaryOp)this.getInput().get(1)).getOp() == Types.AggOp.SUM && ((AggUnaryOp)this.getInput().get(1)).getDirection() == Types.Direction.Row && this.getInput().get(0) == this.getInput().get(1).getInput().get(0);
            if (isGPUSoftmax) {
                UnaryCP softmax = new UnaryCP(this.getInput().get(0).getInput().get(0).constructLops(), Types.OpOp1.SOFTMAX, this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(softmax);
                this.setLineNumbers(softmax);
                this.setLops(softmax);
            } else if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.GPU) {
                Lop binary = null;
                boolean isLeftXGt = this.getInput().get(0) instanceof BinaryOp && ((BinaryOp)this.getInput().get(0)).getOp() == Types.OpOp2.GREATER;
                Hop potentialZero = isLeftXGt ? this.getInput().get(0).getInput().get(1) : null;
                boolean isLeftXGt0 = isLeftXGt && HopRewriteUtils.isLiteralOfValue(potentialZero, 0.0);
                binary = this.op == Types.OpOp2.MULT && isLeftXGt0 && !this.getInput().get(0).isVector() && !this.getInput().get(1).isVector() && this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? new DnnTransform(this.getInput().get(0).getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Types.OpOpDnn.RELU_BACKWARD, this.getDataType(), this.getValueType(), et, OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads)) : new Binary(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.op, this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(binary);
                this.setLineNumbers(binary);
                this.setLops(binary);
            } else if (et == LopProperties.ExecType.SPARK) {
                Hop left = this.getInput().get(0);
                Hop right = this.getInput().get(1);
                MMBinaryMethod mbin = BinaryOp.optFindMMBinaryMethodSpark(left, right);
                if (FORCED_BINARY_METHOD != null) {
                    mbin = FORCED_BINARY_METHOD;
                }
                Lop binary = null;
                if (mbin == MMBinaryMethod.MR_BINARY_UAGG_CHAIN) {
                    AggUnaryOp uRight = (AggUnaryOp)right;
                    binary = new BinaryUAggChain(left.constructLops(), this.op, uRight.getOp(), uRight.getDirection(), this.getDataType(), this.getValueType(), et);
                } else if (mbin == MMBinaryMethod.MR_BINARY_M) {
                    boolean isColVector = dt1 != Types.DataType.TENSOR && dt2 != Types.DataType.TENSOR && right.getDim2() == 1L && left.getDim1() == right.getDim1();
                    binary = new BinaryM(left.constructLops(), right.constructLops(), this.op, this.getDataType(), this.getValueType(), et, isColVector);
                } else {
                    binary = new Binary(left.constructLops(), right.constructLops(), this.op, this.getDataType(), this.getValueType(), et);
                }
                this.setOutputDimensions(binary);
                this.setLineNumbers(binary);
                this.setLops(binary);
            }
        }
    }

    @Override
    public String getOpString() {
        return "b(" + this.op.toString() + ")";
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.dimsKnown() && this.getNnz() < 0L) {
            nnz = -1L;
        }
        if (!(this.op != Types.OpOp2.CBIND && this.op != Types.OpOp2.RBIND || ConfigurationManager.isDynamicRecompilation() || this.getDataType() == Types.DataType.SCALAR)) {
            ret = OptimizerUtils.DEFAULT_SIZE;
        } else {
            double sparsity = 1.0;
            if (nnz < 0L) {
                Hop input1 = this.getInput().get(0);
                Hop input2 = this.getInput().get(1);
                if (input1.dimsKnown() && input2.dimsKnown()) {
                    if (OptimizerUtils.isBinaryOpConditionalSparseSafe(this.op) && input2 instanceof LiteralOp) {
                        double sp1 = input1.getNnz() > 0L && input1.getDataType() == Types.DataType.MATRIX ? OptimizerUtils.getSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz()) : 1.0;
                        LiteralOp lit = (LiteralOp)input2;
                        sparsity = OptimizerUtils.getBinaryOpSparsityConditionalSparseSafe(sp1, this.op, lit);
                    } else {
                        double sp1 = input1.getNnz() > 0L && input1.getDataType() == Types.DataType.MATRIX ? OptimizerUtils.getSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz()) : 1.0;
                        double sp2 = input2.getNnz() > 0L && input2.getDataType() == Types.DataType.MATRIX ? OptimizerUtils.getSparsity(input2.getDim1(), input2.getDim2(), input2.getNnz()) : 1.0;
                        sparsity = OptimizerUtils.getBinaryOpSparsity(sp1, sp2, this.op, !this.outer);
                    }
                }
            } else {
                sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
            }
            ret = OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.op == Types.OpOp2.QUANTILE || this.op == Types.OpOp2.IQM || this.op == Types.OpOp2.MEDIAN) {
            ret = this.getInput().get(0).getMemEstimate() * 3.0;
        } else if (this.op == Types.OpOp2.SOLVE) {
            if (this.isGPUEnabled()) {
                long m = this.getInput().get(0).getDim1();
                long n = this.getInput().get(0).getDim2();
                long tauSize = OptimizerUtils.estimateSize(m, 1L);
                long workSize = OptimizerUtils.estimateSize(m, n);
                long AtmpSize = OptimizerUtils.estimateSize(m, n);
                long BtmpSize = OptimizerUtils.estimateSize(n, 1L);
                return tauSize + workSize + AtmpSize + BtmpSize;
            }
            double interOutput = OptimizerUtils.estimateSizeExactSparsity(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), 1.0);
            return interOutput;
        }
        return ret;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        MatrixCharacteristics ret = null;
        DataCharacteristics[] dc = memo.getAllInputStats(this.getInput());
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        Types.DataType dt1 = input1.getDataType();
        Types.DataType dt2 = input2.getDataType();
        if (this.op == Types.OpOp2.CBIND) {
            long ldim1 = -1L;
            long ldim2 = -1L;
            long lnnz = -1L;
            if (dc[0].rowsKnown() || dc[1].rowsKnown()) {
                long l = ldim1 = dc[0].rowsKnown() ? dc[0].getRows() : dc[1].getRows();
            }
            if (dc[0].colsKnown() && dc[1].colsKnown()) {
                ldim2 = dc[0].getCols() + dc[1].getCols();
            }
            if (dc[0].nnzKnown() && dc[1].nnzKnown()) {
                lnnz = dc[0].getNonZeros() + dc[1].getNonZeros();
            }
            if (ldim1 >= 0L || ldim2 >= 0L || lnnz >= 0L) {
                return new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
            }
        } else if (this.op == Types.OpOp2.RBIND) {
            long ldim1 = -1L;
            long ldim2 = -1L;
            long lnnz = -1L;
            if (dc[0].colsKnown() || dc[1].colsKnown()) {
                long l = ldim2 = dc[0].colsKnown() ? dc[0].getCols() : dc[1].getCols();
            }
            if (dc[0].rowsKnown() && dc[1].rowsKnown()) {
                ldim1 = dc[0].getRows() + dc[1].getRows();
            }
            if (dc[0].nnzKnown() && dc[1].nnzKnown()) {
                lnnz = dc[0].getNonZeros() + dc[1].getNonZeros();
            }
            if (ldim1 >= 0L || ldim2 >= 0L || lnnz >= 0L) {
                return new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
            }
        } else if (this.op == Types.OpOp2.SOLVE) {
            if (dc[0].getCols() >= 0L) {
                ret = new MatrixCharacteristics(dc[0].getCols(), 1L, -1, dc[0].getCols());
            }
        } else {
            long ldim2;
            long ldim1;
            double sp1 = 1.0;
            double sp2 = 1.0;
            if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR && dc[0].dimsKnown()) {
                ldim1 = dc[0].getRows();
                ldim2 = dc[0].getCols();
                sp1 = dc[0].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, dc[0].getNonZeros()) : 1.0;
            } else if (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX) {
                ldim1 = dc[1].getRows();
                ldim2 = dc[1].getCols();
                sp2 = dc[1].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, dc[1].getNonZeros()) : 1.0;
            } else {
                if (this.outer) {
                    ldim1 = dc[0].getRows();
                    ldim2 = dc[1].getCols();
                } else {
                    long l = dc[0].rowsKnown() ? dc[0].getRows() : (ldim1 = dc[1].getRows() > 1L ? dc[1].getRows() : -1L);
                    ldim2 = dc[0].colsKnown() ? dc[0].getCols() : (dc[1].getCols() > 1L ? dc[1].getCols() : -1L);
                }
                sp1 = dc[0].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, dc[0].getNonZeros()) : 1.0;
                double d = sp2 = dc[1].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, dc[1].getNonZeros()) : 1.0;
            }
            if (ldim1 >= 0L && ldim2 >= 0L) {
                if (OptimizerUtils.isBinaryOpConditionalSparseSafe(this.op) && input2 instanceof LiteralOp) {
                    long lnnz = (long)((double)(ldim1 * ldim2) * OptimizerUtils.getBinaryOpSparsityConditionalSparseSafe(sp1, this.op, (LiteralOp)input2));
                    ret = new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
                } else {
                    long lnnz = (long)((double)(ldim1 * ldim2) * OptimizerUtils.getBinaryOpSparsity(sp1, sp2, this.op, !this.outer));
                    ret = new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        this.checkAndSetForcedPlatform();
        Types.DataType dt1 = this.getInput().get(0).getDataType();
        Types.DataType dt2 = this.getInput().get(1).getDataType();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            if (OptimizerUtils.isMemoryBasedOptLevel()) {
                this._etype = this.findExecTypeByMemEstimate();
            } else {
                this._etype = null;
                if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX) {
                    if (this.getInput().get(0).areDimsBelowThreshold() && this.getInput().get(1).areDimsBelowThreshold() || this.getInput().get(0).isVector() && this.getInput().get(1).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR) {
                    if (this.getInput().get(0).areDimsBelowThreshold() || this.getInput().get(0).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else if (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX) {
                    if (this.getInput().get(1).areDimsBelowThreshold() || this.getInput().get(1).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else {
                    this._etype = LopProperties.ExecType.CP;
                }
                if (this._etype == null) {
                    this._etype = LopProperties.ExecType.SPARK;
                }
            }
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._etype == LopProperties.ExecType.CP && this._etypeForced != LopProperties.ExecType.CP && this.getDataType().isMatrix() && (dt1.isScalar() || dt2.isScalar()) && this.supportsMatrixScalarOperations() && !(this.getInput().get(dt1.isScalar() ? 1 : 0) instanceof DataOp) && this.getInput().get(dt1.isScalar() ? 1 : 0).getParent().size() == 1 && !HopRewriteUtils.isSingleBlock(this.getInput().get(dt1.isScalar() ? 1 : 0)) && this.getInput().get(dt1.isScalar() ? 1 : 0).optFindExecType() == LopProperties.ExecType.SPARK) {
            this._etype = LopProperties.ExecType.SPARK;
        }
        if (this.op == Types.OpOp2.SOLVE) {
            this._etype = this.isGPUEnabled() ? LopProperties.ExecType.GPU : LopProperties.ExecType.CP;
        } else if (this.op == Types.OpOp2.CBIND && this.getDataType().isList() || this.op == Types.OpOp2.RBIND && this.getDataType().isList()) {
            this._etype = LopProperties.ExecType.CP;
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    public static Lop constructSPAppendLop(Hop left, Hop right, Types.DataType dt, Types.ValueType vt, boolean cbind, Hop current) {
        Lop ret = null;
        Lop offset = BinaryOp.createOffsetLop(left, cbind);
        AppendMethod am = BinaryOp.optFindAppendSPMethod(left.getDim1(), left.getDim2(), right.getDim1(), right.getDim2(), right.getBlocksize(), right.getNnz(), cbind, dt);
        switch (am) {
            case MR_MAPPEND: {
                ret = new AppendM(left.constructLops(), right.constructLops(), offset, current.getDataType(), current.getValueType(), cbind, false, LopProperties.ExecType.SPARK);
                break;
            }
            case MR_RAPPEND: {
                ret = new AppendR(left.constructLops(), right.constructLops(), current.getDataType(), current.getValueType(), cbind, LopProperties.ExecType.SPARK);
                break;
            }
            case MR_GAPPEND: {
                Lop offset2 = BinaryOp.createOffsetLop(right, cbind);
                ret = new AppendG(left.constructLops(), right.constructLops(), offset, offset2, current.getDataType(), current.getValueType(), cbind, LopProperties.ExecType.SPARK);
                break;
            }
            case SP_GAlignedAppend: {
                ret = new AppendGAlignedSP(left.constructLops(), right.constructLops(), offset, current.getDataType(), current.getValueType(), cbind);
                break;
            }
            default: {
                throw new HopsException("Invalid SP append method: " + (Object)((Object)am));
            }
        }
        ret.setAllPositions(current.getFilename(), current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
        return ret;
    }

    public static double footprintInMapper(long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2, long m1_rpb, long m1_cpb) {
        double footprint = 0.0;
        footprint += (double)OptimizerUtils.estimateSize(Math.min(m1_dim1, m1_rpb), Math.min(m1_dim2, m1_cpb));
        footprint += (double)OptimizerUtils.estimateSize(m2_dim1, m2_dim2);
        return footprint += (double)OptimizerUtils.estimateSize(Math.min(m1_dim1, m1_rpb), Math.min(m1_dim2 + m2_dim2, m1_cpb));
    }

    private static AppendMethod optFindAppendSPMethod(long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2, long m1_blen, long m2_nnz, boolean cbind, Types.DataType dt) {
        if (FORCED_APPEND_METHOD != null) {
            return FORCED_APPEND_METHOD;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (cbind && m2_dim2 <= m1_blen || !cbind && m2_dim1 <= m1_blen) && (dt == Types.DataType.MATRIX || dt == Types.DataType.FRAME && cbind) && OptimizerUtils.checkSparkBroadcastMemoryBudget(m2_dim1, m2_dim2, m1_blen, m2_nnz)) {
            return AppendMethod.MR_MAPPEND;
        }
        if (cbind && m1_dim2 >= 1L && m2_dim2 >= 0L && m1_dim2 + m2_dim2 <= m1_blen || !cbind && m1_dim1 >= 1L && m2_dim1 >= 0L && m1_dim1 + m2_dim1 <= m1_blen || dt == Types.DataType.FRAME) {
            return AppendMethod.MR_RAPPEND;
        }
        if (cbind && m1_dim2 % m1_blen == 0L || !cbind && m1_dim1 % m1_blen == 0L) {
            return AppendMethod.SP_GAlignedAppend;
        }
        return AppendMethod.MR_GAPPEND;
    }

    public static boolean requiresReplication(Hop left, Hop right) {
        return left.getDim2() < 1L || right.getDim2() < 1L || left.getDim2() > 1L && right.getDim2() == 1L && left.getDim2() >= (long)left.getBlocksize() || left.getDim1() > 1L && right.getDim1() == 1L && left.getDim1() >= (long)left.getBlocksize();
    }

    private static MMBinaryMethod optFindMMBinaryMethodSpark(Hop left, Hop right) {
        double size;
        if (left._dataType == Types.DataType.TENSOR && right._dataType == Types.DataType.TENSOR || left._dataType == Types.DataType.FRAME && right._dataType == Types.DataType.FRAME) {
            return MMBinaryMethod.MR_BINARY_R;
        }
        long m1_dim1 = left.getDim1();
        long m1_dim2 = left.getDim2();
        long m2_dim1 = right.getDim1();
        long m2_dim2 = right.getDim2();
        long m1_blen = left.getBlocksize();
        if (OptimizerUtils.ALLOW_OPERATOR_FUSION && right instanceof AggUnaryOp && right.getInput().get(0) == left && (((AggUnaryOp)right).getDirection() == Types.Direction.Row && m1_dim2 > 1L && m1_dim2 <= m1_blen || ((AggUnaryOp)right).getDirection() == Types.Direction.Col && m1_dim1 > 1L && m1_dim1 <= m1_blen)) {
            return MMBinaryMethod.MR_BINARY_UAGG_CHAIN;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (m1_dim2 >= 1L && m2_dim2 == 1L || m1_dim1 >= 1L && m2_dim1 == 1L) && OptimizerUtils.checkSparkBroadcastMemoryBudget(size = (double)OptimizerUtils.estimateSize(m2_dim1, m2_dim2))) {
            return MMBinaryMethod.MR_BINARY_M;
        }
        return MMBinaryMethod.MR_BINARY_R;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        Types.DataType dt1 = input1.getDataType();
        Types.DataType dt2 = input2.getDataType();
        if (this.getDataType() == Types.DataType.SCALAR) {
            this.setDim1(0L);
            this.setDim2(0L);
        } else if (this.op == Types.OpOp2.CBIND) {
            this.setDim1(input1.rowsKnown() ? input1.getDim1() : input2.getDim1());
            if (input1.colsKnown() && input2.colsKnown()) {
                this.setDim2(input1.getDim2() + input2.getDim2());
            } else {
                this.setDim2(-1L);
            }
            if (input1.getNnz() > 0L && input2.getNnz() > 0L) {
                this.setNnz(input1.getNnz() + input2.getNnz());
            } else {
                this.setNnz(-1L);
            }
        } else if (this.op == Types.OpOp2.RBIND) {
            this.setDim2(this.colsKnown() ? input1.getDim2() : input2.getDim2());
            if (input1.rowsKnown() && input2.rowsKnown()) {
                this.setDim1(input1.getDim1() + input2.getDim1());
            } else {
                this.setDim1(-1L);
            }
            if (input1.getNnz() > 0L && input2.getNnz() > 0L) {
                this.setNnz(input1.getNnz() + input2.getNnz());
            } else {
                this.setNnz(-1L);
            }
        } else if (this.op == Types.OpOp2.SOLVE) {
            this.setDim1(input1.getDim2());
            this.setDim2(input2.getDim2());
        } else {
            long ldim2;
            long ldim1;
            long lnnz1 = -1L;
            if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR) {
                ldim1 = input1.getDim1();
                ldim2 = input1.getDim2();
                lnnz1 = input1.getNnz();
            } else if (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX) {
                ldim1 = input2.getDim1();
                ldim2 = input2.getDim2();
            } else if (this.outer) {
                ldim1 = input1.getDim1();
                ldim2 = input2.getDim2();
            } else {
                long l = input1.rowsKnown() ? input1.getDim1() : (ldim1 = input2.getDim1() > 1L ? input2.getDim1() : -1L);
                ldim2 = input1.colsKnown() ? input1.getDim2() : (input2.getDim2() > 1L ? input2.getDim2() : -1L);
                lnnz1 = input1.getNnz();
            }
            this.setDim1(ldim1);
            this.setDim2(ldim2);
            if (this.op == Types.OpOp2.POW || input2 instanceof LiteralOp && OptimizerUtils.isBinaryOpConditionalSparseSafeExact(this.op, (LiteralOp)input2)) {
                this.setNnz(lnnz1);
            } else if ((this.op == Types.OpOp2.PLUS || this.op == Types.OpOp2.MINUS) && (input1.getNnz() == 0L && input2.getNnz() >= 0L || input1.getNnz() >= 0L && input2.getNnz() == 0L)) {
                this.setNnz(input1.getNnz() + input2.getNnz());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryOp ret = new BinaryOp();
        ret.clone(this, false);
        ret.op = this.op;
        ret.outer = this.outer;
        ret._maxNumThreads = this._maxNumThreads;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof BinaryOp)) {
            return false;
        }
        if (this.op == Types.OpOp2.MAP) {
            return false;
        }
        BinaryOp that2 = (BinaryOp)that;
        return this.op == that2.op && this.outer == that2.outer && this._maxNumThreads == that2._maxNumThreads && this.getInput().get(0) == that2.getInput().get(0) && this.getInput().get(1) == that2.getInput().get(1);
    }

    public boolean supportsMatrixScalarOperations() {
        return this.op == Types.OpOp2.PLUS || this.op == Types.OpOp2.MINUS || this.op == Types.OpOp2.MULT || this.op == Types.OpOp2.DIV || this.op == Types.OpOp2.MODULUS || this.op == Types.OpOp2.INTDIV || this.op == Types.OpOp2.LESS || this.op == Types.OpOp2.LESSEQUAL || this.op == Types.OpOp2.GREATER || this.op == Types.OpOp2.GREATEREQUAL || this.op == Types.OpOp2.EQUAL || this.op == Types.OpOp2.NOTEQUAL || this.op == Types.OpOp2.MIN || this.op == Types.OpOp2.MAX || this.op == Types.OpOp2.LOG || this.op == Types.OpOp2.POW || this.op == Types.OpOp2.AND || this.op == Types.OpOp2.OR || this.op == Types.OpOp2.XOR || this.op == Types.OpOp2.BITWAND || this.op == Types.OpOp2.BITWOR || this.op == Types.OpOp2.BITWXOR || this.op == Types.OpOp2.BITWSHIFTL || this.op == Types.OpOp2.BITWSHIFTR;
    }

    public boolean isPPredOperation() {
        return this.op == Types.OpOp2.LESS || this.op == Types.OpOp2.LESSEQUAL || this.op == Types.OpOp2.GREATER || this.op == Types.OpOp2.GREATEREQUAL || this.op == Types.OpOp2.EQUAL || this.op == Types.OpOp2.NOTEQUAL;
    }

    public Types.OpOp2 getComplementPPredOperation() {
        switch (this.op) {
            case LESS: {
                return Types.OpOp2.GREATEREQUAL;
            }
            case LESSEQUAL: {
                return Types.OpOp2.GREATER;
            }
            case GREATER: {
                return Types.OpOp2.LESSEQUAL;
            }
            case GREATEREQUAL: {
                return Types.OpOp2.LESS;
            }
            case EQUAL: {
                return Types.OpOp2.NOTEQUAL;
            }
            case NOTEQUAL: {
                return Types.OpOp2.EQUAL;
            }
        }
        throw new HopsException("BinaryOp is not a ppred operation.");
    }

    public static enum MMBinaryMethod {
        CP_BINARY,
        MR_BINARY_R,
        MR_BINARY_M,
        MR_BINARY_OUTER_M,
        MR_BINARY_OUTER_R,
        MR_BINARY_UAGG_CHAIN;

    }

    public static enum AppendMethod {
        CP_APPEND,
        MR_MAPPEND,
        MR_RAPPEND,
        MR_GAPPEND,
        SP_GAlignedAppend;

    }
}

