/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ColGroupOffset
extends ColGroupValue {
    private static final long serialVersionUID = -1635828933479403125L;
    protected int[] _ptr;
    protected char[] _data;

    protected ColGroupOffset() {
    }

    protected ColGroupOffset(int[] colIndices, int numRows, ABitmap ubm, CompressionSettings cs) {
        super(colIndices, numRows, ubm, cs);
    }

    protected ColGroupOffset(int[] colIndices, int numRows, boolean zeros, ADictionary dict) {
        super(colIndices, numRows, dict);
        this._zeros = zeros;
    }

    protected final int len(int k) {
        return this._ptr[k + 1] - this._ptr[k];
    }

    protected void createCompressedBitmaps(int numVals, int totalLen, char[][] lbitmaps) {
        this._ptr = new int[numVals + 1];
        this._data = new char[totalLen];
        int off = 0;
        for (int i = 0; i < numVals; ++i) {
            int len = lbitmaps[i].length;
            this._ptr[i] = off;
            System.arraycopy(lbitmaps[i], 0, this._data, off, len);
            off += len;
        }
        this._ptr[numVals] = totalLen;
    }

    @Override
    public long estimateInMemorySize() {
        if (this._data == null) {
            return ColGroupSizes.estimateInMemorySizeOffset(this.getNumCols(), this._colIndexes.length, 0, 0, this.isLossy());
        }
        return ColGroupSizes.estimateInMemorySizeOffset(this.getNumCols(), this.getValues().length, this._ptr.length, this._data.length, this.isLossy());
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int[] colIndices = this.getColIndices();
        double[] values = this.getValues();
        block0: for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                if (row < rl) continue;
                if (row > ru) continue block0;
                for (int colIx = 0; colIx < numCols; ++colIx) {
                    target.appendValue(row, colIndices[colIx], values[valOff + colIx]);
                }
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colIndexTargets) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                for (int colIx = 0; colIx < numCols; ++colIx) {
                    int origMatrixColIx = this.getColIndex(colIx);
                    int targetColIx = colIndexTargets[origMatrixColIx];
                    target.quickSetValue(row, targetColIx, values[valOff + colIx]);
                }
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                target.quickSetValue(row, 0, values[valOff + colpos]);
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in bitmap group.");
        }
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        block0: for (int i = 0; i < numVals; ++i) {
            Iterator<Integer> decoder = this.getIterator(i);
            int valOff = i * numCols;
            while (decoder.hasNext()) {
                int row = decoder.next();
                if (row == r) {
                    return values[valOff + ix];
                }
                if (row <= r) continue;
                continue block0;
            }
        }
        return 0.0;
    }

    protected final void sumAllValues(double[] b, double[] c) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        double[] values = this.getValues();
        int i = 0;
        int off = 0;
        while (i < numCols) {
            LinearAlgebraUtils.vectMultiplyAdd(b[i], values, c, off, 0, numVals);
            ++i;
            off += numVals;
        }
    }

    protected final double mxxValues(int bitmapIx, Builtin builtin, double[] values) {
        int numCols = this.getNumCols();
        int valOff = bitmapIx * numCols;
        double val = builtin.getBuiltinCode() == Builtin.BuiltinCode.MAX ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (int i = 0; i < numCols; ++i) {
            val = builtin.execute(val, values[valOff + i]);
        }
        return val;
    }

    public char[] getBitmaps() {
        return this._data;
    }

    public int[] getBitmapOffsets() {
        return this._ptr;
    }

    public boolean hasZeros() {
        return this._zeros;
    }

    protected int[] computeOffsets(boolean[] ind) {
        int numOffsets = 0;
        for (int i = 0; i < ind.length; ++i) {
            numOffsets += ind[i] ? 1 : 0;
        }
        int[] ret = new int[numOffsets];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!ind[i]) continue;
            ret[pos++] = i;
        }
        return ret;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._ptr = new int[in.readInt()];
        for (int i = 0; i < this._ptr.length; ++i) {
            this._ptr[i] = in.readInt();
        }
        int totalLen = in.readInt();
        this._data = new char[totalLen];
        for (int i = 0; i < totalLen; ++i) {
            this._data[i] = in.readChar();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeInt(this._ptr.length);
        for (i = 0; i < this._ptr.length; ++i) {
            out.writeInt(this._ptr[i]);
        }
        out.writeInt(this._data.length);
        for (i = 0; i < this._data.length; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += 4L;
        ret += (long)(4 * this._ptr.length);
        ret += 4L;
        return ret += (long)(2 * this._data.length);
    }

    protected abstract boolean[] computeZeroIndicatorVector();

    @Override
    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros, boolean rowMajor) {
        if (rowMajor) {
            return new OffsetRowIterator(rl, ru, inclZeros);
        }
        return new OffsetValueIterator(rl, ru, inclZeros);
    }

    public abstract Iterator<Integer> getIterator(int var1);

    public abstract Iterator<Integer> getIterator(int var1, int var2, int var3);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d ", "Pointers:", this._ptr.length));
        sb.append(Arrays.toString(this._ptr));
        sb.append(String.format("\n%15s%5d ", "Data:", this._data.length));
        sb.append("[");
        for (int x = 0; x < this._data.length; ++x) {
            sb.append((int)this._data[x]);
            if (x == this._data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected class OffsetRowIterator
    implements Iterator<IJV> {
        private final int _rl;
        private final int _ru;
        private final boolean _inclZeros;
        private final Iterator<Integer>[] _iters;
        private final IJV _ret = new IJV();
        private final HashMap<Integer, Integer> _ixbuff = new HashMap();
        private int _rpos;
        private int _cpos;
        private int _vpos;

        public OffsetRowIterator(int rl, int ru, boolean inclZeros) {
            int k;
            this._rl = rl;
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._iters = new Iterator[ColGroupOffset.this.getNumValues()];
            for (k = 0; k < ColGroupOffset.this.getNumValues(); ++k) {
                this._iters[k] = ColGroupOffset.this.getIterator(k, this._rl, this._ru);
            }
            for (k = 0; k < ColGroupOffset.this.getNumValues(); ++k) {
                this._ixbuff.put(this._iters[k].hasNext() ? this._iters[k].next() : Integer.valueOf(this._ru + k), k);
            }
            this._rpos = rl - 1;
            this._cpos = ColGroupOffset.this.getNumCols() - 1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more offset entries.");
            }
            this._ret.set(this._rpos, ColGroupOffset.this._colIndexes[this._cpos], this._vpos < 0 ? 0.0 : ColGroupOffset.this._dict.getValue(this._vpos * ColGroupOffset.this.getNumCols() + this._cpos));
            this.getNextValue();
            return this._ret;
        }

        private void getNextValue() {
            do {
                if (this._cpos + 1 >= ColGroupOffset.this.getNumCols()) {
                    ++this._rpos;
                    this._cpos = -1;
                    this._vpos = -1;
                    Integer ktmp = this._ixbuff.remove(this._rpos);
                    if (ktmp != null) {
                        this._ixbuff.put(this._iters[ktmp].hasNext() ? this._iters[ktmp].next() : Integer.valueOf(this._ru + ktmp), ktmp);
                        this._vpos = ktmp;
                    }
                }
                if (this._rpos >= this._ru) {
                    return;
                }
                ++this._cpos;
            } while (!this._inclZeros && (this._vpos < 0 || ColGroupOffset.this._dict.getValue(this._vpos * ColGroupOffset.this.getNumCols() + this._cpos) == 0.0));
        }
    }

    protected class ZeroValueIterator
    implements Iterator<Integer> {
        private final boolean[] _zeroVect;
        private final int _ru;
        private int _rpos;

        public ZeroValueIterator(int rl, int ru) {
            this._zeroVect = ColGroupOffset.this.computeZeroIndicatorVector();
            this._ru = ru;
            this._rpos = rl - 1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            int ret = this._rpos;
            this.getNextValue();
            return ret;
        }

        private void getNextValue() {
            do {
                ++this._rpos;
            } while (this._rpos < this._ru && !this._zeroVect[this._rpos]);
        }
    }

    protected class OffsetValueIterator
    implements Iterator<IJV> {
        private final int _rl;
        private final int _ru;
        private final boolean _inclZeros;
        private final IJV _buff = new IJV();
        private Iterator<Integer> _viter = null;
        private int _vpos = -1;
        private int _rpos = -1;
        private int _cpos = -1;

        public OffsetValueIterator(int rl, int ru, boolean inclZeros) {
            this._rl = rl;
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._vpos = -1;
            this._rpos = -1;
            this._cpos = 0;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more offset entries.");
            }
            this._buff.set(this._rpos, ColGroupOffset.this._colIndexes[this._cpos], this._vpos >= ColGroupOffset.this.getNumValues() ? 0.0 : ColGroupOffset.this._dict.getValue(this._vpos * ColGroupOffset.this.getNumCols() + this._cpos));
            this.getNextValue();
            return this._buff;
        }

        private void getNextValue() {
            if (this._viter != null && this._viter instanceof ZeroValueIterator && !this._viter.hasNext()) {
                this._rpos = this._ru;
                return;
            }
            if (!(this._rpos >= 0 && this._cpos + 1 < ColGroupOffset.this.getNumCols() || this._viter != null && this._viter.hasNext())) {
                do {
                    ++this._vpos;
                    if (this._vpos < ColGroupOffset.this.getNumValues()) {
                        this._viter = ColGroupOffset.this.getIterator(this._vpos, this._rl, this._ru);
                        continue;
                    }
                    if (this._inclZeros && ColGroupOffset.this._zeros) {
                        this._viter = new ZeroValueIterator(this._rl, this._ru);
                        continue;
                    }
                    this._rpos = this._ru;
                    return;
                } while (!this._viter.hasNext());
                this._rpos = -1;
            }
            if (this._rpos < 0 || this._cpos + 1 >= ColGroupOffset.this.getNumCols()) {
                this._rpos = this._viter.next();
                this._cpos = 0;
            } else {
                ++this._cpos;
            }
        }
    }
}

