/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileAsTextRecordReader
extends RecordReader<Text, Text> {
    private final SequenceFileRecordReader<WritableComparable<?>, Writable> sequenceFileRecordReader = new SequenceFileRecordReader();
    private Text key;
    private Text value;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.sequenceFileRecordReader.initialize(split, context);
    }

    @Override
    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    @Override
    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    @Override
    public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.sequenceFileRecordReader.nextKeyValue()) {
            return false;
        }
        if (this.key == null) {
            this.key = new Text();
        }
        if (this.value == null) {
            this.value = new Text();
        }
        this.key.set(this.sequenceFileRecordReader.getCurrentKey().toString());
        this.value.set(this.sequenceFileRecordReader.getCurrentValue().toString());
        return true;
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.sequenceFileRecordReader.getProgress();
    }

    @Override
    public synchronized void close() throws IOException {
        this.sequenceFileRecordReader.close();
    }
}

