/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.URLPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalResourcePBImpl
extends LocalResource {
    YarnProtos.LocalResourceProto proto = YarnProtos.LocalResourceProto.getDefaultInstance();
    YarnProtos.LocalResourceProto.Builder builder = null;
    boolean viaProto = false;
    private URL url = null;

    public LocalResourcePBImpl() {
        this.builder = YarnProtos.LocalResourceProto.newBuilder();
    }

    public LocalResourcePBImpl(YarnProtos.LocalResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.LocalResourceProto getProto() {
        this.mergeLocalToBuilder();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((LocalResourcePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private synchronized void mergeLocalToBuilder() {
        YarnProtos.LocalResourceProto l;
        Object object = l = this.viaProto ? this.proto : this.builder;
        if (this.url != null && !l.getResource().equals((Object)((URLPBImpl)this.url).getProto())) {
            this.maybeInitBuilder();
            l = this.builder;
            this.builder.setResource(this.convertToProtoFormat(this.url));
        }
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.LocalResourceProto.newBuilder((YarnProtos.LocalResourceProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized long getSize() {
        YarnProtos.LocalResourceProto p = this.viaProto ? this.proto : this.builder;
        return p.getSize();
    }

    public synchronized void setSize(long size) {
        this.maybeInitBuilder();
        this.builder.setSize(size);
    }

    public synchronized long getTimestamp() {
        YarnProtos.LocalResourceProto p = this.viaProto ? this.proto : this.builder;
        return p.getTimestamp();
    }

    public synchronized void setTimestamp(long timestamp) {
        this.maybeInitBuilder();
        this.builder.setTimestamp(timestamp);
    }

    public synchronized LocalResourceType getType() {
        YarnProtos.LocalResourceProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasType()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getType());
    }

    public synchronized void setType(LocalResourceType type) {
        this.maybeInitBuilder();
        if (type == null) {
            this.builder.clearType();
            return;
        }
        this.builder.setType(this.convertToProtoFormat(type));
    }

    public synchronized URL getResource() {
        YarnProtos.LocalResourceProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.url != null) {
            return this.url;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.url = this.convertFromProtoFormat(p.getResource());
        return this.url;
    }

    public synchronized void setResource(URL resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.url = resource;
    }

    public synchronized LocalResourceVisibility getVisibility() {
        YarnProtos.LocalResourceProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasVisibility()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getVisibility());
    }

    public synchronized void setVisibility(LocalResourceVisibility visibility) {
        this.maybeInitBuilder();
        if (visibility == null) {
            this.builder.clearVisibility();
            return;
        }
        this.builder.setVisibility(this.convertToProtoFormat(visibility));
    }

    public synchronized String getPattern() {
        YarnProtos.LocalResourceProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasPattern()) {
            return null;
        }
        return p.getPattern();
    }

    public synchronized void setPattern(String pattern) {
        this.maybeInitBuilder();
        if (pattern == null) {
            this.builder.clearPattern();
            return;
        }
        this.builder.setPattern(pattern);
    }

    private YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private URLPBImpl convertFromProtoFormat(YarnProtos.URLProto p) {
        return new URLPBImpl(p);
    }

    private YarnProtos.URLProto convertToProtoFormat(URL t) {
        return ((URLPBImpl)t).getProto();
    }

    private YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }
}

