/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLOptions;
import org.apache.sysds.api.ScriptExecutorUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DMLTranslator;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParserFactory;
import org.apache.sysds.parser.ParserWrapper;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorker;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.privacy.CheckedConstraintsLog;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.LocalFileUtils;
import org.apache.sysds.utils.Explain;
import org.apache.sysds.utils.NativeHelper;
import org.apache.sysds.utils.Statistics;

public class DMLScript {
    private static Types.ExecMode EXEC_MODE = DMLOptions.defaultOptions.execMode;
    public static boolean STATISTICS = DMLOptions.defaultOptions.stats;
    public static boolean JMLC_MEM_STATISTICS = false;
    public static int STATISTICS_COUNT = DMLOptions.defaultOptions.statsCount;
    public static int STATISTICS_MAX_WRAP_LEN = 30;
    public static Explain.ExplainType EXPLAIN = DMLOptions.defaultOptions.explainType;
    public static String DML_FILE_PATH_ANTLR_PARSER = DMLOptions.defaultOptions.filePath;
    public static String FLOATING_POINT_PRECISION = "double";
    public static boolean PRINT_GPU_MEMORY_INFO = false;
    public static long EVICTION_SHADOW_BUFFER_MAX_BYTES = 0L;
    public static long EVICTION_SHADOW_BUFFER_CURR_BYTES = 0L;
    public static double GPU_MEMORY_UTILIZATION_FACTOR = 0.9;
    public static String GPU_MEMORY_ALLOCATOR = "cuda";
    public static boolean LINEAGE = DMLOptions.defaultOptions.lineage;
    public static boolean LINEAGE_DEDUP = DMLOptions.defaultOptions.lineage_dedup;
    public static LineageCacheConfig.ReuseCacheType LINEAGE_REUSE = DMLOptions.defaultOptions.linReuseType;
    public static LineageCacheConfig.LineageCachePolicy LINEAGE_POLICY = DMLOptions.defaultOptions.linCachePolicy;
    public static boolean LINEAGE_ESTIMATE = DMLOptions.defaultOptions.lineage_estimate;
    public static boolean LINEAGE_DEBUGGER = DMLOptions.defaultOptions.lineage_debugger;
    public static boolean CHECK_PRIVACY = DMLOptions.defaultOptions.checkPrivacy;
    public static boolean USE_ACCELERATOR = DMLOptions.defaultOptions.gpu;
    public static boolean FORCE_ACCELERATOR = DMLOptions.defaultOptions.forceGPU;
    public static boolean SYNCHRONIZE_GPU = true;
    public static boolean EAGER_CUDA_FREE = false;
    public static boolean _suppressPrint2Stdout = false;
    public static boolean USE_LOCAL_SPARK_CONFIG = false;
    public static boolean _activeAM = false;
    public static boolean VALIDATOR_IGNORE_ISSUES = false;
    public static String _uuid = IDHandler.createDistributedUniqueID();
    private static final Log LOG = LogFactory.getLog((String)DMLScript.class.getName());

    public static String getUUID() {
        return _uuid;
    }

    public static void setUUID(String uuid) {
        _uuid = uuid;
    }

    public static boolean suppressPrint2Stdout() {
        return _suppressPrint2Stdout;
    }

    public static void setActiveAM() {
        _activeAM = true;
    }

    public static boolean isActiveAM() {
        return _activeAM;
    }

    public static void main(String[] args) {
        try {
            Configuration conf = new Configuration((Configuration)ConfigurationManager.getCachedJobConf());
            String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
            DMLScript.executeScript(conf, otherArgs);
        }
        catch (Exception e) {
            DMLScript.errorPrint(e);
            for (String s : args) {
                if (!s.trim().contains("-debug")) continue;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeScript(Configuration conf, String[] args) throws IOException, ParseException, DMLScriptException {
        Types.ExecMode oldrtplatform = EXEC_MODE;
        Explain.ExplainType oldexplain = EXPLAIN;
        DMLOptions dmlOptions = null;
        try {
            dmlOptions = DMLOptions.parseCLArguments(args);
        }
        catch (AlreadySelectedException e) {
            LOG.error((Object)("Mutually exclusive options were selected. " + e.getMessage()));
            return false;
        }
        catch (org.apache.commons.cli.ParseException e) {
            LOG.error((Object)("Parsing Exception " + e.getMessage()));
            return false;
        }
        try {
            STATISTICS = dmlOptions.stats;
            STATISTICS_COUNT = dmlOptions.statsCount;
            JMLC_MEM_STATISTICS = dmlOptions.memStats;
            USE_ACCELERATOR = dmlOptions.gpu;
            FORCE_ACCELERATOR = dmlOptions.forceGPU;
            EXPLAIN = dmlOptions.explainType;
            EXEC_MODE = dmlOptions.execMode;
            LINEAGE = dmlOptions.lineage;
            LINEAGE_DEDUP = dmlOptions.lineage_dedup;
            LINEAGE_REUSE = dmlOptions.linReuseType;
            LINEAGE_POLICY = dmlOptions.linCachePolicy;
            LINEAGE_ESTIMATE = dmlOptions.lineage_estimate;
            CHECK_PRIVACY = dmlOptions.checkPrivacy;
            LINEAGE_DEBUGGER = dmlOptions.lineage_debugger;
            String fnameOptConfig = dmlOptions.configFile;
            boolean isFile = dmlOptions.filePath != null;
            String fileOrScript = isFile ? dmlOptions.filePath : dmlOptions.script;
            boolean help = dmlOptions.help;
            if (help) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("systemds", dmlOptions.options);
                boolean bl = true;
                return bl;
            }
            if (dmlOptions.clean) {
                DMLScript.cleanSystemDSWorkspace();
                boolean formatter = true;
                return formatter;
            }
            if (dmlOptions.fedWorker) {
                DMLScript.loadConfiguration(fnameOptConfig);
                try {
                    new FederatedWorker(dmlOptions.fedWorkerPort).run();
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                }
                boolean e = true;
                return e;
            }
            LineageCacheConfig.setConfig(LINEAGE_REUSE);
            LineageCacheConfig.setCachePolicy(LINEAGE_POLICY);
            LineageCacheConfig.setEstimator(LINEAGE_ESTIMATE);
            String dmlScriptStr = DMLScript.readDMLScript(isFile, fileOrScript);
            Map<String, String> argVals = dmlOptions.argVals;
            DML_FILE_PATH_ANTLR_PARSER = dmlOptions.filePath;
            DMLScript.printInvocationInfo(fileOrScript, fnameOptConfig, argVals);
            DMLScript.execute(dmlScriptStr, fnameOptConfig, argVals, args);
        }
        finally {
            DMLScript.setGlobalExecMode(oldrtplatform);
            EXPLAIN = oldexplain;
        }
        return true;
    }

    protected static String readDMLScript(boolean isFile, String scriptOrFilename) throws IOException {
        String dmlScriptStr;
        block21: {
            block22: {
                if (!isFile) break block22;
                String fileName = scriptOrFilename;
                if (fileName == null) {
                    throw new LanguageException("DML script path was not specified!");
                }
                StringBuilder sb = new StringBuilder();
                BufferedReader in = null;
                try {
                    if (fileName.startsWith("hdfs:") || fileName.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(fileName))) {
                        Path scriptPath = new Path(fileName);
                        FileSystem fs = IOUtilFunctions.getFileSystem(scriptPath);
                        in = new BufferedReader(new InputStreamReader((InputStream)fs.open(scriptPath)));
                    } else {
                        in = new BufferedReader(new FileReader(fileName));
                    }
                    String tmp = null;
                    while ((tmp = in.readLine()) != null) {
                        sb.append(tmp);
                        sb.append("\n");
                    }
                }
                catch (IOException ex) {
                    try {
                        LOG.error((Object)"Failed to read the script from the file system", (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(in);
                        throw throwable;
                    }
                }
                IOUtilFunctions.closeSilently(in);
                dmlScriptStr = sb.toString();
                break block21;
            }
            String scriptString = scriptOrFilename;
            if (scriptString == null) {
                throw new LanguageException("DML script was not specified!");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(scriptString.getBytes());
            try (Scanner scan = new Scanner(is);){
                dmlScriptStr = scan.useDelimiter("\\A").next();
            }
        }
        return dmlScriptStr;
    }

    private static void loadConfiguration(String fnameOptConfig) throws IOException {
        DMLConfig dmlconf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(dmlconf);
        CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
        ConfigurationManager.setGlobalConfig(cconf);
        LOG.debug((Object)("\nDML config: \n" + dmlconf.getConfigInfo()));
        DMLScript.setGlobalFlags(dmlconf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, String[] allArgs) throws IOException {
        DMLScript.printStartExecInfo(dmlScriptStr);
        DMLScript.loadConfiguration(fnameOptConfig);
        DMLScript.configureCodeGen();
        Statistics.startCompileTimer();
        ParserWrapper parser = ParserFactory.createParser();
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        DMLScript.initHadoopExecution(ConfigurationManager.getDMLConfig());
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        Program rtprog = dmlt.getRuntimeProgram(prog, ConfigurationManager.getDMLConfig());
        Explain.ExplainCounts counts = Explain.countDistributedOperations(rtprog);
        Statistics.resetNoOfCompiledJobs(counts.numJobs);
        if (EXPLAIN != Explain.ExplainType.NONE) {
            System.out.println(Explain.display(prog, rtprog, EXPLAIN, counts));
        }
        Statistics.stopCompileTimer();
        ExecutionContext ec = null;
        try {
            ec = ExecutionContextFactory.createContext(rtprog);
            ScriptExecutorUtils.executeRuntimeProgram(rtprog, ec, ConfigurationManager.getDMLConfig(), STATISTICS ? STATISTICS_COUNT : 0, null);
        }
        finally {
            if (ec != null && ec instanceof SparkExecutionContext) {
                ((SparkExecutionContext)ec).close();
            }
            LOG.info((Object)("END DML run " + DMLScript.getDateTime()));
            DMLScript.cleanupHadoopExecution(ConfigurationManager.getDMLConfig());
        }
    }

    public static void setGlobalFlags(DMLConfig dmlconf) {
        GPUContextPool.AVAILABLE_GPUS = dmlconf.getTextValue("sysds.gpu.availableGPUs");
        STATISTICS_MAX_WRAP_LEN = dmlconf.getIntValue("sysds.stats.maxWrapLength");
        NativeHelper.initialize(dmlconf.getTextValue("sysds.native.blas.directory"), dmlconf.getTextValue("sysds.native.blas").trim());
        SYNCHRONIZE_GPU = dmlconf.getBooleanValue("sysds.gpu.sync.postProcess");
        EAGER_CUDA_FREE = dmlconf.getBooleanValue("sysds.gpu.eager.cudaFree");
        PRINT_GPU_MEMORY_INFO = dmlconf.getBooleanValue("sysds.gpu.print.memoryInfo");
        GPU_MEMORY_UTILIZATION_FACTOR = dmlconf.getDoubleValue("sysds.gpu.memory.util.factor");
        GPU_MEMORY_ALLOCATOR = dmlconf.getTextValue("sysds.gpu.memory.allocator");
        if (GPU_MEMORY_UTILIZATION_FACTOR < 0.0) {
            throw new RuntimeException("Incorrect value (" + GPU_MEMORY_UTILIZATION_FACTOR + ") for the configuration:" + "sysds.gpu.memory.util.factor");
        }
        FLOATING_POINT_PRECISION = dmlconf.getTextValue("sysds.floating.point.precision");
        LibMatrixCUDA.resetFloatingPointPrecision();
        if (FLOATING_POINT_PRECISION.equals("double")) {
            EVICTION_SHADOW_BUFFER_MAX_BYTES = 0L;
        } else {
            double shadowBufferSize = dmlconf.getDoubleValue("sysds.gpu.eviction.shadow.bufferSize");
            if (shadowBufferSize < 0.0 || shadowBufferSize > 1.0) {
                throw new RuntimeException("Incorrect value (" + shadowBufferSize + ") for the configuration:" + "sysds.gpu.eviction.shadow.bufferSize");
            }
            EVICTION_SHADOW_BUFFER_MAX_BYTES = (long)((double)InfrastructureAnalyzer.getLocalMaxMemory() * shadowBufferSize);
            if (EVICTION_SHADOW_BUFFER_MAX_BYTES > 0L && EVICTION_SHADOW_BUFFER_CURR_BYTES > EVICTION_SHADOW_BUFFER_MAX_BYTES) {
                System.out.println("WARN: Cannot use the shadow buffer due to potentially cached GPU objects. Current shadow buffer size (in bytes):" + EVICTION_SHADOW_BUFFER_CURR_BYTES + " > Max shadow buffer size (in bytes):" + EVICTION_SHADOW_BUFFER_MAX_BYTES);
            }
        }
    }

    public static void initHadoopExecution(DMLConfig config) throws IOException, ParseException, DMLRuntimeException {
        String scratch = config.getTextValue("sysds.scratch");
        HDFSTool.createDirIfNotExistOnHDFS(scratch, "777");
        DMLScript.cleanupHadoopExecution(config);
        LocalFileUtils.createWorkingDirectory();
        CacheableData.initCaching();
        Statistics.resetNoOfExecutedJobs();
        if (STATISTICS) {
            Statistics.reset();
        }
        if (CHECK_PRIVACY) {
            CheckedConstraintsLog.reset();
        }
    }

    public static void cleanupHadoopExecution(DMLConfig config) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        String dirSuffix = sb.toString();
        FederatedData.clearFederatedWorkers();
        HDFSTool.deleteFileIfExistOnHDFS(config.getTextValue("sysds.scratch") + dirSuffix);
        CacheableData.cleanupCacheDir();
        LocalFileUtils.cleanupWorkingDirectory();
    }

    private static void printInvocationInfo(String fnameScript, String fnameOptConfig, Map<String, String> argVals) {
        LOG.debug((Object)("****** args to DML Script ******\nUUID: " + DMLScript.getUUID() + "\nSCRIPT PATH: " + fnameScript + "\nRUNTIME: " + (Object)((Object)DMLScript.getGlobalExecMode()) + "\nBUILTIN CONFIG: " + "./SystemDS-config.xml" + "\nOPTIONAL CONFIG: " + fnameOptConfig + "\n"));
        if (!argVals.isEmpty()) {
            LOG.debug((Object)"Script arguments are: \n");
            for (int i = 1; i <= argVals.size(); ++i) {
                LOG.debug((Object)("Script argument $" + i + " = " + argVals.get("$" + i)));
            }
        }
    }

    private static void printStartExecInfo(String dmlScriptString) {
        LOG.info((Object)("BEGIN DML run " + DMLScript.getDateTime()));
        LOG.debug((Object)("DML script: \n" + dmlScriptString));
    }

    private static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static void cleanSystemDSWorkspace() {
        try {
            String localtmp;
            DMLConfig conf = DMLConfig.readConfigurationFile(null);
            String scratch = conf.getTextValue("sysds.scratch");
            if (scratch != null) {
                HDFSTool.deleteFileIfExistOnHDFS(scratch);
            }
            if ((localtmp = conf.getTextValue("sysds.localtmpdir")) != null) {
                LocalFileUtils.cleanupRcWorkingDirectory(localtmp);
            }
        }
        catch (Exception ex) {
            throw new DMLException("Failed to run SystemDS workspace cleanup.", ex);
        }
    }

    public static Types.ExecMode getGlobalExecMode() {
        return EXEC_MODE;
    }

    public static void setGlobalExecMode(Types.ExecMode mode) {
        EXEC_MODE = mode;
    }

    public static void errorPrint(Exception e) {
        String ANSI_RED = "\u001b[31m";
        String ANSI_RESET = "\u001b[0m";
        StringBuilder sb = new StringBuilder();
        sb.append("\u001b[31m\n");
        sb.append("An Error Occured : ");
        sb.append("\n");
        sb.append(StringUtils.leftPad((String)e.getClass().getSimpleName(), (int)25));
        sb.append(" -- ");
        sb.append(e.getMessage());
        for (Throwable s = e.getCause(); s != null; s = s.getCause()) {
            sb.append("\n");
            sb.append(StringUtils.leftPad((String)s.getClass().getSimpleName(), (int)25));
            sb.append(" -- ");
            sb.append(s.getMessage());
        }
        sb.append("\n\u001b[0m");
        System.out.println(sb.toString());
    }

    private static void configureCodeGen() {
        if (ConfigurationManager.isCodegenEnabled()) {
            SpoofCompiler.GeneratorAPI configured_generator = SpoofCompiler.GeneratorAPI.valueOf(ConfigurationManager.getDMLConfig().getTextValue("sysds.codegen.api").toUpperCase());
            try {
                SpoofCompiler.loadNativeCodeGenerator(configured_generator);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to load native cuda codegen library\n" + e));
            }
        }
    }
}

