/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class CompressedSizeInfo {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeInfo.class.getName());
    public List<CompressedSizeInfoColGroup> compressionInfo;

    public CompressedSizeInfo(List<CompressedSizeInfoColGroup> compressionInfo) {
        this.compressionInfo = compressionInfo;
    }

    public CompressedSizeInfoColGroup getGroupInfo(int index) {
        return this.compressionInfo.get(index);
    }

    public List<CompressedSizeInfoColGroup> getInfo() {
        return this.compressionInfo;
    }

    public void setInfo(List<CompressedSizeInfoColGroup> info) {
        this.compressionInfo = info;
    }

    public long memoryEstimate() {
        long est = CompressedMatrixBlock.baseSizeInMemory();
        for (CompressedSizeInfoColGroup csi : this.compressionInfo) {
            est += csi.getMinSize();
        }
        return est;
    }

    public int getNumberColGroups() {
        return this.compressionInfo.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressedSizeInfo");
        for (CompressedSizeInfoColGroup g : this.compressionInfo) {
            sb.append("\n" + g.toString());
        }
        return sb.toString();
    }
}

