/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.WeightedDivMM;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWDivMMFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWDivMMFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, in4, out, opcode, instruction_str);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        Future<FederatedResponse>[] response;
        FederatedRequest frCleanup4;
        void var7_9;
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        WeightedDivMM.WDivMMType wdivmm_type = qop.wtype3;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixObject U = ec.getMatrixObject(this.input2);
        MatrixObject V = ec.getMatrixObject(this.input3);
        Object var7_7 = null;
        MatrixObject MX = null;
        if (qop.hasFourInputs()) {
            if (wdivmm_type == WeightedDivMM.WDivMMType.MULT_MINUS_4_LEFT || wdivmm_type == WeightedDivMM.WDivMMType.MULT_MINUS_4_RIGHT) {
                MX = ec.getMatrixObject(this._input4);
            } else {
                ScalarObject scalarObject;
                ScalarObject scalarObject2 = scalarObject = this._input4.getDataType() == Types.DataType.SCALAR ? ec.getScalarInput(this._input4) : new DoubleObject(ec.getMatrixInput(this._input4.getName()).quickGetValue(0, 0));
            }
        }
        if (!X.isFederated(FederationMap.FType.ROW) || U.isFederated() || V.isFederated()) throw new DMLRuntimeException("Unsupported federated inputs (X, U, V) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ")");
        FederationMap fedMap = X.getFedMapping();
        FederatedRequest[] frInit1 = fedMap.broadcastSliced(U, false);
        FederatedRequest frInit2 = fedMap.broadcast(V);
        FederatedRequest frInit3 = null;
        FederatedRequest[] frInit3Arr = null;
        FederatedRequest frCompute1 = null;
        if (var7_9 != null) {
            frInit3 = fedMap.broadcast((ScalarObject)var7_9);
            this.instString = this.instString.replace("true", "false");
            frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3, this._input4}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID(), frInit3.getID()});
        } else if (MX != null) {
            frInit3Arr = fedMap.broadcastSliced(MX, false);
            frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3, this._input4}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID(), frInit3Arr[0].getID()});
        } else {
            frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID()});
        }
        FederatedRequest frGet1 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frCompute1.getID());
        FederatedRequest frCleanup1 = fedMap.cleanup(this.getTID(), frCompute1.getID());
        FederatedRequest frCleanup2 = fedMap.cleanup(this.getTID(), frInit1[0].getID());
        FederatedRequest frCleanup3 = fedMap.cleanup(this.getTID(), frInit2.getID());
        if (frInit3 != null) {
            frCleanup4 = fedMap.cleanup(this.getTID(), frInit3.getID());
            response = fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2, frInit3, frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3, frCleanup4});
        } else if (frInit3Arr != null) {
            frCleanup4 = fedMap.cleanup(this.getTID(), frInit3Arr[0].getID());
            fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2});
            response = fedMap.execute(this.getTID(), true, frInit3Arr, new FederatedRequest[]{frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3, frCleanup4});
        } else {
            response = fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2, frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3});
        }
        if (wdivmm_type.isLeft()) {
            AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, response, fedMap));
            return;
        } else {
            if (!wdivmm_type.isRight() && !wdivmm_type.isBasic()) throw new DMLRuntimeException("Federated WDivMM only supported for BASIC, LEFT or RIGHT variants.");
            ec.setMatrixOutput(this.output.getName(), FederationUtils.bind(response, false));
        }
    }
}

