/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CLALibRightMultBy {
    private static final Log LOG = LogFactory.getLog((String)CLALibRightMultBy.class.getName());

    public static MatrixBlock rightMultByMatrix(CompressedMatrixBlock m1, MatrixBlock m2, MatrixBlock ret, int k, boolean allowOverlap) {
        ret = CLALibRightMultBy.rightMultByMatrix(m1.getColGroups(), m2, ret, k, m1.getMaxNumValues(), allowOverlap);
        ret.recomputeNonZeros();
        return ret;
    }

    private static MatrixBlock rightMultByMatrix(List<AColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, Pair<Integer, int[]> v, boolean allowOverlap) {
        MatrixBlock m;
        if (that instanceof CompressedMatrixBlock) {
            LOG.warn((Object)"Decompression Right matrix");
        }
        if ((m = CLALibRightMultBy.rightMultByMatrixOverlapping(colGroups, that = that instanceof CompressedMatrixBlock ? ((CompressedMatrixBlock)that).decompress(k) : that, ret, k, v)) instanceof CompressedMatrixBlock) {
            if (CLALibRightMultBy.allowOverlappingOutput(colGroups, allowOverlap)) {
                return m;
            }
            return ((CompressedMatrixBlock)m).decompress(k);
        }
        return m;
    }

    private static boolean allowOverlappingOutput(List<AColGroup> colGroups, boolean allowOverlap) {
        if (!allowOverlap) {
            LOG.debug((Object)"Not Overlapping because it is not allowed");
            return false;
        }
        return true;
    }

    private static MatrixBlock rightMultByMatrixOverlapping(List<AColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, Pair<Integer, int[]> v) {
        int rl = colGroups.get(0).getNumRows();
        int cl = that.getNumColumns();
        ret = new CompressedMatrixBlock(rl, cl);
        CompressedMatrixBlock retC = (CompressedMatrixBlock)ret;
        ret = CLALibRightMultBy.rightMultByMatrixCompressed(colGroups, that, retC, k, v);
        return ret;
    }

    private static MatrixBlock rightMultByMatrixCompressed(List<AColGroup> colGroups, MatrixBlock that, CompressedMatrixBlock ret, int k, Pair<Integer, int[]> v) {
        ColGroupEmpty cge;
        ArrayList<AColGroup> retCg = new ArrayList<AColGroup>();
        boolean containsNull = false;
        if (k == 1) {
            for (AColGroup g : colGroups) {
                AColGroup retG = g.rightMultByMatrix(that);
                if (retG != null) {
                    retCg.add(retG);
                    continue;
                }
                containsNull = true;
            }
        } else {
            ExecutorService pool = CommonThreadPool.get(k);
            try {
                ArrayList<RightMatrixMultTask> tasks = new ArrayList<RightMatrixMultTask>(colGroups.size());
                for (AColGroup aColGroup : colGroups) {
                    tasks.add(new RightMatrixMultTask(aColGroup, that));
                }
                for (Future future : pool.invokeAll(tasks)) {
                    AColGroup g = (AColGroup)future.get();
                    if (g != null) {
                        retCg.add(g);
                        continue;
                    }
                    containsNull = true;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new DMLRuntimeException(e);
            }
        }
        ret.allocateColGroupList(retCg);
        if (retCg.size() > 1) {
            ret.setOverlapping(true);
        }
        if (containsNull && (cge = CLALibRightMultBy.findEmptyColumnsAndMakeEmptyColGroup(retCg, ret.getNumColumns(), ret.getNumRows())) != null) {
            retCg.add(cge);
        }
        return ret;
    }

    private static ColGroupEmpty findEmptyColumnsAndMakeEmptyColGroup(List<AColGroup> colGroups, int nCols, int nRows) {
        HashSet<Integer> emptyColumns = new HashSet<Integer>(nCols);
        for (int i = 0; i < nCols; ++i) {
            emptyColumns.add(i);
        }
        for (AColGroup g : colGroups) {
            for (int c : g.getColIndices()) {
                emptyColumns.remove(c);
            }
        }
        if (emptyColumns.size() != 0) {
            int[] emptyColumnsFinal = emptyColumns.stream().mapToInt(Integer::intValue).toArray();
            return new ColGroupEmpty(emptyColumnsFinal, nRows);
        }
        return null;
    }

    private static class RightMatrixMultTask
    implements Callable<AColGroup> {
        private final AColGroup _colGroup;
        private final MatrixBlock _b;

        protected RightMatrixMultTask(AColGroup colGroup, MatrixBlock b) {
            this._colGroup = colGroup;
            this._b = b;
        }

        @Override
        public AColGroup call() {
            try {
                return this._colGroup.rightMultByMatrix(this._b);
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
    }
}

