/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ColumnEncoderPassThrough
extends ColumnEncoder {
    private static final long serialVersionUID = -8473768154646831882L;

    protected ColumnEncoderPassThrough(int ptCols) {
        super(ptCols);
    }

    public ColumnEncoderPassThrough() {
        this(-1);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public List<Callable<Object>> getPartialBuildTasks(FrameBlock in, int blockSize) {
        return null;
    }

    @Override
    public void mergeBuildPartial(List<Future<Object>> futurePartials, int start, int end) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        int col = this._colID - 1;
        Types.ValueType vt = in.getSchema()[col];
        for (int i = rowStart; i < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++i) {
            Object val = in.get(i, col);
            double v = val == null || vt == Types.ValueType.STRING && val.toString().isEmpty() ? Double.NaN : UtilFunctions.objectToDouble(vt, val);
            out.quickSetValueThreadSafe(i, outputCol, v);
        }
        return out;
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        int end = blk <= 0 ? in.getNumRows() : (in.getNumRows() < rowStart + blk ? in.getNumRows() : rowStart + blk);
        int col = this._colID - 1;
        for (int i = rowStart; i < end; ++i) {
            double val = in.quickGetValueThreadSafe(i, col);
            out.quickSetValueThreadSafe(i, outputCol, val);
        }
        return out;
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderPassThrough) {
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }
}

