/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LineageCacheEntry {
    protected final LineageItem _key;
    protected final Types.DataType _dt;
    protected MatrixBlock _MBval;
    protected ScalarObject _SOval;
    protected long _computeTime;
    protected long _timestamp = 0L;
    protected LineageCacheConfig.LineageCacheStatus _status;
    protected LineageCacheEntry _nextEntry;
    protected LineageItem _origItem;
    private String _outfile = null;
    protected double score;
    protected GPUObject _gpuObject;

    public LineageCacheEntry(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        this._key = key;
        this._dt = dt;
        this._MBval = Mval;
        this._SOval = Sval;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this._nextEntry = null;
        this._origItem = null;
        this._outfile = null;
        this._gpuObject = null;
    }

    protected synchronized void setCacheStatus(LineageCacheConfig.LineageCacheStatus st) {
        this._status = st;
    }

    public synchronized MatrixBlock getMBValue() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._MBval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized ScalarObject getSOValue() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._SOval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized LineageCacheConfig.LineageCacheStatus getCacheStatus() {
        return this._status;
    }

    protected synchronized void removeAndNotify() {
        if (this._status != LineageCacheConfig.LineageCacheStatus.EMPTY) {
            return;
        }
        this._status = LineageCacheConfig.LineageCacheStatus.NOTCACHED;
        this.notifyAll();
    }

    public synchronized long getSize() {
        long size = 0L;
        if (this._MBval != null) {
            size += this._MBval.getInMemorySize();
        }
        if (this._SOval != null) {
            size += (long)this._SOval.getSize();
        }
        if (this._gpuObject != null) {
            size += this._gpuObject.getSizeOnDevice();
        }
        return size;
    }

    public boolean isNullVal() {
        return this._MBval == null && this._SOval == null && this._gpuObject == null;
    }

    public boolean isMatrixValue() {
        return this._dt.isMatrix();
    }

    public boolean isScalarValue() {
        return this._dt.isScalar();
    }

    public synchronized void setValue(MatrixBlock val, long computetime) {
        this._MBval = val;
        this._gpuObject = null;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
    }

    public synchronized void setValue(MatrixBlock val) {
        this.setValue(val, this._computeTime);
    }

    public synchronized void setValue(ScalarObject val, long computetime) {
        this._SOval = val;
        this._gpuObject = null;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
    }

    public synchronized void setGPUValue(GPUObject gpuObj, long computetime) {
        gpuObj.setIsLinCached(true);
        this._gpuObject = gpuObj;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.GPUCACHED;
        this.notifyAll();
    }

    public synchronized GPUObject getGPUObject() {
        return this._gpuObject;
    }

    protected synchronized void setNullValues() {
        this._MBval = null;
        this._SOval = null;
        this._status = LineageCacheConfig.LineageCacheStatus.EMPTY;
    }

    protected synchronized void setOutfile(String outfile) {
        this._outfile = outfile;
    }

    protected synchronized String getOutfile() {
        return this._outfile;
    }

    protected synchronized void setTimestamp() {
        if (this._timestamp != 0L) {
            return;
        }
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        this.recomputeScore();
    }

    protected synchronized void updateTimestamp() {
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        this.recomputeScore();
    }

    protected synchronized void computeScore(Map<LineageItem, Integer> removeList) {
        this.setTimestamp();
        if (removeList.containsKey(this._key) && LineageCacheConfig.isCostNsize()) {
            double w1 = LineageCacheConfig.WEIGHTS[0];
            int missCount = 1 + removeList.get(this._key);
            this.score += w1 * ((double)this._computeTime / (double)this.getSize()) * (double)missCount;
        }
    }

    protected synchronized void updateScore() {
        double w1 = LineageCacheConfig.WEIGHTS[0];
        this.score += w1 * ((double)this._computeTime / (double)this.getSize());
    }

    protected synchronized long getTimestamp() {
        return this._timestamp;
    }

    protected synchronized long getDagHeight() {
        return this._key.getDistLeaf2Node();
    }

    protected synchronized double getCostNsize() {
        return (double)this._computeTime / (double)this.getSize();
    }

    private void recomputeScore() {
        double w1 = LineageCacheConfig.WEIGHTS[0];
        double w2 = LineageCacheConfig.WEIGHTS[1];
        double w3 = LineageCacheConfig.WEIGHTS[2];
        this.score = w1 * ((double)this._computeTime / (double)this.getSize()) + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight());
    }
}

