/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryMatrixMatrixFEDInstruction
extends BinaryFEDInstruction {
    protected BinaryMatrixMatrixFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.Binary, op, in1, in2, out, opcode, istr, fedOut);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        block17: {
            block15: {
                block18: {
                    block16: {
                        mo1 = ec.getMatrixObject(this.input1);
                        mo2 = ec.getMatrixObject(this.input2);
                        if (!mo1.isFederated() && mo2.isFederated() && mo1.getDataCharacteristics().equalDims(mo2.getDataCharacteristics()) && ((BinaryOperator)this._optr).isCommutative()) {
                            mo1 = ec.getMatrixObject(this.input2);
                            mo2 = ec.getMatrixObject(this.input1);
                        }
                        fr2 = null;
                        if (!mo2.isFederatedExcept(FederationMap.FType.BROADCAST)) break block15;
                        if (!mo1.isFederated()) break block16;
                        v0 = new FederationMap.AlignType[1];
                        v1 = v0[0] = mo1.isFederated(FederationMap.FType.ROW) != false ? FederationMap.AlignType.ROW : FederationMap.AlignType.COL;
                        if (!mo1.getFedMapping().isAligned(mo2.getFedMapping(), v0)) break block16;
                        fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()}, true);
                        mo1.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr2});
                        break block17;
                    }
                    if (mo1.isFederated()) break block18;
                    fr1 = mo2.getFedMapping().broadcastSliced(mo1, false);
                    fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{fr1[0].getID(), mo2.getFedMapping().getID()}, true);
                    mo2.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
                    break block17;
                }
                throw new DMLRuntimeException("Matrix-matrix binary operations with a federated right input are only supported for special cases yet.");
            }
            if (!mo1.isFederated(FederationMap.FType.FULL)) ** GOTO lbl34
            if (mo1.getFedMapping().getSize() == 1) {
                fr1 = mo1.getFedMapping().broadcast(mo2);
                fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1.getID()}, true);
                mo1.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2});
            } else {
                throw new DMLRuntimeException("Matrix-matrix binary operations with a full partitioned federated input with multiple partitions are not supported yet.");
lbl34:
                // 1 sources

                if (mo1.isFederated(FederationMap.FType.ROW) && mo2.getNumRows() == 1L || mo1.isFederated(FederationMap.FType.COL) && mo2.getNumColumns() == 1L) {
                    fr1 = mo1.getFedMapping().broadcast(mo2);
                    fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1.getID()}, true);
                    mo1.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2});
                } else if (mo1.isFederated(FederationMap.FType.ROW) ^ mo1.isFederated(FederationMap.FType.COL) || mo1.isFederated(FederationMap.FType.FULL) && mo1.getFedMapping().getSize() == 1) {
                    fr1 = mo1.getFedMapping().broadcastSliced(mo2, false);
                    fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1[0].getID()}, true);
                    mo1.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
                } else if (mo1.isFederated(FederationMap.FType.PART) && !mo2.isFederated()) {
                    fr1 = mo1.getFedMapping().broadcast(mo2);
                    fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1.getID()}, true);
                    mo1.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2});
                } else {
                    throw new DMLRuntimeException("Matrix-matrix binary operations are only supported with a row partitioned or column partitioned federated input yet.");
                }
            }
        }
        if (mo1.isFederated(FederationMap.FType.PART) && !mo2.isFederated()) {
            this.setOutputFedMappingPart(mo1, mo2, fr2.getID(), ec);
        } else if (mo1.isFederated()) {
            this.setOutputFedMapping(mo1, fr2.getID(), ec);
        } else if (mo2.isFederated()) {
            this.setOutputFedMapping(mo2, fr2.getID(), ec);
        } else {
            throw new DMLRuntimeException("Input is not federated, so the output FedMapping cannot be set!");
        }
    }

    private void setOutputFedMappingPart(MatrixObject mo1, MatrixObject mo2, long outputID, ExecutionContext ec) {
        MatrixObject out = ec.getMatrixObject(this.output);
        out.getDataCharacteristics().set(mo1.getNumRows(), mo2.getNumColumns(), (int)mo1.getBlocksize());
        FederationMap outputFedMap = mo1.getFedMapping().copyWithNewIDAndRange(mo1.getNumRows(), mo2.getNumColumns(), outputID);
        out.setFedMapping(outputFedMap);
    }

    private void setOutputFedMapping(MatrixObject moFederated, long outputFedmappingID, ExecutionContext ec) {
        MatrixObject out = ec.getMatrixObject(this.output);
        out.getDataCharacteristics().set(moFederated.getDataCharacteristics());
        out.setFedMapping(moFederated.getFedMapping().copyWithNewID(outputFedmappingID));
    }
}

