/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.TensorReaderTextCell;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.FastStringTokenizer;

public class TensorReaderTextCellParallel
extends TensorReaderTextCell {
    private int _numThreads = OptimizerUtils.getParallelTextReadParallelism();

    @Override
    protected TensorBlock readTextCellTensorFromHDFS(Path path, JobConf job, long[] dims, Types.ValueType[] schema) throws IOException {
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        int[] idims = Arrays.stream(dims).mapToInt(i -> (int)i).toArray();
        TensorBlock ret = schema.length == 1 ? new TensorBlock(schema[0], idims).allocateBlock() : new TensorBlock(schema, idims).allocateBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(this._numThreads);
            InputSplit[] splits = informat.getSplits(job, this._numThreads);
            List tasks = Arrays.stream(splits).map(s -> new ReadTask((InputSplit)s, informat, job, ret)).collect(Collectors.toList());
            List rt = pool.invokeAll(tasks);
            for (Future task : rt) {
                task.get();
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
        return ret;
    }

    private static class ReadTask
    implements Callable<Object> {
        private final InputSplit _split;
        private final TextInputFormat _informat;
        private final JobConf _job;
        private final TensorBlock _dest;

        public ReadTask(InputSplit split, TextInputFormat informat, JobConf job, TensorBlock dest) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            LongWritable key = new LongWritable();
            Text value = new Text();
            try {
                FastStringTokenizer st = new FastStringTokenizer(' ');
                int[] ix = new int[this._dest.getNumDims()];
                RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
                try {
                    while (reader.next((Object)key, (Object)value)) {
                        st.reset(value.toString());
                        for (int i = 0; i < ix.length; ++i) {
                            ix[i] = st.nextInt() - 1;
                        }
                        this._dest.set(ix, st.nextToken());
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            catch (Exception ex) {
                throw new IOException("Unable to read tensor in text cell format.", ex);
            }
            return null;
        }
    }
}

