/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryFrameMatrixSPInstruction
extends BinarySPInstruction {
    protected BinaryFrameMatrixSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        PartitionedBroadcast<MatrixBlock> feaLen = sec.getBroadcastForVariable(this.input2.getName());
        JavaPairRDD out = in1.mapValues((Function)new DropInvalidLengths(feaLen));
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageBroadcast(this.output.getName(), this.input2.getName());
    }

    private static class DropInvalidLengths
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766400L;
        private PartitionedBroadcast<MatrixBlock> featureLength = null;

        public DropInvalidLengths(PartitionedBroadcast<MatrixBlock> fl) {
            this.featureLength = fl;
        }

        public FrameBlock call(FrameBlock frameBlock) throws Exception {
            int idx = (int)this.featureLength.getNumRows();
            FrameBlock fb = frameBlock.invalidByLength(this.featureLength.getBlock(1, idx));
            return fb;
        }
    }
}

