/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class MapMult
extends Lop {
    public static final String OPCODE = "mapmm";
    private CacheType _cacheType = null;
    private boolean _outputEmptyBlocks = true;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public MapMult(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, boolean rightCache, boolean partitioned, boolean emptyBlocks, AggBinaryOp.SparkAggType aggtype) {
        super(Lop.Type.MapMult, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._cacheType = rightCache ? (partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT) : (partitioned ? CacheType.LEFT_PART : CacheType.LEFT);
        this._outputEmptyBlocks = emptyBlocks;
        this._aggtype = aggtype;
        this.lps.setProperties(this.inputs, Types.ExecType.SPARK);
    }

    @Override
    public AggBinaryOp.SparkAggType getAggType() {
        return this._aggtype;
    }

    @Override
    public Lop getBroadcastInput() {
        if (this.getExecType() != Types.ExecType.SPARK) {
            return null;
        }
        return this._cacheType.isRight() ? this.getInputs().get(1) : this.getInputs().get(0);
    }

    @Override
    public String toString() {
        return "Operation = MapMM";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), this._cacheType.name(), String.valueOf(this._outputEmptyBlocks));
        if (this.getExecType() == Types.ExecType.SPARK) {
            ret = InstructionUtils.concatOperands(ret, this._aggtype.name());
        }
        return ret;
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART,
        LEFT,
        LEFT_PART;


        public boolean isRight() {
            return this == RIGHT || this == RIGHT_PART;
        }

        public CacheType getFlipped() {
            switch (this) {
                case RIGHT: {
                    return LEFT;
                }
                case RIGHT_PART: {
                    return LEFT_PART;
                }
                case LEFT: {
                    return RIGHT;
                }
                case LEFT_PART: {
                    return RIGHT_PART;
                }
            }
            return null;
        }
    }
}

