/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public interface IDictionary {
    public static final Log LOG = LogFactory.getLog((String)IDictionary.class.getName());

    public double[] getValues();

    public double getValue(int var1);

    public double getValue(int var1, int var2, int var3);

    public long getInMemorySize();

    public double aggregate(double var1, Builtin var3);

    public double aggregateWithReference(double var1, Builtin var3, double[] var4, boolean var5);

    public double[] aggregateRows(Builtin var1, int var2);

    public double[] aggregateRowsWithDefault(Builtin var1, double[] var2);

    public double[] aggregateRowsWithReference(Builtin var1, double[] var2);

    public void aggregateCols(double[] var1, Builtin var2, IColIndex var3);

    public void aggregateColsWithReference(double[] var1, Builtin var2, IColIndex var3, double[] var4, boolean var5);

    public IDictionary applyScalarOp(ScalarOperator var1);

    public IDictionary applyScalarOpAndAppend(ScalarOperator var1, double var2, int var4);

    public IDictionary applyUnaryOp(UnaryOperator var1);

    public IDictionary applyUnaryOpAndAppend(UnaryOperator var1, double var2, int var4);

    public IDictionary applyScalarOpWithReference(ScalarOperator var1, double[] var2, double[] var3);

    public IDictionary applyUnaryOpWithReference(UnaryOperator var1, double[] var2, double[] var3);

    public IDictionary binOpLeft(BinaryOperator var1, double[] var2, IColIndex var3);

    public IDictionary binOpLeftAndAppend(BinaryOperator var1, double[] var2, IColIndex var3);

    public IDictionary binOpLeftWithReference(BinaryOperator var1, double[] var2, IColIndex var3, double[] var4, double[] var5);

    public IDictionary binOpRight(BinaryOperator var1, double[] var2, IColIndex var3);

    public IDictionary binOpRightAndAppend(BinaryOperator var1, double[] var2, IColIndex var3);

    public IDictionary binOpRight(BinaryOperator var1, double[] var2);

    public IDictionary binOpRightWithReference(BinaryOperator var1, double[] var2, IColIndex var3, double[] var4, double[] var5);

    public IDictionary clone();

    public void write(DataOutput var1) throws IOException;

    public long getExactSizeOnDisk();

    public DictType getDictType();

    public int getNumberOfValues(int var1);

    public double[] sumAllRowsToDouble(int var1);

    public double[] sumAllRowsToDoubleWithDefault(double[] var1);

    public double[] sumAllRowsToDoubleWithReference(double[] var1);

    public double[] sumAllRowsToDoubleSq(int var1);

    public double[] sumAllRowsToDoubleSqWithDefault(double[] var1);

    public double[] sumAllRowsToDoubleSqWithReference(double[] var1);

    public double[] productAllRowsToDouble(int var1);

    public double[] productAllRowsToDoubleWithDefault(double[] var1);

    public double[] productAllRowsToDoubleWithReference(double[] var1);

    public void colSum(double[] var1, int[] var2, IColIndex var3);

    public void colSumSq(double[] var1, int[] var2, IColIndex var3);

    public void colSumSqWithReference(double[] var1, int[] var2, IColIndex var3, double[] var4);

    public double sum(int[] var1, int var2);

    public double sumSq(int[] var1, int var2);

    public double sumSqWithReference(int[] var1, double[] var2);

    public String getString(int var1);

    public IDictionary sliceOutColumnRange(int var1, int var2, int var3);

    public boolean containsValue(double var1);

    public boolean containsValueWithReference(double var1, double[] var3);

    public long getNumberNonZeros(int[] var1, int var2);

    public long getNumberNonZerosWithReference(int[] var1, double[] var2, int var3);

    public void addToEntry(double[] var1, int var2, int var3, int var4);

    public void addToEntry(double[] var1, int var2, int var3, int var4, int var5);

    public void addToEntryVectorized(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18);

    public IDictionary subtractTuple(double[] var1);

    public MatrixBlockDictionary getMBDict(int var1);

    public IDictionary scaleTuples(int[] var1, int var2);

    public IDictionary preaggValuesFromDense(int var1, IColIndex var2, IColIndex var3, double[] var4, int var5);

    public IDictionary replace(double var1, double var3, int var5);

    public IDictionary replaceWithReference(double var1, double var3, double[] var5);

    public void product(double[] var1, int[] var2, int var3);

    public void productWithDefault(double[] var1, int[] var2, double[] var3, int var4);

    public void productWithReference(double[] var1, int[] var2, double[] var3, int var4);

    public void colProduct(double[] var1, int[] var2, IColIndex var3);

    public void colProductWithReference(double[] var1, int[] var2, IColIndex var3, double[] var4);

    public CM_COV_Object centralMoment(ValueFunction var1, int[] var2, int var3);

    public CM_COV_Object centralMoment(CM_COV_Object var1, ValueFunction var2, int[] var3, int var4);

    public CM_COV_Object centralMomentWithDefault(ValueFunction var1, int[] var2, double var3, int var5);

    public CM_COV_Object centralMomentWithDefault(CM_COV_Object var1, ValueFunction var2, int[] var3, double var4, int var6);

    public CM_COV_Object centralMomentWithReference(ValueFunction var1, int[] var2, double var3, int var5);

    public CM_COV_Object centralMomentWithReference(CM_COV_Object var1, ValueFunction var2, int[] var3, double var4, int var6);

    public IDictionary rexpandCols(int var1, boolean var2, boolean var3, int var4);

    public IDictionary rexpandColsWithReference(int var1, boolean var2, boolean var3, int var4);

    public double getSparsity();

    public void multiplyScalar(double var1, double[] var3, int var4, int var5, IColIndex var6);

    public void TSMMWithScaling(int[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void MMDict(IDictionary var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void MMDictScaling(IDictionary var1, IColIndex var2, IColIndex var3, MatrixBlock var4, int[] var5);

    public void MMDictDense(double[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void MMDictScalingDense(double[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4, int[] var5);

    public void MMDictSparse(SparseBlock var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void MMDictScalingSparse(SparseBlock var1, IColIndex var2, IColIndex var3, MatrixBlock var4, int[] var5);

    public void TSMMToUpperTriangle(IDictionary var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void TSMMToUpperTriangleDense(double[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void TSMMToUpperTriangleSparse(SparseBlock var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    public void TSMMToUpperTriangleScaling(IDictionary var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    public void TSMMToUpperTriangleDenseScaling(double[] var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    public void TSMMToUpperTriangleSparseScaling(SparseBlock var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    public IDictionary cbind(IDictionary var1, int var2);

    public boolean equals(Object var1);

    public boolean equals(double[] var1);

    public boolean equals(IDictionary var1);

    public IDictionary reorder(int[] var1);

    public static enum DictType {
        Delta,
        Dict,
        MatrixBlock,
        UInt8,
        Identity,
        IdentitySlice;

    }
}

