/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.spark.RandSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageParser;
import org.apache.sysds.runtime.util.ProgramConverter;

public class LineageRecomputeUtils {
    private static final String LVARPREFIX = "lvar";
    public static final String LPLACEHOLDER = "IN#";
    private static final boolean DEBUG = false;
    public static Map<String, DedupLoopItem> loopPatchMap = new HashMap<String, DedupLoopItem>();

    public static Data parseNComputeLineageTrace(String mainTrace, String dedupPatches) {
        LineageItem root = LineageParser.parseLineageTrace(mainTrace);
        if (dedupPatches != null) {
            LineageParser.parseLineageTraceDedup(dedupPatches);
        }
        boolean GPUenabled = false;
        if (DMLScript.USE_ACCELERATOR) {
            GPUenabled = true;
            DMLScript.USE_ACCELERATOR = false;
        }
        Data ret = LineageRecomputeUtils.computeByLineage(root);
        if (GPUenabled) {
            DMLScript.USE_ACCELERATOR = true;
        }
        loopPatchMap.clear();
        return ret;
    }

    private static Data computeByLineage(LineageItem root) {
        long rootId = root.getOpcode().equals("write") ? root.getInputs()[0].getId() : root.getId();
        String varname = LVARPREFIX + rootId;
        Program prog = new Program(null);
        root.resetVisitStatusNR();
        HashMap<Long, Hop> operands = new HashMap<Long, Hop>();
        HashMap<String, Hop> partDagRoots = new HashMap<String, Hop>();
        LineageRecomputeUtils.constructHopsNR(root, operands, partDagRoots, prog);
        DataOp out = HopRewriteUtils.createTransientWrite(varname, (Hop)operands.get(rootId));
        ExecutionContext ec = ExecutionContextFactory.createContext();
        partDagRoots.put(varname, out);
        LineageRecomputeUtils.constructBasicBlock(partDagRoots, varname, prog);
        LineageCache.resetCache();
        ec.setProgram(prog);
        prog.execute(ec);
        return ec.getVariable(varname);
    }

    private static void constructBasicBlock(Map<String, Hop> partDagRoots, String dedupOut, Program prog) {
        Hop out = partDagRoots.get(dedupOut);
        BasicProgramBlock pb = new BasicProgramBlock(prog);
        pb.setInstructions(LineageRecomputeUtils.genInst(out));
        prog.addProgramBlock(pb);
    }

    private static void constructHopsNR(LineageItem item, Map<Long, Hop> operands, Map<String, Hop> partDagRoots, Program prog) {
        Stack<LineageItem> stackItem = new Stack<LineageItem>();
        Stack<MutableInt> stackPos = new Stack<MutableInt>();
        stackItem.push(item);
        stackPos.push(new MutableInt(0));
        while (!stackItem.empty()) {
            LineageItem tmpItem = (LineageItem)stackItem.peek();
            MutableInt tmpPos = (MutableInt)stackPos.peek();
            if (tmpItem.isVisited()) {
                stackItem.pop();
                stackPos.pop();
                continue;
            }
            if (tmpItem.getInputs() == null || tmpItem.getInputs().length <= tmpPos.intValue()) {
                LineageRecomputeUtils.constructSingleHop(tmpItem, operands, partDagRoots, prog);
                stackItem.pop();
                stackPos.pop();
                tmpItem.setVisited();
                continue;
            }
            if (tmpItem.getInputs() == null) continue;
            stackItem.push(tmpItem.getInputs()[tmpPos.intValue()]);
            tmpPos.increment();
            stackPos.push(new MutableInt(0));
        }
    }

    private static void constructSingleHop(LineageItem item, Map<Long, Hop> operands, Map<String, Hop> partDagRoots, Program prog) {
        block0 : switch (item.getType()) {
            case Creation: {
                if (item.getData().startsWith(LPLACEHOLDER)) {
                    long phId = Long.parseLong(item.getData().substring(3));
                    Hop input = operands.get(phId);
                    operands.remove(phId);
                    operands.put(item.getId(), input);
                    break;
                }
                if (item.getOpcode().equals("cache_rblk")) {
                    CacheableData dat = (CacheableData)ProgramConverter.parseDataObject(item.getData())[1];
                    DataOp hop = new DataOp("tmp", dat.getDataType(), dat.getValueType(), Types.OpOpData.PERSISTENTREAD, dat.getFileName(), dat.getNumRows(), dat.getNumColumns(), dat.getDataCharacteristics().getNonZeros(), -1);
                    hop.setFileFormat(Types.FileFormat.BINARY);
                    hop.setInputBlocksize(dat.getBlocksize());
                    hop.setBlocksize(ConfigurationManager.getBlocksize());
                    hop.setRequiresReblock(true);
                    operands.put(item.getId(), hop);
                    break;
                }
                Instruction inst = InstructionParser.parseSingleInstruction(item.getData());
                if (inst instanceof DataGenCPInstruction) {
                    DataGenCPInstruction rand = (DataGenCPInstruction)inst;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    if (rand.getOpcode().equals("rand")) {
                        if (rand.output.getDataType() == Types.DataType.TENSOR) {
                            params.put("dims", new LiteralOp(rand.getDims()));
                        } else {
                            params.put("rows", new LiteralOp(rand.getRows()));
                            params.put("cols", new LiteralOp(rand.getCols()));
                        }
                        params.put("min", new LiteralOp(rand.getMinValue()));
                        params.put("max", new LiteralOp(rand.getMaxValue()));
                        params.put("pdf", new LiteralOp(rand.getPdf()));
                        params.put("lambda", new LiteralOp(rand.getPdfParams()));
                        params.put("sparsity", new LiteralOp(rand.getSparsity()));
                        params.put("seed", new LiteralOp(rand.getSeed()));
                    } else if (rand.getOpcode().equals("seq")) {
                        params.put("from", new LiteralOp(rand.getFrom()));
                        params.put("to", new LiteralOp(rand.getTo()));
                        params.put("incr", new LiteralOp(rand.getIncr()));
                    }
                    DataGenOp datagen = new DataGenOp(Types.OpOpDG.valueOf(rand.getOpcode().toUpperCase()), new DataIdentifier("tmp"), params);
                    datagen.setBlocksize(rand.getBlocksize());
                    operands.put(item.getId(), datagen);
                    break;
                }
                if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isCreateVariable()) {
                    String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst.toString());
                    Types.DataType dt = Types.DataType.valueOf(parts[4]);
                    Types.ValueType vt = dt == Types.DataType.MATRIX ? Types.ValueType.FP64 : Types.ValueType.STRING;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    params.put("iofilename", new LiteralOp(parts[2]));
                    params.put("rows", new LiteralOp(Long.parseLong(parts[6])));
                    params.put("cols", new LiteralOp(Long.parseLong(parts[7])));
                    params.put("nnz", new LiteralOp(Long.parseLong(parts[8])));
                    params.put("format", new LiteralOp(parts[5]));
                    DataOp pread = new DataOp(parts[1].substring(5), dt, vt, Types.OpOpData.PERSISTENTREAD, params);
                    pread.setFileName(parts[2]);
                    operands.put(item.getId(), pread);
                    break;
                }
                if (!(inst instanceof RandSPInstruction)) break;
                RandSPInstruction rand = (RandSPInstruction)inst;
                HashMap<String, Hop> params = new HashMap<String, Hop>();
                if (rand.output.getDataType() == Types.DataType.TENSOR) {
                    params.put("dims", new LiteralOp(rand.getDims()));
                } else {
                    params.put("rows", new LiteralOp(rand.getRows()));
                    params.put("cols", new LiteralOp(rand.getCols()));
                }
                params.put("min", new LiteralOp(rand.getMinValue()));
                params.put("max", new LiteralOp(rand.getMaxValue()));
                params.put("pdf", new LiteralOp(rand.getPdf()));
                params.put("lambda", new LiteralOp(rand.getPdfParams()));
                params.put("sparsity", new LiteralOp(rand.getSparsity()));
                params.put("seed", new LiteralOp(rand.getSeed()));
                DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
                datagen.setBlocksize(rand.getBlocksize());
                operands.put(item.getId(), datagen);
                break;
            }
            case Dedup: {
                String[] parts = item.getOpcode().split("_");
                String name = parts[2] + parts[1] + parts[3];
                List<Hop> finputs = Arrays.stream(item.getInputs()).map(inp -> (Hop)operands.get(inp.getId())).collect(Collectors.toList());
                String[] inputNames = new String[item.getInputs().length];
                for (int i = 0; i < item.getInputs().length; ++i) {
                    inputNames[i] = LPLACEHOLDER + i;
                }
                FunctionOp funcOp = new FunctionOp(FunctionOp.FunctionType.DML, ".defaultNS", name, inputNames, finputs, new String[]{parts[1]}, false);
                partDagRoots.put(parts[1], funcOp);
                LineageRecomputeUtils.constructBasicBlock(partDagRoots, parts[1], prog);
                Hop output = LineageRecomputeUtils.constructHopsDedupPatch(parts, inputNames, finputs, prog);
                operands.put(item.getId(), HopRewriteUtils.createTransientRead(parts[1], output));
                break;
            }
            case Instruction: {
                CPInstruction.CPType ctype = InstructionUtils.getCPTypeByOpcode(item.getOpcode());
                SPInstruction.SPType stype = InstructionUtils.getSPTypeByOpcode(item.getOpcode());
                if (ctype != null) {
                    switch (ctype) {
                        case AggregateUnary: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            MultiThreadedHop aggunary = InstructionUtils.isUnaryMetadata(item.getOpcode()) ? HopRewriteUtils.createUnary(input, Types.OpOp1.valueOfByOpcode(item.getOpcode())) : HopRewriteUtils.createAggUnaryOp(input, item.getOpcode());
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case AggregateBinary: {
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            AggBinaryOp aggbinary = HopRewriteUtils.createMatrixMultiply(input1, input2);
                            operands.put(item.getId(), aggbinary);
                            break block0;
                        }
                        case AggregateTernary: {
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            Hop input3 = operands.get(item.getInputs()[2].getId());
                            AggUnaryOp aggternary = HopRewriteUtils.createSum(HopRewriteUtils.createBinary((Hop)HopRewriteUtils.createBinary(input1, input2, Types.OpOp2.MULT), input3, Types.OpOp2.MULT));
                            operands.put(item.getId(), aggternary);
                            break block0;
                        }
                        case Unary: 
                        case Builtin: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            UnaryOp unary = HopRewriteUtils.createUnary(input, item.getOpcode());
                            operands.put(item.getId(), unary);
                            break block0;
                        }
                        case Reorg: {
                            operands.put(item.getId(), HopRewriteUtils.createReorg(operands.get(item.getInputs()[0].getId()), item.getOpcode()));
                            break block0;
                        }
                        case Reshape: {
                            ArrayList<Hop> inputs = new ArrayList<Hop>();
                            for (int i = 0; i < 5; ++i) {
                                inputs.add(operands.get(item.getInputs()[i].getId()));
                            }
                            operands.put(item.getId(), HopRewriteUtils.createReorg(inputs, Types.ReOrgOp.RESHAPE));
                            break block0;
                        }
                        case Binary: {
                            String opcode = "^2".equals(item.getOpcode()) || "*2".equals(item.getOpcode()) ? item.getOpcode().substring(0, 1) : item.getOpcode();
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            BinaryOp binary = HopRewriteUtils.createBinary(input1, input2, opcode);
                            operands.put(item.getId(), binary);
                            break block0;
                        }
                        case Ternary: {
                            operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), item.getOpcode()));
                            break block0;
                        }
                        case Ctable: {
                            if (item.getInputs().length == 3) {
                                operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), Types.OpOp3.CTABLE));
                                break block0;
                            }
                            if (item.getInputs().length != 5) break block0;
                            operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()), Types.OpOp3.CTABLE));
                            break block0;
                        }
                        case BuiltinNary: {
                            String opcode = item.getOpcode().equals("n+") ? "plus" : item.getOpcode();
                            operands.put(item.getId(), HopRewriteUtils.createNary(Types.OpOpN.valueOf(opcode.toUpperCase()), LineageRecomputeUtils.createNaryInputs(item, operands)));
                            break block0;
                        }
                        case ParameterizedBuiltin: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructParameterizedBuiltinOp(item, operands));
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                        case MMTSJ: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            AggBinaryOp aggunary = HopRewriteUtils.createMatrixMultiply(HopRewriteUtils.createTranspose(input), input);
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case Variable: {
                            if (item.getOpcode().startsWith("cast")) {
                                operands.put(item.getId(), HopRewriteUtils.createUnary(operands.get(item.getInputs()[0].getId()), Types.OpOp1.valueOfByOpcode(item.getOpcode())));
                                break block0;
                            }
                            operands.put(item.getId(), operands.get(item.getInputs()[0].getId()));
                            break block0;
                        }
                        case StringInit: {
                            HashMap<String, Hop> params = new HashMap<String, Hop>();
                            params.put("rows", operands.get(item.getInputs()[0].getId()));
                            params.put("cols", operands.get(item.getInputs()[1].getId()));
                            params.put("min", operands.get(item.getInputs()[2].getId()));
                            params.put("max", operands.get(item.getInputs()[2].getId()));
                            DataGenOp datagen = new DataGenOp(Types.OpOpDG.SINIT, new DataIdentifier("tmp"), params);
                            operands.put(item.getId(), datagen);
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + ctype.name() + " (" + item.getOpcode() + ").");
                }
                if (stype != null) {
                    switch (stype) {
                        case Reblock: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            input.setBlocksize(ConfigurationManager.getBlocksize());
                            input.setRequiresReblock(true);
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case Checkpoint: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                        case GAppend: {
                            operands.put(item.getId(), HopRewriteUtils.createBinary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), Types.OpOp2.CBIND));
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + stype.name() + " (" + item.getOpcode() + ").");
                }
                throw new DMLRuntimeException("Unsupported instruction: " + item.getOpcode());
            }
            case Literal: {
                CPOperand op = new CPOperand(item.getData());
                operands.put(item.getId(), ScalarObjectFactory.createLiteralOp(op.getValueType(), op.getName()));
                break;
            }
        }
    }

    private static Hop constructHopsDedupPatch(String[] parts, String[] inputs, List<Hop> inpHops, Program prog) {
        String outname = parts[1];
        Long pathId = Long.parseLong(parts[3]);
        DedupLoopItem loop = loopPatchMap.get(parts[2]);
        if (loop.patchHopMap.containsKey(pathId) && loop.patchHopMap.get(pathId).containsKey(outname)) {
            return loop.patchHopMap.get(pathId).get(outname);
        }
        LineageItem patchRoot = loop.patchLiMap.get(pathId).get(outname);
        patchRoot.resetVisitStatusNR();
        HashMap<Long, Hop> operands = new HashMap<Long, Hop>();
        for (int i = 0; i < inputs.length; ++i) {
            operands.put(Long.valueOf(i), HopRewriteUtils.createTransientRead(inputs[i], inpHops.get(i)));
        }
        LineageRecomputeUtils.constructHopsNR(patchRoot, operands, null, null);
        DataOp out = HopRewriteUtils.createTransientWrite(outname, (Hop)operands.get(patchRoot.getId()));
        if (!loop.patchHopMap.containsKey(pathId)) {
            loop.patchHopMap.put(pathId, new HashMap());
        }
        loop.patchHopMap.get(pathId).put(outname, out);
        ArrayList<DataIdentifier> funcInputs = new ArrayList<DataIdentifier>();
        for (int i = 0; i < inpHops.size(); ++i) {
            funcInputs.add(new DataIdentifier(inputs[i], inpHops.get(i).getDataType(), inpHops.get(i).getValueType()));
        }
        ArrayList<DataIdentifier> funcOutput = new ArrayList<DataIdentifier>(Arrays.asList(new DataIdentifier(outname)));
        FunctionProgramBlock fpb = new FunctionProgramBlock(prog, funcInputs, funcOutput);
        BasicProgramBlock pb = new BasicProgramBlock(prog);
        pb.setInstructions(LineageRecomputeUtils.genInst(out));
        fpb.addProgramBlock(pb);
        prog.addFunctionProgramBlock(".defaultNS", parts[2] + parts[1] + parts[3], fpb);
        return out;
    }

    private static ArrayList<Instruction> genInst(Hop root) {
        Dag<Lop> dag = new Dag<Lop>();
        Lop lops = root.constructLops();
        lops.addToDag(dag);
        return dag.getJobs(null, ConfigurationManager.getDMLConfig());
    }

    private static Hop[] createNaryInputs(LineageItem item, Map<Long, Hop> operands) {
        int len = item.getInputs().length;
        Hop[] ret = new Hop[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = operands.get(item.getInputs()[i].getId());
        }
        return ret;
    }

    private static Hop constructParameterizedBuiltinOp(LineageItem item, Map<Long, Hop> operands) {
        String opcode = item.getOpcode();
        Hop target = operands.get(item.getInputs()[0].getId());
        LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
        if (opcode.equals("groupedagg")) {
            args.put("target", target);
            args.put("groups", operands.get(item.getInputs()[1].getId()));
            args.put("weights", operands.get(item.getInputs()[2].getId()));
            args.put("fn", operands.get(item.getInputs()[3].getId()));
            args.put("ngroups", operands.get(item.getInputs()[4].getId()));
        } else if (opcode.equalsIgnoreCase("rmempty")) {
            args.put("target", target);
            args.put("margin", operands.get(item.getInputs()[1].getId()));
            args.put("select", operands.get(item.getInputs()[2].getId()));
        } else if (opcode.equalsIgnoreCase("replace")) {
            args.put("target", target);
            args.put("pattern", operands.get(item.getInputs()[1].getId()));
            args.put("replacement", operands.get(item.getInputs()[2].getId()));
        } else if (opcode.equalsIgnoreCase("rexpand")) {
            args.put("target", target);
            args.put("max", operands.get(item.getInputs()[1].getId()));
            args.put("dir", operands.get(item.getInputs()[2].getId()));
            args.put("cast", operands.get(item.getInputs()[3].getId()));
            args.put("ignore", operands.get(item.getInputs()[4].getId()));
        }
        return HopRewriteUtils.createParameterizedBuiltinOp(target, args, Types.ParamBuiltinOp.valueOf(opcode.toUpperCase()));
    }

    private static Hop constructIndexingOp(LineageItem item, Map<Long, Hop> operands) {
        Hop input = operands.get(item.getInputs()[0].getId());
        if ("rightIndex".equals(item.getOpcode())) {
            return HopRewriteUtils.createIndexingOp(input, operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()));
        }
        if ("leftIndex".equals(item.getOpcode()) || "mapLeftIndex".equals(item.getOpcode())) {
            return HopRewriteUtils.createLeftIndexingOp(input, operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()), operands.get(item.getInputs()[5].getId()));
        }
        throw new DMLRuntimeException("Unsupported opcode: " + item.getOpcode());
    }

    @Deprecated
    private static void rConstructHops(LineageItem item, Map<Long, Hop> operands, Map<String, Hop> partDagRoots, Program prog) {
        if (item.isVisited()) {
            return;
        }
        if (!item.isLeaf()) {
            for (LineageItem c : item.getInputs()) {
                LineageRecomputeUtils.rConstructHops(c, operands, partDagRoots, prog);
            }
        }
        block0 : switch (item.getType()) {
            case Creation: {
                DataGenOp datagen;
                if (item.getData().startsWith(LPLACEHOLDER)) {
                    long phId = Long.parseLong(item.getData().substring(3));
                    Hop input = operands.get(phId);
                    operands.remove(phId);
                    operands.put(item.getId(), input);
                    break;
                }
                Instruction inst = InstructionParser.parseSingleInstruction(item.getData());
                if (inst instanceof DataGenCPInstruction) {
                    DataGenCPInstruction rand = (DataGenCPInstruction)inst;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    if (rand.getOpcode().equals("rand")) {
                        if (rand.output.getDataType() == Types.DataType.TENSOR) {
                            params.put("dims", new LiteralOp(rand.getDims()));
                        } else {
                            params.put("rows", new LiteralOp(rand.getRows()));
                            params.put("cols", new LiteralOp(rand.getCols()));
                        }
                        params.put("min", new LiteralOp(rand.getMinValue()));
                        params.put("max", new LiteralOp(rand.getMaxValue()));
                        params.put("pdf", new LiteralOp(rand.getPdf()));
                        params.put("lambda", new LiteralOp(rand.getPdfParams()));
                        params.put("sparsity", new LiteralOp(rand.getSparsity()));
                        params.put("seed", new LiteralOp(rand.getSeed()));
                    } else if (rand.getOpcode().equals("seq")) {
                        params.put("from", new LiteralOp(rand.getFrom()));
                        params.put("to", new LiteralOp(rand.getTo()));
                        params.put("incr", new LiteralOp(rand.getIncr()));
                    }
                    datagen = new DataGenOp(Types.OpOpDG.valueOf(rand.getOpcode().toUpperCase()), new DataIdentifier("tmp"), params);
                    datagen.setBlocksize(rand.getBlocksize());
                    operands.put(item.getId(), datagen);
                    break;
                }
                if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isCreateVariable()) {
                    String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst.toString());
                    Types.DataType dt = Types.DataType.valueOf(parts[4]);
                    Types.ValueType vt = dt == Types.DataType.MATRIX ? Types.ValueType.FP64 : Types.ValueType.STRING;
                    HashMap<String, Hop> params = new HashMap<String, Hop>();
                    params.put("iofilename", new LiteralOp(parts[2]));
                    params.put("rows", new LiteralOp(Long.parseLong(parts[6])));
                    params.put("cols", new LiteralOp(Long.parseLong(parts[7])));
                    params.put("nnz", new LiteralOp(Long.parseLong(parts[8])));
                    params.put("format", new LiteralOp(parts[5]));
                    DataOp pread = new DataOp(parts[1].substring(5), dt, vt, Types.OpOpData.PERSISTENTREAD, params);
                    pread.setFileName(parts[2]);
                    operands.put(item.getId(), pread);
                    break;
                }
                if (!(inst instanceof RandSPInstruction)) break;
                RandSPInstruction rand = (RandSPInstruction)inst;
                HashMap<String, Hop> params = new HashMap<String, Hop>();
                if (rand.output.getDataType() == Types.DataType.TENSOR) {
                    params.put("dims", new LiteralOp(rand.getDims()));
                } else {
                    params.put("rows", new LiteralOp(rand.getRows()));
                    params.put("cols", new LiteralOp(rand.getCols()));
                }
                params.put("min", new LiteralOp(rand.getMinValue()));
                params.put("max", new LiteralOp(rand.getMaxValue()));
                params.put("pdf", new LiteralOp(rand.getPdf()));
                params.put("lambda", new LiteralOp(rand.getPdfParams()));
                params.put("sparsity", new LiteralOp(rand.getSparsity()));
                params.put("seed", new LiteralOp(rand.getSeed()));
                datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
                datagen.setBlocksize(rand.getBlocksize());
                operands.put(item.getId(), datagen);
                break;
            }
            case Dedup: {
                String[] parts = item.getOpcode().split("_");
                String name = parts[2] + parts[1] + parts[3];
                List<Hop> finputs = Arrays.stream(item.getInputs()).map(inp -> (Hop)operands.get(inp.getId())).collect(Collectors.toList());
                String[] inputNames = new String[item.getInputs().length];
                for (int i = 0; i < item.getInputs().length; ++i) {
                    inputNames[i] = LPLACEHOLDER + i;
                }
                FunctionOp funcOp = new FunctionOp(FunctionOp.FunctionType.DML, ".defaultNS", name, inputNames, finputs, new String[]{parts[1]}, false);
                partDagRoots.put(parts[1], funcOp);
                LineageRecomputeUtils.constructBasicBlock(partDagRoots, parts[1], prog);
                Hop output = LineageRecomputeUtils.constructHopsDedupPatch(parts, inputNames, finputs, prog);
                operands.put(item.getId(), HopRewriteUtils.createTransientRead(parts[1], output));
                break;
            }
            case Instruction: {
                CPInstruction.CPType ctype = InstructionUtils.getCPTypeByOpcode(item.getOpcode());
                SPInstruction.SPType stype = InstructionUtils.getSPTypeByOpcode(item.getOpcode());
                if (ctype != null) {
                    switch (ctype) {
                        case AggregateUnary: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            MultiThreadedHop aggunary = InstructionUtils.isUnaryMetadata(item.getOpcode()) ? HopRewriteUtils.createUnary(input, Types.OpOp1.valueOfByOpcode(item.getOpcode())) : HopRewriteUtils.createAggUnaryOp(input, item.getOpcode());
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case AggregateBinary: {
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            AggBinaryOp aggbinary = HopRewriteUtils.createMatrixMultiply(input1, input2);
                            operands.put(item.getId(), aggbinary);
                            break block0;
                        }
                        case AggregateTernary: {
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            Hop input3 = operands.get(item.getInputs()[2].getId());
                            AggUnaryOp aggternary = HopRewriteUtils.createSum(HopRewriteUtils.createBinary((Hop)HopRewriteUtils.createBinary(input1, input2, Types.OpOp2.MULT), input3, Types.OpOp2.MULT));
                            operands.put(item.getId(), aggternary);
                            break block0;
                        }
                        case Unary: 
                        case Builtin: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            UnaryOp unary = HopRewriteUtils.createUnary(input, item.getOpcode());
                            operands.put(item.getId(), unary);
                            break block0;
                        }
                        case Reorg: {
                            operands.put(item.getId(), HopRewriteUtils.createReorg(operands.get(item.getInputs()[0].getId()), item.getOpcode()));
                            break block0;
                        }
                        case Reshape: {
                            ArrayList<Hop> inputs = new ArrayList<Hop>();
                            for (int i = 0; i < 5; ++i) {
                                inputs.add(operands.get(item.getInputs()[i].getId()));
                            }
                            operands.put(item.getId(), HopRewriteUtils.createReorg(inputs, Types.ReOrgOp.RESHAPE));
                            break block0;
                        }
                        case Binary: {
                            String opcode = "^2".equals(item.getOpcode()) || "*2".equals(item.getOpcode()) ? item.getOpcode().substring(0, 1) : item.getOpcode();
                            Hop input1 = operands.get(item.getInputs()[0].getId());
                            Hop input2 = operands.get(item.getInputs()[1].getId());
                            BinaryOp binary = HopRewriteUtils.createBinary(input1, input2, opcode);
                            operands.put(item.getId(), binary);
                            break block0;
                        }
                        case Ternary: {
                            operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), item.getOpcode()));
                            break block0;
                        }
                        case Ctable: {
                            if (item.getInputs().length == 3) {
                                operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), Types.OpOp3.CTABLE));
                                break block0;
                            }
                            if (item.getInputs().length != 5) break block0;
                            operands.put(item.getId(), HopRewriteUtils.createTernary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), operands.get(item.getInputs()[2].getId()), operands.get(item.getInputs()[3].getId()), operands.get(item.getInputs()[4].getId()), Types.OpOp3.CTABLE));
                            break block0;
                        }
                        case BuiltinNary: {
                            String opcode = item.getOpcode().equals("n+") ? "plus" : item.getOpcode();
                            operands.put(item.getId(), HopRewriteUtils.createNary(Types.OpOpN.valueOf(opcode.toUpperCase()), LineageRecomputeUtils.createNaryInputs(item, operands)));
                            break block0;
                        }
                        case ParameterizedBuiltin: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructParameterizedBuiltinOp(item, operands));
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                        case MMTSJ: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            MultiThreadedHop aggunary = HopRewriteUtils.createMatrixMultiply(HopRewriteUtils.createTranspose(input), input);
                            operands.put(item.getId(), aggunary);
                            break block0;
                        }
                        case Variable: {
                            if (item.getOpcode().startsWith("cast")) {
                                operands.put(item.getId(), HopRewriteUtils.createUnary(operands.get(item.getInputs()[0].getId()), Types.OpOp1.valueOfByOpcode(item.getOpcode())));
                                break block0;
                            }
                            operands.put(item.getId(), operands.get(item.getInputs()[0].getId()));
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + ctype.name() + " (" + item.getOpcode() + ").");
                }
                if (stype != null) {
                    switch (stype) {
                        case Reblock: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            input.setBlocksize(ConfigurationManager.getBlocksize());
                            input.setRequiresReblock(true);
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case Checkpoint: {
                            Hop input = operands.get(item.getInputs()[0].getId());
                            operands.put(item.getId(), input);
                            break block0;
                        }
                        case MatrixIndexing: {
                            operands.put(item.getId(), LineageRecomputeUtils.constructIndexingOp(item, operands));
                            break block0;
                        }
                        case GAppend: {
                            operands.put(item.getId(), HopRewriteUtils.createBinary(operands.get(item.getInputs()[0].getId()), operands.get(item.getInputs()[1].getId()), Types.OpOp2.CBIND));
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Unsupported instruction type: " + stype.name() + " (" + item.getOpcode() + ").");
                }
                throw new DMLRuntimeException("Unsupported instruction: " + item.getOpcode());
            }
            case Literal: {
                CPOperand op = new CPOperand(item.getData());
                operands.put(item.getId(), ScalarObjectFactory.createLiteralOp(op.getValueType(), op.getName()));
                break;
            }
        }
        item.setVisited();
    }

    protected static class DedupLoopItem {
        public String functionName;
        public final Map<Long, Map<String, LineageItem>> patchLiMap = new HashMap<Long, Map<String, LineageItem>>();
        private final Map<Long, Map<String, Hop>> patchHopMap = new HashMap<Long, Map<String, Hop>>();

        public DedupLoopItem(String name) {
            this.functionName = name;
        }
    }
}

