/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.utils.stats.Timing;

public abstract class Array<T>
implements Writable {
    protected static final Log LOG = LogFactory.getLog((String)Array.class.getName());
    public static int ROW_PARALLELIZATION_THRESHOLD = 10000;
    protected SoftReference<Map<T, Integer>> _rcdMapCache = null;
    protected int _size;

    protected Array(int size) {
        this._size = size;
        if (size <= 0) {
            throw new DMLRuntimeException("Invalid zero/negative size of Array");
        }
    }

    protected int newSize() {
        return Math.max(this._size * 2, 4);
    }

    public final SoftReference<Map<T, Integer>> getCache() {
        return this._rcdMapCache;
    }

    public final void setCache(SoftReference<Map<T, Integer>> m) {
        this._rcdMapCache = m;
    }

    public final synchronized Map<T, Integer> getRecodeMap() {
        return this.getRecodeMap(4);
    }

    public final synchronized Map<T, Integer> getRecodeMap(int estimate) {
        try {
            return this.getRecodeMap(estimate, null, -1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final synchronized Map<T, Integer> getRecodeMap(int estimate, ExecutorService pool, int k) throws InterruptedException, ExecutionException {
        Map<T, Integer> map;
        SoftReference<Map<T, Integer>> tmp = this.getCache();
        Map<T, Integer> map2 = map = tmp != null ? tmp.get() : null;
        if (map != null) {
            return map;
        }
        map = this.createRecodeMap(estimate, pool, k);
        this.setCache(new SoftReference<Map<T, Integer>>(map));
        return map;
    }

    protected HashMapToInt<T> createRecodeMap(int estimate, ExecutorService pool, int k) throws InterruptedException, ExecutionException {
        boolean debug = LOG.isDebugEnabled();
        Timing t = debug ? new Timing() : null;
        int s = this.size();
        HashMapToInt<T> ret = k <= 1 || pool == null || s < ROW_PARALLELIZATION_THRESHOLD ? this.createRecodeMap(estimate, 0, s) : this.parallelCreateRecodeMap(estimate, pool, s, k);
        if (debug) {
            String base = "CreateRecodeMap estimate: %10d actual %10d time: %10.5f";
            LOG.debug((Object)String.format(base, estimate, ret.size(), t.stop()));
        }
        return ret;
    }

    private HashMapToInt<T> parallelCreateRecodeMap(int estimate, ExecutorService pool, int s, int k) throws InterruptedException, ExecutionException {
        int blk = Math.max(ROW_PARALLELIZATION_THRESHOLD / 2, (s + k) / k);
        ArrayList<Future<HashMapToInt>> tasks = new ArrayList<Future<HashMapToInt>>();
        for (int i = blk; i < s; i += blk) {
            int start = i;
            int end = Math.min(i + blk, s);
            tasks.add(pool.submit(() -> this.createRecodeMap(estimate, start, end)));
        }
        HashMapToInt map = new HashMapToInt((int)((double)estimate * 1.3));
        this.createRecodeMap(map, 0, blk);
        for (int i = 0; i < tasks.size(); ++i) {
            HashMapToInt map2 = (HashMapToInt)((Future)tasks.get(i)).get();
            Array.mergeRecodeMaps(map, map2);
        }
        return map;
    }

    protected static <T> void mergeRecodeMaps(HashMapToInt<T> target, HashMapToInt<T> from) {
        ArrayList<Object> fromEntriesOrdered = new ArrayList<Object>(Collections.nCopies(from.size(), null));
        from.forEach((BiConsumer<T, Integer>)((BiConsumer<Object, Integer>)(k, v) -> fromEntriesOrdered.set(v - 1, k)));
        int id = target.size();
        for (Object e : fromEntriesOrdered) {
            if (target.putIfAbsentI(e, id) != -1) continue;
            ++id;
        }
    }

    protected HashMapToInt<T> createRecodeMap(int estimate, int s, int e) {
        HashMapToInt map = new HashMapToInt((int)((double)Math.min((long)estimate, (long)(e - s)) * 1.3));
        return this.createRecodeMap(map, s, e);
    }

    protected HashMapToInt<T> createRecodeMap(HashMapToInt<T> map, int s, int e) {
        int id = 1;
        for (int i = s; i < e; ++i) {
            id = this.addValRecodeMap(map, id, i);
        }
        return map;
    }

    protected int addValRecodeMap(HashMapToInt<T> map, int id, int i) {
        T val = this.getInternal(i);
        if (val != null && map.putIfAbsentI(val, id) == -1) {
            ++id;
        }
        return id;
    }

    public final int size() {
        return this._size;
    }

    public abstract T get(int var1);

    public T getInternal(int index) {
        return this.get(index);
    }

    public abstract Object get();

    public abstract double getAsDouble(int var1);

    public double getAsNaNDouble(int i) {
        return this.getAsDouble(i);
    }

    public abstract void set(int var1, T var2);

    public abstract void set(int var1, double var2);

    public abstract void set(int var1, String var2);

    public abstract void setFromOtherType(int var1, int var2, Array<?> var3);

    public final void set(int rl, int ru, Array<T> value) {
        this.set(rl, ru, value, 0);
    }

    public void set(int rl, int ru, Array<T> value, int rlSrc) {
        int i = rl;
        int off = rlSrc;
        while (i <= ru) {
            this.set(i, value.getInternal(off));
            ++i;
            ++off;
        }
    }

    public final void setNz(Array<T> value) {
        this.setNz(0, value.size() - 1, value);
    }

    public abstract void setNz(int var1, int var2, Array<T> var3);

    public final void setFromOtherTypeNz(Array<?> value) {
        this.setFromOtherTypeNz(0, value.size() - 1, value);
    }

    public abstract void setFromOtherTypeNz(int var1, int var2, Array<?> var3);

    public abstract void append(String var1);

    public abstract void append(T var1);

    public abstract Array<T> append(Array<T> var1);

    public abstract Array<T> slice(int var1, int var2);

    public abstract void reset(int var1);

    public abstract byte[] getAsByteArray();

    public abstract Types.ValueType getValueType();

    public final Pair<Types.ValueType, Boolean> analyzeValueType() {
        return this.analyzeValueType(this.size());
    }

    public abstract Pair<Types.ValueType, Boolean> analyzeValueType(int var1);

    public abstract ArrayFactory.FrameArrayType getFrameArrayType();

    public long getInMemorySize() {
        return Array.baseMemoryCost();
    }

    public static long baseMemoryCost() {
        return 32L;
    }

    public abstract long getExactSerializedSize();

    public ABooleanArray getNulls() {
        return null;
    }

    public boolean containsNull() {
        return false;
    }

    public abstract boolean possiblyContainsNaN();

    public Array<?> changeType(Types.ValueType t, boolean containsNull) {
        return containsNull ? this.changeTypeWithNulls(t) : this.changeType(t);
    }

    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        if (t == this.getValueType()) {
            return this;
        }
        ABooleanArray nulls = this.getNulls();
        if (nulls == null || t == Types.ValueType.STRING) {
            return this.changeType(t);
        }
        return this.changeTypeWithNulls(ArrayFactory.allocateOptional(t, this.size()));
    }

    public final Array<?> changeTypeWithNulls(Array<?> ret) {
        return this.changeTypeWithNulls(ret, 0, ret.size());
    }

    public final Array<?> changeTypeWithNulls(Array<?> ret, int l, int u) {
        if (ret instanceof OptionalArray) {
            return this.changeTypeWithNulls((OptionalArray)ret, l, u);
        }
        return this.changeType(ret, l, u);
    }

    private OptionalArray<?> changeTypeWithNulls(OptionalArray<?> ret, int l, int u) {
        if (this.getValueType() == Types.ValueType.STRING) {
            ret._n.setNullsFromString(l, u, this);
        } else {
            ret._n.set(l, u - 1, this.getNulls());
        }
        this.changeType(ret._a, l, u);
        return ret;
    }

    public Array<?> changeType(Types.ValueType t) {
        if (t == this.getValueType()) {
            return this;
        }
        return this.changeType(ArrayFactory.allocate(t, this.size()));
    }

    public final Array<?> changeType(Array<?> ret) {
        return this.changeType(ret, 0, ret.size());
    }

    public final Array<?> changeType(Array<?> ret, int rl, int ru) {
        switch (ret.getValueType()) {
            case BOOLEAN: {
                if (ret instanceof BitSetArray || ret instanceof OptionalArray && ((OptionalArray)ret)._a instanceof BitSetArray) {
                    return this.changeTypeBitSet(ret, rl, ru);
                }
                return this.changeTypeBoolean(ret, rl, ru);
            }
            case FP32: {
                return this.changeTypeFloat(ret, rl, ru);
            }
            case FP64: {
                return this.changeTypeDouble(ret, rl, ru);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return this.changeTypeInteger(ret, rl, ru);
            }
            case HASH32: {
                return this.changeTypeHash32(ret, rl, ru);
            }
            case HASH64: {
                return this.changeTypeHash64(ret, rl, ru);
            }
            case INT64: {
                return this.changeTypeLong(ret, rl, ru);
            }
            case CHARACTER: {
                return this.changeTypeCharacter(ret, rl, ru);
            }
        }
        return this.changeTypeString(ret, rl, ru);
    }

    protected abstract Array<Boolean> changeTypeBitSet(Array<Boolean> var1, int var2, int var3);

    protected abstract Array<Boolean> changeTypeBoolean(Array<Boolean> var1, int var2, int var3);

    protected abstract Array<Double> changeTypeDouble(Array<Double> var1, int var2, int var3);

    protected abstract Array<Float> changeTypeFloat(Array<Float> var1, int var2, int var3);

    protected abstract Array<Integer> changeTypeInteger(Array<Integer> var1, int var2, int var3);

    protected abstract Array<Long> changeTypeLong(Array<Long> var1, int var2, int var3);

    protected abstract Array<Object> changeTypeHash64(Array<Object> var1, int var2, int var3);

    protected abstract Array<Object> changeTypeHash32(Array<Object> var1, int var2, int var3);

    protected abstract Array<String> changeTypeString(Array<String> var1, int var2, int var3);

    protected abstract Array<Character> changeTypeCharacter(Array<Character> var1, int var2, int var3);

    public Pair<Integer, Integer> getMinMaxLength() {
        throw new DMLRuntimeException("Length is only relevant if case is String");
    }

    public abstract void fill(String var1);

    public abstract void fill(T var1);

    public abstract boolean isShallowSerialize();

    public abstract boolean isEmpty();

    public abstract Array<T> select(int[] var1);

    public abstract Array<T> select(boolean[] var1, int var2);

    public final void findEmpty(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (!this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract boolean isNotEmpty(int var1);

    public void findEmptyInverse(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract Array<T> clone();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract double hashDouble(int var1);

    public ArrayIterator getIterator() {
        return new ArrayIterator();
    }

    public boolean equals(Object other) {
        return other instanceof Array && ((Array)other).getValueType() == this.getValueType() && this.equals((Array)other);
    }

    public double[] extractDouble(double[] ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            ret[i - rl] = this.getAsDouble(i);
        }
        return ret;
    }

    public abstract boolean equals(Array<T> var1);

    protected int estMemSizePerElement(Types.ValueType vt, long memSize) {
        int memSizePerElement;
        switch (vt) {
            case FP32: 
            case UINT4: 
            case UINT8: 
            case INT32: 
            case HASH32: {
                memSizePerElement = 4;
                break;
            }
            case FP64: 
            case HASH64: 
            case INT64: {
                memSizePerElement = 8;
                break;
            }
            case CHARACTER: {
                memSizePerElement = 2;
                break;
            }
            case BOOLEAN: {
                memSizePerElement = 1;
                break;
            }
            default: {
                memSizePerElement = (int)(memSize / (long)this.size());
            }
        }
        return memSizePerElement;
    }

    public ArrayCompressionStatistics statistics(int nSamples) {
        boolean sampledAllRows;
        Pair<Types.ValueType, Boolean> vt = this.analyzeValueType(nSamples);
        if (vt.getKey() == Types.ValueType.UNKNOWN) {
            vt = this.analyzeValueType();
        }
        if (vt.getKey() == Types.ValueType.UNKNOWN) {
            vt = new Pair<Types.ValueType, Boolean>(Types.ValueType.STRING, false);
        }
        long memSize = vt.getKey() != this.getValueType() ? ArrayFactory.getInMemorySize(vt.getKey(), this.size(), this.containsNull()) : this.getInMemorySize();
        int memSizePerElement = this.estMemSizePerElement(vt.getKey(), memSize);
        int estDistinct = this.estimateDistinct(nSamples);
        long ddcSize = DDCArray.estimateInMemorySize(memSizePerElement, estDistinct, this.size());
        boolean bl = sampledAllRows = nSamples == this.size();
        if (ddcSize < memSize) {
            return new ArrayCompressionStatistics(memSizePerElement, estDistinct, true, vt.getKey(), vt.getValue(), ArrayFactory.FrameArrayType.DDC, this.getInMemorySize(), ddcSize, sampledAllRows);
        }
        if (vt.getKey() != this.getValueType()) {
            return new ArrayCompressionStatistics(memSizePerElement, estDistinct, false, vt.getKey(), vt.getValue(), null, this.getInMemorySize(), memSize, sampledAllRows);
        }
        return new ArrayCompressionStatistics(memSizePerElement, estDistinct, false, vt.getKey(), vt.getValue(), null, this.getInMemorySize(), memSize, sampledAllRows);
    }

    protected int estimateDistinct(int nSamples) {
        int nSamplesTaken;
        HashMap<T, Integer> d = new HashMap<T, Integer>(Math.min(nSamples / 10, 1024));
        for (nSamplesTaken = 0; nSamplesTaken < nSamples && !this.earlyAbortEstimateDistinct(d.size(), nSamplesTaken, nSamples); ++nSamplesTaken) {
            T key = this.get(nSamplesTaken);
            if (d.containsKey(key)) {
                d.put(key, (Integer)d.get(key) + 1);
                continue;
            }
            d.put(key, 1);
        }
        if (this.earlyAbortEstimateDistinct(d.size(), nSamplesTaken, nSamples)) {
            LOG.warn((Object)("Early abort stats and compress : " + nSamplesTaken + " " + nSamples));
            return this.size();
        }
        int[] freq = new int[d.size()];
        int id = 0;
        for (Integer e : d.values()) {
            freq[id++] = e;
        }
        return SampleEstimatorFactory.distinctCount(freq, this.size(), nSamplesTaken);
    }

    protected boolean earlyAbortEstimateDistinct(int distinctFound, int samplesTaken, int maxSamples) {
        return samplesTaken * 100 >= maxSamples * 10 && distinctFound * 100 >= samplesTaken * 60;
    }

    protected int setAndAddToDict(HashMapToInt<T> rcd, AMapToData m, int i, int id) {
        T val = this.getInternal(i);
        int v = rcd.putIfAbsentI(val, id);
        if (v == -1) {
            m.set(i, id);
            ++id;
        } else {
            m.set(i, v);
        }
        return id;
    }

    public double[] minMax() {
        return this.minMax(0, this.size());
    }

    public double[] minMax(int l, int u) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = l; i < u; ++i) {
            double inVal = this.getAsDouble(i);
            if (Double.isNaN(inVal)) continue;
            min = Math.min(min, inVal);
            max = Math.max(max, inVal);
        }
        return new double[]{min, max};
    }

    public void setM(HashMapToInt<T> map, AMapToData m, int i) {
        m.set(i, map.getI(this.getInternal(i)) - 1);
    }

    public void setM(HashMapToInt<T> map, int si, AMapToData m, int i) {
        T v = this.getInternal(i);
        if (v != null) {
            m.set(i, map.getI(v) - 1);
        } else {
            m.set(i, si);
        }
    }

    public class ArrayIterator
    implements Iterator<T> {
        int index = -1;

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < Array.this.size() - 1;
        }

        @Override
        public T next() {
            return Array.this.get(++this.index);
        }
    }
}

