/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;

public interface FrameUtil {
    public static final Log LOG = LogFactory.getLog((String)FrameUtil.class.getName());
    public static final String SCHEMA_SEPARATOR = "\u00b7";
    public static final Pattern booleanPattern = Pattern.compile("([tT]((rue)|(RUE))?|[fF]((alse)|(ALSE))?|0\\.0+|1\\.0+|0|1)");
    public static final Pattern integerFloatPattern = Pattern.compile("[-+]?\\d+(\\.0+)?");
    public static final Pattern floatPattern = Pattern.compile("[-+]?[0-9][0-9]*\\.?[0-9]*([eE][-+]?[0-9]+)?");
    public static final Pattern dotSplitPattern = Pattern.compile("\\.");

    public static Array<?>[] add(Array<?>[] ar, Array<?> e) {
        if (ar == null) {
            return new Array[]{e};
        }
        Array[] ret = new Array[ar.length + 1];
        System.arraycopy(ar, 0, ret, 0, ar.length);
        ret[ar.length] = e;
        return ret;
    }

    private static boolean isBooleanType(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    private static Types.ValueType isBooleanType(String val, int len) {
        if (len == 1 && FrameUtil.isBooleanType(val.charAt(0))) {
            return Types.ValueType.BOOLEAN;
        }
        if (len <= 16 && FrameUtil.isBooleanType(val.charAt(0)) && booleanPattern.matcher(val).matches()) {
            return Types.ValueType.BOOLEAN;
        }
        return null;
    }

    private static boolean simpleIntMatch(String val, int len) {
        int i = 0;
        if (val.charAt(i) == '-') {
            ++i;
        }
        while (i < len) {
            char c = val.charAt(i);
            if (c == '.' && i > 0) {
                return FrameUtil.restIsZero(val, i + 1, len);
            }
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean restIsZero(String val, int i, int len) {
        while (i < len) {
            if (val.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Types.ValueType intType(long value) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return Types.ValueType.INT32;
        }
        return Types.ValueType.INT64;
    }

    public static Types.ValueType isIntType(String val, int len) {
        if (len <= 22 && FrameUtil.simpleIntMatch(val, len)) {
            if (len < 8) {
                return Types.ValueType.INT32;
            }
            return FrameUtil.intType(LongArray.parseLong(val));
        }
        return null;
    }

    public static Types.ValueType isHash(String val, int len) {
        if (len >= 4 && len <= 16) {
            for (int i = 0; i < len; ++i) {
                char v = val.charAt(i);
                if (v >= '0' && v <= '9' || v >= 'a' && v <= 'f') continue;
                return null;
            }
            return len <= 8 ? Types.ValueType.HASH32 : Types.ValueType.HASH64;
        }
        return null;
    }

    public static Types.ValueType isFloatType(String val, int len) {
        char sec;
        if (len <= 30 && (FrameUtil.simpleFloatMatch(val, len) || floatPattern.matcher(val).matches())) {
            if (len <= 7 || len == 8 && val.charAt(0) == '-') {
                return Types.ValueType.FP32;
            }
            if (len >= 13) {
                return Types.ValueType.FP64;
            }
            double d = Double.parseDouble(val);
            if (d >= 10000.0 || d < 1.0E-5) {
                return Types.ValueType.FP64;
            }
            if (FrameUtil.same(d, (float)d)) {
                return Types.ValueType.FP32;
            }
            return Types.ValueType.FP64;
        }
        char first = val.charAt(0);
        if (len >= 3 && (first == 'i' || first == 'I')) {
            String val2 = val.toLowerCase();
            if (len == 3 && val2.equals("inf") || len == 8 && val2.equals("infinity")) {
                return Types.ValueType.FP32;
            }
        } else if (len == 3 & (first == 'n' || first == 'N')) {
            String val2 = val.toLowerCase();
            if (val2.equals("nan")) {
                return Types.ValueType.FP32;
            }
        } else if (len > 1 && first == '-' && ((sec = val.charAt(1)) == 'i' || sec == 'I')) {
            String val2 = val.toLowerCase();
            if (len == 4 && val2.equals("-inf") || len == 9 && val2.equals("-infinity")) {
                return Types.ValueType.FP32;
            }
        }
        return null;
    }

    private static boolean simpleFloatMatch(String val, int len) {
        int start;
        boolean encounteredDot = false;
        for (int i = start = val.charAt(0) == '-' && len > 1 ? 1 : 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (c == '.') {
                if (encounteredDot) {
                    return false;
                }
                encounteredDot = true;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean same(double d, float f) {
        String v1 = Float.toString(f);
        String v2 = Double.toString(d);
        return v1.equals(v2);
    }

    public static Types.ValueType isType(String val, Types.ValueType minType) {
        if (val == null) {
            return Types.ValueType.UNKNOWN;
        }
        int len = val.length();
        if (len == 0) {
            return Types.ValueType.UNKNOWN;
        }
        Types.ValueType r = null;
        switch (minType) {
            case UNKNOWN: 
            case BOOLEAN: {
                if (FrameUtil.isBooleanType(val, len) != null) {
                    return Types.ValueType.BOOLEAN;
                }
            }
            case UINT8: 
            case INT32: 
            case INT64: {
                r = FrameUtil.isIntType(val, len);
                if (r != null) {
                    return r;
                }
            }
            case FP32: 
            case FP64: {
                r = FrameUtil.isFloatType(val, len);
                if (r != null) {
                    return r;
                }
            }
            case CHARACTER: {
                if (len == 1) {
                    return Types.ValueType.CHARACTER;
                }
            }
            case HASH32: 
            case HASH64: {
                r = FrameUtil.isHash(val, len);
                if (r == null) break;
                return r;
            }
        }
        return Types.ValueType.STRING;
    }

    public static Types.ValueType isType(String val) {
        return FrameUtil.isType(val, Types.ValueType.BOOLEAN);
    }

    public static Types.ValueType isType(double val) {
        if (val == 1.0 || val == 0.0) {
            return Types.ValueType.BOOLEAN;
        }
        if ((double)((long)val) == val) {
            if ((double)((int)val) == val) {
                return Types.ValueType.INT32;
            }
            return Types.ValueType.INT64;
        }
        if (FrameUtil.same(val, (float)val)) {
            return Types.ValueType.FP32;
        }
        return Types.ValueType.FP64;
    }

    public static Types.ValueType isType(double val, Types.ValueType min) {
        switch (min) {
            case BOOLEAN: {
                if (val == 1.0 || val == 0.0) {
                    return Types.ValueType.BOOLEAN;
                }
            }
            case UINT8: 
            case INT32: 
            case UINT4: {
                if ((double)((int)val) == val) {
                    return Types.ValueType.INT32;
                }
            }
            case INT64: {
                if ((double)((long)val) == val) {
                    return Types.ValueType.INT64;
                }
            }
            case FP32: {
                if (!FrameUtil.same(val, (float)val)) break;
                return Types.ValueType.FP32;
            }
        }
        return Types.ValueType.FP64;
    }

    public static FrameBlock mergeSchema(FrameBlock temp1, FrameBlock temp2) {
        int nCol = temp1.getNumColumns();
        if (nCol != temp2.getNumColumns()) {
            throw new DMLRuntimeException("Schema dimension mismatch: " + nCol + " vs " + temp2.getNumColumns());
        }
        FrameBlock mergedFrame = new FrameBlock(temp1.getSchema());
        mergedFrame.ensureAllocatedColumns(1);
        for (int i = 0; i < nCol; ++i) {
            String s2;
            String s1 = (String)temp1.get(0, i);
            if (!s1.equals(s2 = (String)temp2.get(0, i))) {
                Types.ValueType v1 = Types.ValueType.valueOf(s1);
                Types.ValueType v2 = Types.ValueType.valueOf(s2);
                Types.ValueType vc = Types.ValueType.getHighestCommonTypeSafe(v1, v2);
                mergedFrame.set(0, i, vc.toString());
                continue;
            }
            mergedFrame.set(0, i, s1);
        }
        return mergedFrame;
    }

    public static boolean isDefault(String v, Types.ValueType t) {
        if (v == null) {
            return true;
        }
        switch (t) {
            case BOOLEAN: {
                return !BooleanArray.parseBoolean(v);
            }
            case CHARACTER: {
                return '\u0000' == CharArray.parseChar(v);
            }
            case FP32: {
                return 0.0f == FloatArray.parseFloat(v);
            }
            case FP64: {
                return 0.0 == DoubleArray.parseDouble(v);
            }
            case UINT8: 
            case INT32: {
                return 0 == IntegerArray.parseInt(v);
            }
            case INT64: {
                return 0L == LongArray.parseLong(v);
            }
        }
        return false;
    }
}

