/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.TriggerBroadcastTask;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class BroadcastCPInstruction
extends UnaryCPInstruction {
    private BroadcastCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Broadcast, op, in, out, opcode, istr);
    }

    public static BroadcastCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2, 3);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new BroadcastCPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ec.setVariable(this.output.getName(), ec.getMatrixObject(this.input1));
        CommonThreadPool.getDynamicPool().submit(new TriggerBroadcastTask(ec, ec.getMatrixObject(this.output)));
    }
}

