/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.ApplicationStoreInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.History$HybridStoreDiskBackend$;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u0017.\taB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001dI\u0007A1A\u0005\n)Daa\u001b\u0001!\u0002\u0013Y\u0005b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000fU\u0004!\u0019!C\u0005U\"1a\u000f\u0001Q\u0001\n-Cqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t\t\u0002\u0001Q\u0001\n}D\u0001\"a\u0005\u0001\u0005\u0004%IA \u0005\b\u0003+\u0001\u0001\u0015!\u0003\u0000\u0011%\t9\u0002\u0001b\u0001\n\u0013\tI\u0002\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u000e\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!a\u0016\u0001\t\u0003\tI\u0006C\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\u0010\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003w\u0003\u0011\u0013!C\u0001\u0003\u001fCq!!0\u0001\t\u0003\ty\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005%\u0007\u0001\"\u0001\u0002H\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\t\u00033\u0004A\u0011A\u0017\u0002\\\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAw\u0001\u0011%\u0011q\u001e\u0005\n\u0003o\u0004\u0011\u0013!C\u0005\u0003\u001fC\u0001\"!?\u0001\t\u0003i\u00131 \u0004\b\u0003?\u0002\u0001!LA1\u0011%\t\u0019\u0007\nBC\u0002\u0013\u0005!\u000eC\u0005\u0002f\u0011\u0012\t\u0011)A\u0005\u0017\"I\u0011q\r\u0013\u0003\u0006\u0004%I\u0001\u001f\u0005\n\u0003S\"#\u0011!Q\u0001\neDa!\u0019\u0013\u0005\u0002\u0005-\u0004bBA9I\u0011\u0005\u00111\u000f\u0005\b\u0003{\"C\u0011AA(\u0005aA\u0015n\u001d;pef\u001cVM\u001d<fe\u0012K7o['b]\u0006<WM\u001d\u0006\u0003]=\nq\u0001[5ti>\u0014\u0018P\u0003\u00021c\u00051A-\u001a9m_fT!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u000b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0011\u000b%a\u0002'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u0002H\u00116\t\u0011'\u0003\u0002Jc\tI1\u000b]1sW\u000e{gNZ\u0001\u0005a\u0006$\b\u000e\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006\u0011\u0011n\u001c\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0003GS2,\u0017a\u00027jgRLgn\u001a\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bqa\u001b<ti>\u0014XM\u0003\u0002Zc\u0005!Q\u000f^5m\u0013\tYfKA\u0004L-N#xN]3\u0002\u000b\rdwnY6\u0011\u0005y{V\"\u0001-\n\u0005\u0001D&!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\bF\u0003dK\u001a<\u0007\u000e\u0005\u0002e\u00015\tQ\u0006C\u0003F\u000b\u0001\u0007a\tC\u0003K\u000b\u0001\u00071\nC\u0003T\u000b\u0001\u0007A\u000bC\u0003]\u000b\u0001\u0007Q,A\u0006baB\u001cFo\u001c:f\t&\u0014X#A&\u0002\u0019\u0005\u0004\bo\u0015;pe\u0016$\u0015N\u001d\u0011\u0002\u0013\u0015DH/\u001a8tS>tW#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E|\u0015\u0001\u00027b]\u001eL!a\u001d9\u0003\rM#(/\u001b8h\u0003))\u0007\u0010^3og&|g\u000eI\u0001\fi6\u00048\u000b^8sK\u0012K'/\u0001\u0007u[B\u001cFo\u001c:f\t&\u0014\b%\u0001\u0005nCb,6/Y4f+\u0005I\bC\u0001\u001e{\u0013\tY8H\u0001\u0003M_:<\u0017!C7bqV\u001b\u0018mZ3!\u00031\u0019WO\u001d:f]R,6/Y4f+\u0005y\b\u0003BA\u0001\u0003\u001bi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007CR|W.[2\u000b\t\u0005%\u00111B\u0001\u000bG>t7-\u001e:sK:$(BA-P\u0013\u0011\ty!a\u0001\u0003\u0015\u0005#x.\\5d\u0019>tw-A\u0007dkJ\u0014XM\u001c;Vg\u0006<W\rI\u0001\u000fG>lW.\u001b;uK\u0012,6/Y4f\u0003=\u0019w.\\7jiR,G-V:bO\u0016\u0004\u0013AB1di&4X-\u0006\u0002\u0002\u001cA9\u0011QDA\u0014\u0003WIXBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000f5,H/\u00192mK*\u0019\u0011QE\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002*\u0005}!a\u0002%bg\"l\u0015\r\u001d\t\bu\u00055\u0012\u0011GA#\u0013\r\tyc\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005M\u0012\u0011\t\b\u0005\u0003k\ti\u0004E\u0002\u00028mj!!!\u000f\u000b\u0007\u0005mr'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u007fY\u0014A\u0002)sK\u0012,g-C\u0002t\u0003\u0007R1!a\u0010<!\u0015Q\u0014qIA\u0019\u0013\r\tIe\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000f\u0005\u001cG/\u001b<fA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0005\u0005E\u0003c\u0001\u001e\u0002T%\u0019\u0011QK\u001e\u0003\tUs\u0017\u000e^\u0001\u0006Y\u0016\f7/\u001a\u000b\u0007\u00037\ny(a!\u0011\u0007\u0005uC%D\u0001\u0001\u0005\u0015aU-Y:f'\t!\u0013(A\u0004u[B\u0004\u0016\r\u001e5\u0002\u0011Ql\u0007\u000fU1uQ\u0002\na\u0001\\3bg\u0016$\u0017a\u00027fCN,G\r\t\u000b\u0007\u00037\ni'a\u001c\t\r\u0005\r\u0014\u00061\u0001L\u0011\u0019\t9'\u000ba\u0001s\u000611m\\7nSR$RaSA;\u0003sBq!a\u001e+\u0001\u0004\t\t$A\u0003baBLE\rC\u0004\u0002|)\u0002\r!!\u0012\u0002\u0013\u0005$H/Z7qi&#\u0017\u0001\u0003:pY2\u0014\u0017mY6\t\r\u0005\u0005U\u00031\u0001z\u00031)g/\u001a8u\u0019><7+\u001b>f\u0011%\t))\u0006I\u0001\u0002\u0004\t9)\u0001\u0007jg\u000e{W\u000e\u001d:fgN,G\rE\u0002;\u0003\u0013K1!a#<\u0005\u001d\u0011un\u001c7fC:\fq\u0002\\3bg\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003#SC!a\"\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 n\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005pa\u0016t7\u000b^8sKR1\u0011\u0011VAV\u0003[\u0003BAOA$\u0017\"9\u0011qO\fA\u0002\u0005E\u0002bBA>/\u0001\u0007\u0011QI\u0001\be\u0016dW-Y:f)!\t\t&a-\u00026\u0006]\u0006bBA<1\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003wB\u0002\u0019AA#\u0011%\tI\f\u0007I\u0001\u0002\u0004\t9)\u0001\u0004eK2,G/Z\u0001\u0012e\u0016dW-Y:fI\u0011,g-Y;mi\u0012\u001a\u0014aD1qaJ|\u00070[7bi\u0016\u001c\u0016N_3\u0015\u000be\f\t-a1\t\r\u0005\u0005%\u00041\u0001z\u0011\u001d\t)I\u0007a\u0001\u0003\u000f\u000bAA\u001a:fKR\t\u00110A\u0005d_6l\u0017\u000e\u001e;fI\u0006YA-\u001a7fi\u0016\u001cFo\u001c:f)\u0011\t\t&a4\t\u000b)k\u0002\u0019A&\u0002\u00115\f7.\u001a*p_6$B!!\u0015\u0002V\"1\u0011q\u001b\u0010A\u0002e\fAa]5{K\u0006a\u0011\r\u001d9Ti>\u0014X\rU1uQR)1*!8\u0002`\"9\u0011qO\u0010A\u0002\u0005E\u0002bBA>?\u0001\u0007\u0011QI\u0001\u001bkB$\u0017\r^3BaBd\u0017nY1uS>t7\u000b^8sK&sgm\u001c\u000b\t\u0003#\n)/a:\u0002j\"9\u0011q\u000f\u0011A\u0002\u0005E\u0002bBA>A\u0001\u0007\u0011Q\t\u0005\u0007\u0003W\u0004\u0003\u0019A=\u0002\u000f9,woU5{K\u0006YQ\u000f\u001d3bi\u0016,6/Y4f)\u0019\t\t&!=\u0002v\"1\u00111_\u0011A\u0002e\fQ\u0001Z3mi\u0006D\u0011\"!3\"!\u0003\u0005\r!a\"\u0002+U\u0004H-\u0019;f+N\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u000511/\u001b>f\u001f\u001a$2!_A\u007f\u0011\u0015Q5\u00051\u0001L\u0001")
public class HistoryServerDiskManager
implements Logging {
    private final KVStore listing;
    private final Clock clock;
    private final File appStoreDir;
    private final String extension;
    private final File tmpStoreDir;
    private final long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    private final AtomicLong currentUsage;
    private final AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    private final HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private File appStoreDir() {
        return this.appStoreDir;
    }

    private String extension() {
        return this.extension;
    }

    private File tmpStoreDir() {
        return this.tmpStoreDir;
    }

    public long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    }

    private AtomicLong currentUsage() {
        return this.currentUsage;
    }

    public AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    }

    public HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    }

    public void initialize() {
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(this.sizeOf(this.appStoreDir()), true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tmpStoreDir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$1(x$1)));
        Tuple2 tuple2 = KVUtils$.MODULE$.viewToSeq(this.listing.view(ApplicationStoreInfo.class)).partition((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$2(info)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq existences = (Seq)tuple2._1();
        Seq orphans = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existences, (Object)orphans);
        Seq existences2 = (Seq)tuple22._1();
        Seq orphans2 = (Seq)tuple22._2();
        orphans2.foreach((Function1 & Serializable & scala.Serializable)info -> {
            this.listing.delete(info.getClass(), (Object)info.path());
            return BoxedUnit.UNIT;
        });
        existences2.foreach((Function1 & Serializable & scala.Serializable)info -> {
            HistoryServerDiskManager.$anonfun$initialize$4(this, info);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Initialized disk manager: ").append("current usage = ").append(Utils$.MODULE$.bytesToString(this.currentUsage().get())).append(", ").append("max usage = ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).toString());
    }

    public Lease lease(long eventLogSize, boolean isCompressed) {
        long needed = this.approximateSize(eventLogSize, isCompressed);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(needed);
        File tmp = Utils$.MODULE$.createTempDir(this.tmpStoreDir().getPath(), "appstore");
        Utils$.MODULE$.chmod700(tmp);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(needed, this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
        long current = this.currentUsage().get();
        if (current > this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Lease of ").append(Utils$.MODULE$.bytesToString(needed)).append(" may cause usage to exceed max ").append("(").append(Utils$.MODULE$.bytesToString(current)).append(" > ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).append(")").toString());
        }
        return new Lease(this, tmp, needed);
    }

    public boolean lease$default$2() {
        return false;
    }

    public Option<File> openStore(String appId, Option<String> attemptId) {
        None$ none$;
        LongRef newSize = LongRef.create((long)0L);
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            None$ none$2;
            File path2 = this.appStorePath(appId, attemptId);
            if (path2.isDirectory()) {
                newSize.elem = this.sizeOf(path2);
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)newSize.elem));
                none$2 = new Some((Object)path2);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ storePath = none$;
        storePath.foreach((Function1 & Serializable & scala.Serializable)path -> {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateApplicationStoreInfo(appId, (Option<String>)attemptId, newSize.elem);
            return BoxedUnit.UNIT;
        });
        return storePath;
    }

    public void release(String appId, Option<String> attemptId, boolean delete) {
        Option option;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            option = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().remove((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId));
        }
        Option oldSizeOpt = option;
        oldSizeOpt.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)oldSize -> {
            File path = this.appStorePath(appId, attemptId);
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-oldSize, true);
            if (path.isDirectory()) {
                if (delete) {
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(path);
                    return;
                }
                long newSize = this.sizeOf(path);
                ApplicationStoreInfo qual$1 = (ApplicationStoreInfo)$this.listing.read(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
                long x$1 = newSize;
                String x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                String x$4 = qual$1.copy$default$3();
                Option<String> x$5 = qual$1.copy$default$4();
                ApplicationStoreInfo newInfo = qual$1.copy(x$2, x$3, x$4, x$5, x$1);
                $this.listing.write((Object)newInfo);
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
                return;
            }
        });
    }

    public boolean release$default$3() {
        return false;
    }

    public long approximateSize(long eventLogSize, boolean isCompressed) {
        if (isCompressed) {
            return eventLogSize * 2L;
        }
        return eventLogSize / 2L;
    }

    public long free() {
        return package$.MODULE$.max(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() - this.currentUsage().get(), 0L);
    }

    public long committed() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get();
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(File path) {
        FileUtils.deleteDirectory((File)path);
        this.listing.delete(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(long size) {
        if (this.free() < size) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not enough free space, looking at candidates for deletion...");
            ListBuffer evicted = new ListBuffer();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.listing.view(ApplicationStoreInfo.class).index("lastAccess").closeableIterator(), (Function1 & Serializable & scala.Serializable)iter -> {
                HistoryServerDiskManager.$anonfun$makeRoom$3(this, size, evicted, iter);
                return BoxedUnit.UNIT;
            });
            if (evicted.nonEmpty()) {
                long freed = BoxesRunTime.unboxToLong((Object)((TraversableForwarder)evicted.map((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToLong((long)HistoryServerDiskManager.$anonfun$makeRoom$4(this, info)), ListBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Deleted ").append(evicted.size()).append(" store(s) to free ").append(Utils$.MODULE$.bytesToString(freed)).append(" ").append("(target = ").append(Utils$.MODULE$.bytesToString(size)).append(").").toString());
                return;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unable to free any space to make room for ").append(Utils$.MODULE$.bytesToString(size)).append(".").toString());
            return;
        }
    }

    public File appStorePath(String appId, Option<String> attemptId) {
        String fileName = new StringBuilder(0).append(appId).append(attemptId.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append("_").append((String)x$2).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(this.extension()).toString();
        return new File(this.appStoreDir(), fileName);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateApplicationStoreInfo(String appId, Option<String> attemptId, long newSize) {
        File path = this.appStorePath(appId, attemptId);
        ApplicationStoreInfo info = new ApplicationStoreInfo(path.getAbsolutePath(), this.clock.getTimeMillis(), appId, attemptId, newSize);
        this.listing.write((Object)info);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(long delta, boolean committed) {
        long updated = this.currentUsage().addAndGet(delta);
        if (updated < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updated).append(", delta = ").append(delta).append(")").toString());
        }
        if (committed) {
            long updatedCommitted = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().addAndGet(delta);
            if (updatedCommitted < 0L) {
                throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updatedCommitted).append(", delta = ").append(delta).append(")").toString());
            }
            return;
        }
    }

    public boolean org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2() {
        return false;
    }

    public long sizeOf(File path) {
        return FileUtils.sizeOf((File)path);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(File x$1) {
        return FileUtils.deleteQuietly((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(ApplicationStoreInfo info) {
        return new File(info.path()).exists();
    }

    public static final /* synthetic */ void $anonfun$initialize$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        long fileSize = $this.sizeOf(new File(info.path()));
        if (fileSize != info.size()) {
            long x$1 = fileSize;
            String x$2 = info.copy$default$1();
            long x$3 = info.copy$default$2();
            String x$4 = info.copy$default$3();
            Option<String> x$5 = info.copy$default$4();
            $this.listing.write((Object)info.copy(x$2, x$3, x$4, x$5, x$1));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeRoom$3(HistoryServerDiskManager $this, long size$1, ListBuffer evicted$1, KVStoreIterator iter) {
        long needed = size$1;
        while (needed > 0L && iter.hasNext()) {
            boolean bl;
            ApplicationStoreInfo info = (ApplicationStoreInfo)iter.next();
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                bl = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info.appId()), info.attemptId()));
            }
            boolean isActive = bl;
            if (isActive) continue;
            evicted$1.$plus$eq((Object)info);
            needed -= info.size();
        }
    }

    public static final /* synthetic */ long $anonfun$makeRoom$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting store for ").append(info.appId()).append("/").append(info.attemptId()).append(".").toString());
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(new File(info.path()));
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-info.size(), true);
        return info.size();
    }

    public HistoryServerDiskManager(SparkConf conf, File path, KVStore listing, Clock clock) {
        this.listing = listing;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.appStoreDir = new File(path, "apps");
        if (!this.appStoreDir().isDirectory() && !this.appStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Failed to create app directory (").append(this.appStoreDir()).append(").").toString());
        }
        String string = conf.get(History$.MODULE$.HYBRID_STORE_DISK_BACKEND());
        String string2 = History$HybridStoreDiskBackend$.MODULE$.LEVELDB().toString();
        this.extension = !(string != null ? !string.equals(string2) : string2 != null) ? ".ldb" : ".rdb";
        this.tmpStoreDir = new File(path, "temp");
        if (!this.tmpStoreDir().isDirectory() && !this.tmpStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Failed to create temp directory (").append(this.tmpStoreDir()).append(").").toString());
        }
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage = BoxesRunTime.unboxToLong((Object)conf.get(History$.MODULE$.MAX_LOCAL_DISK_USAGE()));
        this.currentUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active = new HashMap();
    }

    public class Lease {
        private final File tmpPath;
        private final long leased;
        public final /* synthetic */ HistoryServerDiskManager $outer;

        public File tmpPath() {
            return this.tmpPath;
        }

        private long leased() {
            return this.leased;
        }

        public File commit(String appId, Option<String> attemptId) {
            File dst = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().appStorePath(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                Predef$.MODULE$.require(!this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cannot commit lease for active application ").append(appId).append(" / ").append(attemptId).toString());
                if (dst.isDirectory()) {
                    long size = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-size, true);
                }
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            long newSize = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(this.tmpPath());
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(newSize);
            this.tmpPath().renameTo(dst);
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
            if (this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get() > this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
                String current = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get());
                String max = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage());
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Commit of application ").append(appId).append(" / ").append(attemptId).append(" causes maximum disk usage to be ").append("exceeded (").append(current).append(" > ").append(max).append(")").toString());
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateApplicationStoreInfo(appId, attemptId, newSize);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap2) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)newSize));
            }
            return dst;
        }

        public void rollback() {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            FileUtils.deleteDirectory((File)this.tmpPath());
        }

        public /* synthetic */ HistoryServerDiskManager org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer() {
            return this.$outer;
        }

        public Lease(HistoryServerDiskManager $outer, File tmpPath, long leased) {
            this.tmpPath = tmpPath;
            this.leased = leased;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

