/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.dynamic;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.dynamic.DynamicTemplateAttribute;
import org.apache.tapestry5.internal.dynamic.DynamicTemplateElement;
import org.apache.tapestry5.internal.services.XMLTokenStream;
import org.apache.tapestry5.internal.services.XMLTokenType;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.dynamic.DynamicDelegate;
import org.apache.tapestry5.services.dynamic.DynamicTemplate;

public class DynamicTemplateSaxParser {
    private final Resource resource;
    private final BindingSource bindingSource;
    private final XMLTokenStream tokenStream;
    private static final Pattern PARAM_ID_PATTERN = Pattern.compile("^param:(\\p{Alpha}\\w*)$", 2);
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("\\$\\{\\s*(.*?)\\s*}");
    private static final DynamicTemplateElement END = new DynamicTemplateElement(){

        @Override
        public void render(MarkupWriter writer, RenderQueue queue, DynamicDelegate delegate) {
            writer.end();
        }
    };

    public DynamicTemplateSaxParser(Resource resource, BindingSource bindingSource, Map<String, URL> publicIdToURL) {
        this.resource = resource;
        this.bindingSource = bindingSource;
        this.tokenStream = new XMLTokenStream(resource, publicIdToURL);
    }

    public DynamicTemplate parse() {
        try {
            this.tokenStream.parse();
            return DynamicTemplateSaxParser.toDynamicTemplate(this.root());
        }
        catch (Exception ex) {
            throw new TapestryException(String.format("Failure parsing dynamic template %s: %s", this.resource, ExceptionUtils.toMessage((Throwable)ex)), this.tokenStream.getLocation(), (Throwable)ex);
        }
    }

    private static DynamicTemplate toDynamicTemplate(List<DynamicTemplateElement> elements) {
        final Flow flow = (Flow)F.flow(elements).reverse();
        return new DynamicTemplate(){

            @Override
            public RenderCommand createRenderCommand(DynamicDelegate delegate) {
                final Mapper toRenderCommand = DynamicTemplateSaxParser.createToRenderCommandMapper(delegate);
                return new RenderCommand(){

                    @Override
                    public void render(MarkupWriter writer, RenderQueue queue) {
                        Worker pushOnQueue = DynamicTemplateSaxParser.createQueueRenderCommand(queue);
                        flow.map(toRenderCommand).each(pushOnQueue);
                    }
                };
            }
        };
    }

    private List<DynamicTemplateElement> root() {
        List result = CollectionFactory.newList();
        block4: while (this.tokenStream.hasNext()) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    result.add(this.element());
                    continue block4;
                }
                case END_DOCUMENT: {
                    continue block4;
                }
            }
            this.addTextContent(result);
        }
        return result;
    }

    private DynamicTemplateElement element() {
        String elementURI = this.tokenStream.getNamespaceURI();
        String elementName = this.tokenStream.getLocalName();
        String blockId = null;
        int count = this.tokenStream.getAttributeCount();
        List attributes = CollectionFactory.newList();
        Location location = this.getLocation();
        for (int i = 0; i < count; ++i) {
            Matcher matcher;
            QName qname = this.tokenStream.getAttributeName(i);
            String localName = qname.getLocalPart();
            if (InternalUtils.isBlank((String)localName)) continue;
            String uri = qname.getNamespaceURI();
            String value = this.tokenStream.getAttributeValue(i);
            if (localName.equals("id") && (matcher = PARAM_ID_PATTERN.matcher(value)).matches()) {
                blockId = matcher.group(1);
                continue;
            }
            Mapper<DynamicDelegate, String> attributeValueExtractor = this.createCompositeExtractorFromText(value, location);
            attributes.add(new DynamicTemplateAttribute(uri, localName, attributeValueExtractor));
        }
        if (blockId != null) {
            return this.block(blockId);
        }
        List body = CollectionFactory.newList();
        boolean atEnd = false;
        block5: while (!atEnd) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    body.add(this.element());
                    continue block5;
                }
                case END_ELEMENT: {
                    body.add(END);
                    atEnd = true;
                    continue block5;
                }
            }
            this.addTextContent(body);
        }
        return DynamicTemplateSaxParser.createElementWriterElement(elementURI, elementName, attributes, body);
    }

    private static DynamicTemplateElement createElementWriterElement(final String elementURI, final String elementName, final List<DynamicTemplateAttribute> attributes, List<DynamicTemplateElement> body) {
        final Flow bodyFlow = (Flow)F.flow(body).reverse();
        return new DynamicTemplateElement(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue, DynamicDelegate delegate) {
                writer.elementNS(elementURI, elementName);
                for (DynamicTemplateAttribute attribute : attributes) {
                    attribute.write(writer, delegate);
                }
                Mapper toRenderCommand = DynamicTemplateSaxParser.createToRenderCommandMapper(delegate);
                Worker pushOnQueue = DynamicTemplateSaxParser.createQueueRenderCommand(queue);
                bodyFlow.map(toRenderCommand).each(pushOnQueue);
            }
        };
    }

    private DynamicTemplateElement block(String blockId) {
        Location location = this.getLocation();
        this.removeContent();
        return DynamicTemplateSaxParser.createBlockElement(blockId, location);
    }

    private static DynamicTemplateElement createBlockElement(final String blockId, final Location location) {
        return new DynamicTemplateElement(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue, DynamicDelegate delegate) {
                try {
                    Block block = delegate.getBlock(blockId);
                    queue.push((RenderCommand)((Object)block));
                }
                catch (Exception ex) {
                    throw new TapestryException(String.format("Exception rendering block '%s' as part of dynamic template: %s", blockId, ExceptionUtils.toMessage((Throwable)ex)), location, (Throwable)ex);
                }
            }
        };
    }

    private Location getLocation() {
        return this.tokenStream.getLocation();
    }

    private void removeContent() {
        int depth = 1;
        block4: while (true) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    ++depth;
                    continue block4;
                }
                case END_ELEMENT: {
                    if (--depth != 0) continue block4;
                    return;
                }
            }
        }
    }

    void addTextContent(List<DynamicTemplateElement> elements) {
        switch (this.tokenStream.getEventType()) {
            case COMMENT: {
                elements.add(this.comment());
                break;
            }
            case CHARACTERS: 
            case SPACE: {
                this.addTokensForText(elements);
                break;
            }
            default: {
                this.unexpectedEventType();
            }
        }
    }

    private void addTokensForText(List<DynamicTemplateElement> elements) {
        Mapper<DynamicDelegate, String> composite = this.createCompositeExtractorFromText(this.tokenStream.getText(), this.tokenStream.getLocation());
        elements.add(DynamicTemplateSaxParser.createTextWriterElement(composite));
    }

    private static DynamicTemplateElement createTextWriterElement(final Mapper<DynamicDelegate, String> composite) {
        return new DynamicTemplateElement(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue, DynamicDelegate delegate) {
                String value = (String)composite.map((Object)delegate);
                writer.write(value);
            }
        };
    }

    private Mapper<DynamicDelegate, String> createCompositeExtractorFromText(String text, Location location) {
        Matcher matcher = EXPANSION_PATTERN.matcher(text);
        List extractors = CollectionFactory.newList();
        int startx = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            if (matchStart != startx) {
                String prefix = text.substring(startx, matchStart);
                extractors.add(DynamicTemplateSaxParser.createTextExtractor(prefix));
            }
            String expression = matcher.group(1);
            extractors.add(DynamicTemplateSaxParser.createExpansionExtractor(expression, location, this.bindingSource));
            startx = matcher.end();
        }
        if (startx < text.length()) {
            extractors.add(DynamicTemplateSaxParser.createTextExtractor(text.substring(startx, text.length())));
        }
        if (extractors.size() == 1) {
            return (Mapper)extractors.get(0);
        }
        return DynamicTemplateSaxParser.creatCompositeExtractor(extractors);
    }

    private static Mapper<DynamicDelegate, String> creatCompositeExtractor(final List<Mapper<DynamicDelegate, String>> extractors) {
        return new Mapper<DynamicDelegate, String>(){

            public String map(DynamicDelegate delegate) {
                StringBuilder builder = new StringBuilder();
                for (Mapper extractor : extractors) {
                    String value = (String)extractor.map((Object)delegate);
                    if (value == null) continue;
                    builder.append(value);
                }
                return builder.toString();
            }
        };
    }

    private DynamicTemplateElement comment() {
        return DynamicTemplateSaxParser.createCommentElement(this.tokenStream.getText());
    }

    private static DynamicTemplateElement createCommentElement(final String content) {
        return new DynamicTemplateElement(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue, DynamicDelegate delegate) {
                writer.comment(content);
            }
        };
    }

    private static Mapper<DynamicDelegate, String> createTextExtractor(final String content) {
        return new Mapper<DynamicDelegate, String>(){

            public String map(DynamicDelegate delegate) {
                return content;
            }
        };
    }

    private static Mapper<DynamicDelegate, String> createExpansionExtractor(final String expression, final Location location, final BindingSource bindingSource) {
        return new Mapper<DynamicDelegate, String>(){

            public String map(DynamicDelegate delegate) {
                try {
                    Binding binding = bindingSource.newBinding("dynamic template binding", delegate.getComponentResources().getContainerResources(), delegate.getComponentResources(), "prop", expression, location);
                    Object boundValue = binding.get();
                    return boundValue == null ? null : boundValue.toString();
                }
                catch (Throwable t) {
                    throw new TapestryException(ExceptionUtils.toMessage((Throwable)t), location, t);
                }
            }
        };
    }

    private <T> T unexpectedEventType() {
        XMLTokenType eventType = this.tokenStream.getEventType();
        throw new IllegalStateException(String.format("Unexpected XML parse event %s.", eventType.name()));
    }

    private static Worker<RenderCommand> createQueueRenderCommand(final RenderQueue queue) {
        return new Worker<RenderCommand>(){

            public void work(RenderCommand value) {
                queue.push(value);
            }
        };
    }

    private static RenderCommand toRenderCommand(final DynamicTemplateElement value, final DynamicDelegate delegate) {
        return new RenderCommand(){

            @Override
            public void render(MarkupWriter writer, RenderQueue queue) {
                value.render(writer, queue, delegate);
            }
        };
    }

    private static Mapper<DynamicTemplateElement, RenderCommand> createToRenderCommandMapper(final DynamicDelegate delegate) {
        return new Mapper<DynamicTemplateElement, RenderCommand>(){

            public RenderCommand map(DynamicTemplateElement value) {
                return DynamicTemplateSaxParser.toRenderCommand(value, delegate);
            }
        };
    }
}

