/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.Operation;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.OperationAdvisor;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;

@PreventServiceDecoration
public class OperationAdvisorImpl
implements OperationAdvisor {
    private final OperationTracker tracker;

    public OperationAdvisorImpl(OperationTracker tracker) {
        this.tracker = tracker;
    }

    private Runnable toRunnable(final MethodInvocation invocation) {
        return new Runnable(){

            @Override
            public void run() {
                invocation.proceed();
            }
        };
    }

    @Override
    public void addOperationAdvice(MethodAdviceReceiver receiver) {
        for (Method m : receiver.getInterface().getMethods()) {
            Operation annotation = receiver.getMethodAnnotation(m, Operation.class);
            if (annotation == null) continue;
            String value = annotation.value();
            receiver.adviseMethod(m, this.createAdvice(value));
        }
    }

    @Override
    public MethodAdvice createAdvice(String description) {
        assert (InternalUtils.isNonBlank(description));
        if (description.contains("%")) {
            return new FormattedAdvice(description);
        }
        return new SimpleAdvice(description);
    }

    private class FormattedAdvice
    implements MethodAdvice {
        private final String format;

        FormattedAdvice(String format) {
            this.format = format;
        }

        public void advise(MethodInvocation invocation) {
            Object[] parameters = this.extractParameters(invocation);
            String description = String.format(this.format, parameters);
            OperationAdvisorImpl.this.tracker.run(description, OperationAdvisorImpl.this.toRunnable(invocation));
        }

        private Object[] extractParameters(MethodInvocation invocation) {
            int count = invocation.getMethod().getParameterTypes().length;
            Object[] result = new Object[count];
            for (int i = 0; i < count; ++i) {
                result[i] = invocation.getParameter(i);
            }
            return result;
        }
    }

    private class SimpleAdvice
    implements MethodAdvice {
        private final String description;

        SimpleAdvice(String description) {
            this.description = description;
        }

        public void advise(MethodInvocation invocation) {
            OperationAdvisorImpl.this.tracker.run(this.description, OperationAdvisorImpl.this.toRunnable(invocation));
        }
    }
}

