/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.pool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.pool.KryoCallback;
import org.apache.tinkerpop.shaded.kryo.pool.KryoFactory;
import org.apache.tinkerpop.shaded.kryo.pool.KryoPoolQueueImpl;
import org.apache.tinkerpop.shaded.kryo.pool.SoftReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface KryoPool {
    public Kryo borrow();

    public void release(Kryo var1);

    public <T> T run(KryoCallback<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final KryoFactory factory;
        private Queue<Kryo> queue = new ConcurrentLinkedQueue<Kryo>();
        private boolean softReferences;

        public Builder(KryoFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null");
            }
            this.factory = factory;
        }

        public Builder queue(Queue<Kryo> queue) {
            if (queue == null) {
                throw new IllegalArgumentException("queue must not be null");
            }
            this.queue = queue;
            return this;
        }

        public Builder softReferences() {
            this.softReferences = true;
            return this;
        }

        public KryoPool build() {
            Queue<Kryo> q = this.softReferences ? new SoftReferenceQueue(this.queue) : this.queue;
            return new KryoPoolQueueImpl(this.factory, q);
        }

        public String toString() {
            return this.getClass().getName() + "[queue.class=" + this.queue.getClass() + ", softReferences=" + this.softReferences + "]";
        }
    }
}

