/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TraversalMapStep<S, E>
extends MapStep<S, E>
implements TraversalParent {
    private Traversal.Admin<S, E> mapTraversal;

    public TraversalMapStep(Traversal.Admin traversal, Traversal<S, E> mapTraversal) {
        super(traversal);
        this.mapTraversal = this.integrateChild(mapTraversal.asAdmin());
    }

    @Override
    protected Traverser.Admin<E> processNextStart() throws NoSuchElementException {
        Object traverser = this.starts.next();
        Iterator<E> iterator = TraversalUtil.applyAll(traverser, this.mapTraversal);
        return iterator.hasNext() ? traverser.split(iterator.next(), this) : EmptyTraverser.instance();
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return Collections.singletonList(this.mapTraversal);
    }

    @Override
    public TraversalMapStep<S, E> clone() {
        TraversalMapStep clone = (TraversalMapStep)super.clone();
        clone.mapTraversal = this.mapTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.mapTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.mapTraversal);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.mapTraversal.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }
}

