"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatClosure = void 0;
var recreateQueryOnelinerFromSyntaxTree_1 = require("../recreateQueryOnelinerFromSyntaxTree");
var types_1 = require("../types");
var utils_1 = require("./utils");
var getClosureLineOfCodeIndentation = function (relativeIndentation, horizontalPosition, methodWidth, lineNumber) {
    if (lineNumber === 0)
        return Math.max(relativeIndentation, 0);
    return Math.max(relativeIndentation + horizontalPosition + methodWidth + 1, 0);
};
var getFormattedClosureLineOfCode = function (horizontalPosition, methodWidth) { return function (_a, lineNumber) {
    var lineOfCode = _a.lineOfCode, relativeIndentation = _a.relativeIndentation;
    return ({
        lineOfCode: lineOfCode,
        relativeIndentation: relativeIndentation,
        localIndentation: getClosureLineOfCodeIndentation(relativeIndentation, horizontalPosition, methodWidth, lineNumber),
    });
}; };
var getFormattedClosureCodeBlock = function (unformattedClosureCodeBlock, horizontalPosition, methodWidth) {
    return unformattedClosureCodeBlock.map(getFormattedClosureLineOfCode(horizontalPosition, methodWidth));
};
var formatClosure = function (formatSyntaxTree) { return function (config) { return function (syntaxTree) {
    var unformattedClosureCodeBlock = syntaxTree.closureCodeBlock, unformattedMethod = syntaxTree.method;
    var localIndentation = config.localIndentation, horizontalPosition = config.horizontalPosition, maxLineLength = config.maxLineLength, shouldEndWithDot = config.shouldEndWithDot;
    var recreatedQuery = (0, recreateQueryOnelinerFromSyntaxTree_1.default)(localIndentation)(syntaxTree);
    var formattedMethod = formatSyntaxTree((0, utils_1.withNoEndDotInfo)(config))(unformattedMethod);
    var methodWidth = formattedMethod.width;
    if (recreatedQuery.length <= maxLineLength) {
        return {
            type: types_1.TokenType.Closure,
            method: formattedMethod,
            closureCodeBlock: getFormattedClosureCodeBlock(unformattedClosureCodeBlock, horizontalPosition, methodWidth),
            localIndentation: localIndentation,
            width: recreatedQuery.trim().length,
            shouldStartWithDot: false,
            shouldEndWithDot: Boolean(shouldEndWithDot),
        };
    }
    return {
        type: types_1.TokenType.Closure,
        method: formattedMethod,
        closureCodeBlock: getFormattedClosureCodeBlock(unformattedClosureCodeBlock, horizontalPosition, methodWidth),
        localIndentation: 0,
        width: 0,
        shouldStartWithDot: false,
        shouldEndWithDot: Boolean(shouldEndWithDot),
    };
}; }; };
exports.formatClosure = formatClosure;
