package org.apache.stratum.scheduler;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This bean represents the settings used to assign thread pool properties for use in the Quartz scheduler.
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: ThreadPoolConfig.java 264191 2005-08-29 18:07:52Z henning $
 */
public class ThreadPoolConfig
{
    /** The loggername used by the Quartz threadpool */
    private String loggerName;

    /** The classname used by the Quartz threadpool */
    private String className;

    /** The threadcount used by the Quartz threadpool */
    private String threadCount;

    /** The thread priority used by the Quartz threadpool */
    private String threadPriority;

    /**
     * Default contructor
     */
    public ThreadPoolConfig()
    {
    }

    /**
     * This is the reference name of the logger that has been registered with Quartz that will be used by the Quartz threadpool.
     *
     * @param s logger name
     */
    public void setLoggerName(String s)
    {
        this.loggerName = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the name of the logger for the threadpool
     */
    public String getLoggerName()
    {
        return this.loggerName;
    }

    /**
     * This is the full package/class name of the class used for the Quartz threadpool.
     *
     * @param s the full package/class name used for the threadpool
     */
    public void setClassName(String s)
    {
        this.className = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the full package/class name used for the threadpool
     */
    public String getClassName()
    {
        return this.className;
    }

    /**
     * This is the thread count used for the Quartz threadpool.
     *
     * @param s the thread count used for the Quartz threadpool.
     */
    public void setThreadCount(String s)
    {
        this.threadCount = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the thread count used for the Quartz threadpool.
     */
    public String getThreadCount()
    {
        return this.threadCount;
    }

    /**
     * This is the thread priority used for the Quartz threadpool.
     *
     * @param s the thread priority for the Quartz threadpool.
     */
    public void setThreadPriority(String s)
    {
        this.threadPriority = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the thread priority used for the Quartz threadpool.
     */
    public String getThreadPriority()
    {
        return this.threadPriority;
    }
}
