/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.createdBy;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.FeatureStructureSelection;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditorInputListener;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.explain.ExplainUtils;
import org.apache.uima.ruta.explain.createdBy.CreatedByContentProvider;
import org.apache.uima.ruta.explain.createdBy.CreatedByLabelProvider;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.resource.RutaResourceLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.springframework.core.io.Resource;

public class CreatedByViewPage
extends Page
implements ISelectionListener,
ICasEditorInputListener,
IDoubleClickListener {
    public static final String RUTA_RULE = "RutaRule";
    protected TreeViewer viewer;
    protected int current = 0;
    protected Map<String, Image> images;
    protected AnnotationEditor editor;
    protected ICasDocument document;

    public CreatedByViewPage(AnnotationEditor editor) {
        this.editor = editor;
        this.document = editor.getDocument();
    }

    private void initImages() {
        this.images = new HashMap<String, Image>();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/ruta_obj.png");
        Image image = desc.createImage();
        String name = RUTA_RULE;
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setLabelProvider((IBaseLabelProvider)new CreatedByLabelProvider(this));
        this.viewer.setContentProvider((IContentProvider)new CreatedByContentProvider());
        this.viewer.setInput(null);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.editor.addCasEditorInputListener((ICasEditorInputListener)this);
        this.viewer.refresh();
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof TreeSelection) {
            TreeSelection s = (TreeSelection)selection;
            FeatureStructure fs = (FeatureStructure)s.getFirstElement();
            Type t = fs.getType();
            Feature featureId = t.getFeatureByBaseName("id");
            Feature featureScript = t.getFeatureByBaseName("script");
            int id = fs.getIntValue(featureId);
            String script = fs.getStringValue(featureScript);
            IEditorInput editorInput = this.editor.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                FileEditorInput fei = (FileEditorInput)editorInput;
                IPath path = fei.getPath();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot workspaceRoot = workspace.getRoot();
                IFile iFile = workspaceRoot.getFileForLocation(path);
                IProject project = iFile.getProject();
                if (iFile != null) {
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    try {
                        List allScriptFolders = RutaProjectUtils.getAllScriptFolders((IScriptProject)scriptProject);
                        List folders = RutaProjectUtils.getFolderLocations((List)allScriptFolders);
                        RutaResourceLoader loader = new RutaResourceLoader(folders.toArray(new String[0]));
                        Resource resource = loader.getResourceWithDotNotation(script, ".ruta");
                        if (resource != null && resource.exists()) {
                            Path locatedPath = new Path(resource.getFile().getAbsolutePath());
                            ExplainUtils.openInRutaEditor((IPath)locatedPath, id);
                        } else {
                            RutaAddonsPlugin.error(new IllegalArgumentException("Not able to locate script: " + script));
                        }
                    }
                    catch (IOException | CoreException e) {
                        RutaAddonsPlugin.error(e);
                    }
                }
            }
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.editor.removeCasEditorInputListener((ICasEditorInputListener)this);
        if (this.images != null) {
            for (Image each : this.images.values()) {
                each.dispose();
            }
        }
        super.dispose();
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            FeatureStructureSelection fsSelection = new FeatureStructureSelection((IStructuredSelection)selection);
            if (fsSelection.isEmpty()) {
                return;
            }
            FeatureStructure featureStructure = (FeatureStructure)fsSelection.toList().get(0);
            if (featureStructure instanceof AnnotationFS) {
                CAS cas = this.document.getCAS();
                Type t = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugCreatedBy");
                Feature featureAnnotation = t.getFeatureByBaseName("annotation");
                FSIterator iterator = cas.getIndexRepository().getAllIndexedFS(t);
                while (iterator.hasNext()) {
                    FeatureStructure fs = iterator.next();
                    AnnotationFS afs = (AnnotationFS)fs.getFeatureValue(featureAnnotation);
                    if (afs == null || !afs.equals((Object)featureStructure)) continue;
                    this.viewer.setInput((Object)fs);
                    return;
                }
                this.viewer.setInput(null);
            }
        }
    }

    public void casDocumentChanged(IEditorInput oldInput, ICasDocument oldDocument, IEditorInput newInput, ICasDocument newDocument) {
    }
}

