/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrabalAnnotation
extends TextRulerAnnotation {
    private Map<String, String> features;
    private boolean enableFeatures;

    public TrabalAnnotation(AnnotationFS afs, boolean enableFeatures) {
        super(afs);
        if (afs.getType().getFeatures() != null) {
            this.features = new HashMap<String, String>();
            this.enableFeatures = enableFeatures;
            for (Feature f : afs.getType().getFeatures()) {
                try {
                    if (TrabalLearner.FILTERED_FEATURES.contains(f.getShortName())) continue;
                    this.features.put(f.getShortName(), afs.getFeatureValueAsString(f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public TrabalAnnotation(AnnotationFS afs, TextRulerExampleDocument document, boolean enableFeatures) {
        super(afs, document);
        if (afs.getType().getFeatures() != null) {
            this.features = new HashMap<String, String>();
            this.enableFeatures = enableFeatures;
            for (Feature f : afs.getType().getFeatures()) {
                try {
                    if (TrabalLearner.FILTERED_FEATURES.contains(f.getShortName())) continue;
                    this.features.put(f.getShortName(), afs.getFeatureValueAsString(f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Map<String, String> getFeatures() {
        return this.features;
    }

    @Override
    public String toString() {
        String result = this.getType().getShortName();
        result = result + "(" + this.getBegin() + ", " + this.getEnd() + ")";
        if (this.features != null) {
            result = result + "[";
            for (String key : this.features.keySet()) {
                result = result + key + ":" + this.features.get(key) + ", ";
            }
            result = result.substring(0, result.length() - 2);
            result = result + "]";
        }
        result = result + " \"" + this.getCoveredText() + "\"";
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass().isInstance(this)) {
            TrabalAnnotation obj = (TrabalAnnotation)o;
            return this.getBegin() == obj.getBegin() && this.getEnd() == obj.getEnd() && this.getType().getName().equals(obj.getType().getName()) && this.hasEqualFeatures(obj);
        }
        return false;
    }

    public boolean hasEqualFeatures(TrabalAnnotation obj) {
        if (this.enableFeatures) {
            if (this.features != null && obj.getFeatures() != null) {
                if (this.features.size() != obj.getFeatures().size()) {
                    return false;
                }
                for (String key : this.features.keySet()) {
                    if (!obj.getFeatures().containsKey(key)) {
                        return false;
                    }
                    if (this.features.get(key) == null || obj.getFeatures().get(key) == null || this.features.get(key).equals(obj.getFeatures().get(key))) continue;
                    return false;
                }
            } else if (this.features != null || obj.getFeatures() != null) {
                return false;
            }
        }
        return true;
    }
}

