/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.FactoryFinder;
import javax.xml.soap.Name;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public abstract class SOAPFactory {
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPFactory";
    private static final String DEFAULT_SF = "org.apache.axis2.saaj.SOAPFactoryImpl";

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract Detail createDetail() throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public static SOAPFactory newInstance() throws SOAPException {
        try {
            return (SOAPFactory)FactoryFinder.find(SF_PROPERTY, DEFAULT_SF);
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }

    public static SOAPFactory newInstance(String s) throws SOAPException {
        return SAAJMetaFactory.getInstance().newSOAPFactory(s);
    }

    public SOAPElement createElement(Element element) throws SOAPException {
        return null;
    }

    public SOAPElement createElement(QName qname) throws SOAPException {
        return null;
    }

    public abstract SOAPFault createFault() throws SOAPException;

    public abstract SOAPFault createFault(String var1, QName var2) throws SOAPException;
}

