.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Error XtApp-Set-Error-Handler XtApp-Set-Warning-Handler
.hw XtApp-Warning wid-get
.na
.TH XtAppError __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppError, XtAppSetErrorHandler, XtAppSetWarningHandler, XtAppWarning \- low-level error handlers
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtAppError(XtAppContext \fIapp_context\fP, const char *\fImessage\fP);
.HP
XtErrorHandler XtAppSetErrorHandler(XtAppContext \fIapp_context\fP, XtErrorHandler
\fIhandler\fP);
.HP
XtErrorHandler XtAppSetWarningHandler(XtAppContext \fIapp_context\fP, XtErrorHandler
\fIhandler\fP);
.HP
void XtAppWarning(XtAppContext \fIapp_context\fP, const char *\fImessage\fP);
.SH ARGUMENTS
.IP \fIapp_context\fP 1i
Specifies the application context.
.IP \fImessage\fP 1i
Specifies the nonfatal error message that is to be reported.
.IP \fIhandler\fP 1i
Specifies the new fatal error procedure, which should not return, 
or the nonfatal error procedure, which usually returns.
.IP \fImessage\fP 1i
Specifies the message that is to be reported.
.SH DESCRIPTION
The
.B XtAppError
function calls the installed error procedure and passes the specified message.
.LP
The
.B XtAppSetErrorHandler
function registers the specified procedure,
which is called when a fatal error condition occurs.
.LP
The
.B XtAppSetWarningHandler
registers the specified procedure,
which is called when a nonfatal error condition occurs.
.LP
The
.B XtAppWarning
function calls the installed nonfatal error procedure and passes the
specified message.
.SH "SEE ALSO"
XtAppGetErrorDatabase(__libmansuffix__),
XtAppErrorMsg(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
