# ==================================================================================================================== #
#             _____           _ _               ____           _            _             ____  ____                   #
#  _ __  _   |_   _|__   ___ | (_)_ __   __ _  / ___|__ _ _ __| |_ ___  ___(_) __ _ _ __ |___ \|  _ \                  #
# | '_ \| | | || |/ _ \ / _ \| | | '_ \ / _` || |   / _` | '__| __/ _ \/ __| |/ _` | '_ \  __) | | | |                 #
# | |_) | |_| || | (_) | (_) | | | | | | (_| || |__| (_| | |  | ||  __/\__ \ | (_| | | | |/ __/| |_| |                 #
# | .__/ \__, ||_|\___/ \___/|_|_|_| |_|\__, (_)____\__,_|_|   \__\___||___/_|\__,_|_| |_|_____|____/                  #
# |_|    |___/                          |___/                                                                          #
# ==================================================================================================================== #
# Authors:                                                                                                             #
#   Patrick Lehmann                                                                                                    #
#                                                                                                                      #
# License:                                                                                                             #
# ==================================================================================================================== #
# Copyright 2025-2026 Patrick Lehmann - Bötzingen, Germany                                                             #
#                                                                                                                      #
# Licensed under the Apache License, Version 2.0 (the "License");                                                      #
# you may not use this file except in compliance with the License.                                                     #
# You may obtain a copy of the License at                                                                              #
#                                                                                                                      #
#   http://www.apache.org/licenses/LICENSE-2.0                                                                         #
#                                                                                                                      #
# Unless required by applicable law or agreed to in writing, software                                                  #
# distributed under the License is distributed on an "AS IS" BASIS,                                                    #
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.                                             #
# See the License for the specific language governing permissions and                                                  #
# limitations under the License.                                                                                       #
#                                                                                                                      #
# SPDX-License-Identifier: Apache-2.0                                                                                  #
# ==================================================================================================================== #
#
"""
Unit tests for ...
"""
from unittest import TestCase

from pyTooling.Cartesian2D        import Point2D, LineSegment2D
from pyTooling.Cartesian2D.Shapes import Trapezium, Rectangle, Square


if __name__ == "__main__":  # pragma: no cover
	print("ERROR: you called a testcase declaration file as an executable module.")
	print("Use: 'python -m unittest <testcase module>'")
	exit(1)


class Instantiation(TestCase):
	def test_Trapezium(self) -> None:
		point00 = Point2D(1, 1)
		point01 = Point2D(3, 1)
		point11 = Point2D(3, 3)
		point10 = Point2D(1, 3)

		trapezium = Trapezium(point00, point01, point11, point10)

	def test_Trapezium_str1(self) -> None:
		point01 = Point2D(3, 1)
		point11 = Point2D(3, 3)
		point10 = Point2D(1, 3)

		with self.assertRaises(TypeError):
			_ = Trapezium("1, 1", point01, point11, point10)

	def test_Trapezium_str2(self) -> None:
		point00 = Point2D(1, 1)
		point11 = Point2D(3, 3)
		point10 = Point2D(1, 3)

		with self.assertRaises(TypeError):
			_ = Trapezium(point00, "3, 1", point11, point10)

	def test_Trapezium_str3(self) -> None:
		point00 = Point2D(1, 1)
		point01 = Point2D(3, 1)
		point10 = Point2D(1, 3)

		with self.assertRaises(TypeError):
			_ = Trapezium(point00, point01, "3, 3", point10)

	def test_Trapezium_str4(self) -> None:
		point00 = Point2D(1, 1)
		point01 = Point2D(3, 1)
		point11 = Point2D(3, 3)

		with self.assertRaises(TypeError):
			_ = Trapezium(point00, point01, point11, "1, 3")
