# repeat-string [![NPM version](https://badge.fury.io/js/repeat-string.svg)](http://badge.fury.io/js/repeat-string)

> Repeat the given string n times. Fastest implementation for repeating a string.

## Install with [npm](npmjs.org)

```bash
npm i repeat-string --save
```
### Install with [bower](https://github.com/bower/bower)

```bash
bower install repeat-string --save
```

## Usage

### [repeat](index.js#L34)

Repeat the given `string` the specified `number` of times.

* `string` **{String}**: The string to repeat    
* `number` **{Number}**: The number of times to repeat the string    
* `returns` **{String}**: Repeated string  

**Example:**

```js
var repeat = require('repeat-string');
repeat('A', 5);
//=> AAAAA
```



## Benchmarks

Repeat string is significantly faster than [repeating](https://github.com/sindresorhus/repeating).

```bash
# 20,000x
  repeat-string.js x 16,619,408 ops/sec ±1.05% (92 runs sampled)
  repeating.js x 5,991,724 ops/sec ±0.62% (98 runs sampled)

# 2,000x
  repeat-string.js x 17,284,768 ops/sec ±0.71% (94 runs sampled)
  repeating.js x 6,828,993 ops/sec ±0.87% (96 runs sampled)

# 250x
  repeat-string.js x 16,241,986 ops/sec ±0.78% (93 runs sampled)
  repeating.js x 7,281,492 ops/sec ±0.76% (95 runs sampled)

# 50x
  repeat-string.js x 16,447,301 ops/sec ±1.12% (96 runs sampled)
  repeating.js x 8,933,633 ops/sec ±0.64% (98 runs sampled)

# 5x
  repeat-string.js x 16,363,515 ops/sec ±1.09% (98 runs sampled)
  repeating.js x 12,164,964 ops/sec ±0.74% (98 runs sampled)
```

**Run the benchmarks**

Install dev dependencies:

```bash
npm i -d && node benchmark
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

### Other javascript/node.js utils

Other projects that I maintain:

  - [assemble](https://github.com/jonschlinkert/assemble)
  - [remarkable](https://github.com/jonschlinkert/remarkable)
  - [less.js](https://github.com/jonschlinkert/less.js)
  - [handlebars-helpers](https://github.com/jonschlinkert/handlebars-helpers)
  - [verb](https://github.com/jonschlinkert/verb)
  - [arr](https://github.com/jonschlinkert/arr)
  - [arr-diff](https://github.com/jonschlinkert/arr-diff)
  - [array-last](https://github.com/jonschlinkert/array-last)
  - [array-slice](https://github.com/jonschlinkert/array-slice)
  - [array-sum](https://github.com/jonschlinkert/array-sum)
  - [arrayify-compact](https://github.com/jonschlinkert/arrayify-compact)
  - [compact-object](https://github.com/jonschlinkert/compact-object)
  - [delete](https://github.com/jonschlinkert/delete)
  - [for-in](https://github.com/jonschlinkert/for-in)
  - [for-own](https://github.com/jonschlinkert/for-own)
  - [has-any](https://github.com/jonschlinkert/has-any)
  - [has-value](https://github.com/jonschlinkert/has-value)
  - [is-number](https://github.com/jonschlinkert/is-number)
  - [is-plain-object](https://github.com/jonschlinkert/is-plain-object)
  - [mixin-deep](https://github.com/jonschlinkert/mixin-deep)
  - [mixin-object](https://github.com/jonschlinkert/mixin-object)
  - [object-length](https://github.com/jonschlinkert/object-length)
  - [omit-empty](https://github.com/jonschlinkert/omit-empty)
  - [reduce-object](https://github.com/jonschlinkert/reduce-object)

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on January 24, 2015._