/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.stringsubstitution;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class SelectedResourceManager {
    private static final int MAX_UI_WAIT_TIME = 10;
    private static SelectedResourceManager fgDefault;
    private static ExecutorService executor;

    static {
        executor = Executors.newSingleThreadExecutor();
    }

    public static SelectedResourceManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectedResourceManager();
        }
        return fgDefault;
    }

    public IStructuredSelection getCurrentSelection() {
        IStructuredSelection selection = this.getFromUI(this::getCurrentSelection0);
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        return selection;
    }

    IStructuredSelection getCurrentSelection0() {
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                return new StructuredSelection((Object)part);
            }
            if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)provider.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    public IResource getSelectedResource() {
        IResource resource = this.getFromUI(this::getSelectedResource0);
        return resource;
    }

    protected IResource getSelectedResource0() {
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        IResource resource = null;
        if (window != null && (page = window.getActivePage()) != null) {
            IStructuredSelection ss;
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                IEditorPart epart = (IEditorPart)part;
                resource = (IResource)epart.getEditorInput().getAdapter(IResource.class);
            } else if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Iterator iterator = ss.iterator();
                while (iterator.hasNext() && resource == null) {
                    Object next = iterator.next();
                    resource = (IResource)Platform.getAdapterManager().getAdapter(next, IResource.class);
                }
            }
        }
        return resource;
    }

    public String getSelectedText() {
        String text = this.getFromUI(this::getSelectedText0);
        return text;
    }

    protected String getSelectedText0() {
        ISelection selection;
        ISelectionProvider sprovider;
        IEditorSite esite;
        IEditorPart epart;
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (epart = page.getActiveEditor()) != null && (esite = epart.getEditorSite()) != null && (sprovider = esite.getSelectionProvider()) != null && (selection = sprovider.getSelection()) instanceof ITextSelection) {
            return ((ITextSelection)selection).getText();
        }
        return null;
    }

    public IWorkbenchWindow getActiveWindow() {
        IWorkbenchWindow window = this.getFromUI(DebugUIPlugin::getActiveWorkbenchWindow);
        return window;
    }

    private <T> T getFromUI(Callable<T> call) {
        try {
            if (Display.getCurrent() != null) {
                return call.call();
            }
            return SelectedResourceManager.runInUIThreadWithTimeout(call, 10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            SelectedResourceManager.reportTimeout();
            return null;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
        catch (Exception e) {
            DebugUIPlugin.log(e);
            return null;
        }
    }

    static <V> V runInUIThreadWithTimeout(Callable<V> callable, long timeout, TimeUnit units) throws Exception {
        FutureTask<Object> task = new FutureTask<Object>(() -> SelectedResourceManager.syncExec(callable));
        executor.execute(task);
        return (V)task.get(timeout, units);
    }

    static <V> V syncExec(Callable<V> callable) throws Exception {
        AtomicReference ref = new AtomicReference();
        AtomicReference ex = new AtomicReference();
        DebugUIPlugin.getStandardDisplay().syncExec(() -> {
            try {
                ref.set(callable.call());
            }
            catch (Exception e) {
                ex.set(e);
            }
        });
        if (ex.get() != null) {
            throw (Exception)ex.get();
        }
        return ref.get();
    }

    private static void reportTimeout() {
        ThreadInfo[] threads;
        Thread nonUiThread = Thread.currentThread();
        String msg = "To avoid deadlock while executing Display.syncExec() from a non UI thread '" + nonUiThread.getName() + "', operation was cancelled.";
        MultiStatus main = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 4, msg, null);
        ThreadInfo[] threadInfoArray = threads = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{nonUiThread.threadId(), Display.getDefault().getThread().threadId()}, true, true);
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            Object childMsg = info.getThreadId() == nonUiThread.threadId() ? nonUiThread.getName() + " thread probably holding a lock and trying to acquire UI lock" : "UI thread waiting on a job or lock.";
            IllegalStateException childEx = new IllegalStateException("Call stack for thread " + info.getThreadName());
            childEx.setStackTrace(info.getStackTrace());
            main.add(DebugUIPlugin.newErrorStatus((String)childMsg, childEx));
            ++n2;
        }
        DebugUIPlugin.log((IStatus)main);
    }
}

