/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera;

import java.nio.FloatBuffer;
import java.util.logging.Logger;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.camera.AbstractCamera;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometryext.Ray;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.util.Draw3DCache;

public class FirstPersonCamera
extends AbstractCamera {
    private static Logger log = Logger.getLogger(FirstPersonCamera.class.getName());
    private Projection m_cachedProjection = new Projection();
    protected int m_far = 10000;
    protected int m_fov = 45;
    private boolean m_matricesValid = false;
    protected int m_near = 100;
    protected final Vector3fImpl m_position = new Vector3fImpl();
    private final Matrix4fImpl m_projectionMatrix = new Matrix4fImpl();
    protected final Vector3fImpl m_right = new Vector3fImpl();
    protected final Vector3fImpl m_up = new Vector3fImpl();
    protected final Vector3fImpl m_viewDir = new Vector3fImpl();
    private final Matrix4fImpl m_viewMatrix = new Matrix4fImpl();
    protected final Rectangle m_viewport = new Rectangle();

    public FirstPersonCamera() {
        this.reset();
    }

    private IMatrix4f calculateInversionMatrix(IMatrix4f i_modelMatrix, Matrix4f io_result) {
        this.calculateMatrix(i_modelMatrix, io_result);
        Math3D.invert((IMatrix4f)io_result, (Matrix4f)io_result);
        return io_result;
    }

    private IMatrix4f calculateMatrix(IMatrix4f i_modelMatrix, Matrix4f io_result) {
        Matrix4f matrix4f;
        Matrix4f tmp = Math3DCache.getMatrix4f();
        try {
            if (i_modelMatrix != null) {
                Math3D.mul((IMatrix4f)this.m_projectionMatrix, (IMatrix4f)i_modelMatrix, (Matrix4f)tmp);
            } else {
                tmp.set((IMatrix4f)this.m_projectionMatrix);
            }
            Math3D.mul((IMatrix4f)tmp, (IMatrix4f)this.m_viewMatrix, (Matrix4f)io_result);
            matrix4f = io_result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{tmp});
        return matrix4f;
    }

    protected void fireCameraChanged() {
        this.m_matricesValid = false;
        this.m_cachedProjection.invalidate();
        super.fireCameraChanged();
    }

    private float getAspect() {
        if (this.m_viewport.height == 0) {
            return 0.0f;
        }
        return (float)this.m_viewport.width / (float)this.m_viewport.height;
    }

    public float getDistance(IVector3f i_point) {
        float f;
        if (i_point == null) {
            throw new NullPointerException("i_point must not be null");
        }
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            Math3D.sub((IVector3f)i_point, (IVector3f)this.m_position, (Vector3f)tmp);
            f = tmp.length();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
        return f;
    }

    public float getNear() {
        return this.m_near;
    }

    public Vector3f getPosition(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_position);
        return result;
    }

    public Ray getRay(int i_xm, int i_ym, Ray io_result) {
        Ray ray;
        Ray result = io_result;
        if (result == null) {
            result = new Ray();
        }
        Vector3f direction = Math3DCache.getVector3f();
        try {
            this.unProject(i_xm, i_ym, 0.0f, null, direction);
            Math3D.sub((IVector3f)direction, (IVector3f)this.m_position, (Vector3f)direction);
            result.set((IVector3f)this.m_position, (IVector3f)direction);
            ray = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{direction});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{direction});
        return ray;
    }

    public Vector3f getRightVector(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_right);
        return result;
    }

    public Vector3f getUpVector(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_up);
        return result;
    }

    public Vector3f getViewDirection(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_viewDir);
        return result;
    }

    public void lookAt(IVector3f i_to, IVector3f i_upvector) {
        Math3D.sub((IVector3f)i_to, (IVector3f)this.m_position, (Vector3f)this.m_viewDir);
        Math3D.normalise((IVector3f)this.m_viewDir, (Vector3f)this.m_viewDir);
        if (i_upvector != null) {
            Math3D.normalise((IVector3f)i_upvector, (Vector3f)this.m_up);
        }
        Math3D.cross((IVector3f)this.m_up, (IVector3f)this.m_viewDir, (Vector3f)this.m_right);
        this.fireCameraChanged();
    }

    public void moveBy(float i_dForward, float i_dStrafe, float i_dUp) {
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            tmp.set((IVector3f)this.m_viewDir);
            tmp.scale(i_dForward);
            Math3D.add((IVector3f)this.m_position, (IVector3f)tmp, (Vector3f)this.m_position);
            tmp.set((IVector3f)this.m_right);
            tmp.scale(i_dStrafe);
            Math3D.add((IVector3f)this.m_position, (IVector3f)tmp, (Vector3f)this.m_position);
            tmp.set((IVector3f)this.m_up);
            tmp.scale(i_dUp);
            Math3D.add((IVector3f)this.m_position, (IVector3f)tmp, (Vector3f)this.m_position);
            this.fireCameraChanged();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
    }

    public void moveTo(float i_x, float i_y, float i_z) {
        this.m_position.set(i_x, i_y, i_z);
        this.fireCameraChanged();
    }

    public void moveTo(IVector3f i_viewPoint) {
        if (i_viewPoint == null) {
            throw new NullPointerException("i_viewPoint must not be null");
        }
        this.moveTo(i_viewPoint.getX(), i_viewPoint.getY(), i_viewPoint.getZ());
    }

    public void orbit(IVector3f i_center, float i_hAngle, float i_vAngle) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            rot.setIdentity();
            if (i_hAngle != 0.0f) {
                Math3D.rotate((float)i_hAngle, (IVector3f)this.m_up, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_vAngle != 0.0f) {
                Math3D.rotate((float)i_vAngle, (IVector3f)this.m_right, (IMatrix4f)rot, (Matrix4f)rot);
            }
            Math3D.sub((IVector3f)this.m_position, (IVector3f)i_center, (Vector3f)tmp);
            tmp.transform((IMatrix4f)rot);
            Math3D.add((IVector3f)tmp, (IVector3f)i_center, (Vector3f)this.m_position);
            this.m_viewDir.transform((IMatrix4f)rot);
            this.m_right.transform((IMatrix4f)rot);
            this.m_up.transform((IMatrix4f)rot);
            this.fireCameraChanged();
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
    }

    public Point project(float i_wx, float i_wy, float i_wz, Point io_result) {
        Point point;
        if (this.m_cachedProjection.hasMouseLocation(i_wx, i_wy, i_wz, null)) {
            return this.m_cachedProjection.getMouseLocation(io_result);
        }
        Point result = io_result;
        if (result == null) {
            result = new Point();
        }
        Matrix4f transformation = Math3DCache.getMatrix4f();
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            this.calculateMatrix(null, transformation);
            tmp.set(i_wx, i_wy, i_wz);
            tmp.transform((IMatrix4f)transformation);
            result.x = Math.round((tmp.getX() + 1.0f) * (float)this.m_viewport.width / 2.0f);
            result.y = Math.round((-1.0f * tmp.getY() + 1.0f) * (float)this.m_viewport.height / 2.0f);
            float depth = (tmp.getZ() + 1.0f) / 2.0f;
            this.m_cachedProjection.update(i_wx, i_wy, i_wz, result.x, result.y, depth, null);
            point = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{transformation});
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{transformation});
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
        return point;
    }

    public Point project(IVector3f i_wLocation, Point io_result) {
        return this.project(i_wLocation.getX(), i_wLocation.getY(), i_wLocation.getZ(), io_result);
    }

    public void render(RenderContext renderContext) {
        Graphics3D g3d = renderContext.getGraphics3D();
        g3d.glViewport(0, 0, this.m_viewport.width, this.m_viewport.height);
        g3d.glMatrixMode(5889);
        g3d.glLoadIdentity();
        g3d.gluPerspective(this.m_fov, this.getAspect(), this.m_near, this.m_far);
        g3d.glMatrixMode(5888);
        g3d.glLoadIdentity();
        float viewX = this.m_position.x + this.m_viewDir.x;
        float viewY = this.m_position.y + this.m_viewDir.y;
        float viewZ = this.m_position.z + this.m_viewDir.z;
        g3d.gluLookAt(this.m_position.x, this.m_position.y, this.m_position.z, viewX, viewY, viewZ, this.m_up.x, this.m_up.y, this.m_up.z);
        if (!this.m_matricesValid) {
            FloatBuffer buffer = Draw3DCache.getFloatBuffer(16);
            try {
                buffer.rewind();
                g3d.glGetFloat(2983, buffer);
                this.m_projectionMatrix.setColumnMajor(buffer);
                Math3D.transpose((IMatrix4f)this.m_projectionMatrix, (Matrix4f)this.m_projectionMatrix);
                buffer.rewind();
                g3d.glGetFloat(2982, buffer);
                this.m_viewMatrix.setColumnMajor(buffer);
                Math3D.transpose((IMatrix4f)this.m_viewMatrix, (Matrix4f)this.m_viewMatrix);
                this.m_matricesValid = true;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnFloatBuffer(buffer);
                throw throwable;
            }
            Draw3DCache.returnFloatBuffer(buffer);
        }
    }

    public void reset() {
        this.m_position.set(0.0f, 0.0f, -1000.0f);
        this.m_viewDir.set(VIEW_REF);
        this.m_right.set(RIGHT_REF);
        this.m_up.set(UP_REF);
        this.fireCameraChanged();
    }

    public void rotate(float i_roll, float i_pitch, float i_yaw) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        try {
            rot.setIdentity();
            if (i_roll != 0.0f) {
                Math3D.rotate((float)i_roll, (IVector3f)this.m_viewDir, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_pitch != 0.0f) {
                Math3D.rotate((float)i_pitch, (IVector3f)this.m_right, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_yaw != 0.0f) {
                Math3D.rotate((float)i_yaw, (IVector3f)this.m_up, (IMatrix4f)rot, (Matrix4f)rot);
            }
            this.m_viewDir.transform((IMatrix4f)rot);
            this.m_right.transform((IMatrix4f)rot);
            this.m_up.transform((IMatrix4f)rot);
            this.fireCameraChanged();
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
    }

    public void setViewport(int i_x, int i_y, int i_width, int i_height) {
        this.m_viewport.setLocation(i_x, i_y);
        this.m_viewport.setSize(i_width, i_height);
        this.fireCameraChanged();
    }

    public Vector3f unProject(int i_mx, int i_my, float i_depth, IMatrix4f i_modelMatrix, Vector3f io_result) {
        Vector3f vector3f;
        if (this.m_cachedProjection.hasWorldLocation(i_mx, i_my, i_depth, i_modelMatrix)) {
            return this.m_cachedProjection.getWorldLocation(io_result);
        }
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Matrix4f inversion = Math3DCache.getMatrix4f();
        try {
            result.setX((float)(2 * i_mx) / (float)this.m_viewport.width - 1.0f);
            result.setY((float)(2 * (this.m_viewport.height - i_my)) / (float)this.m_viewport.height - 1.0f);
            result.setZ(2.0f * i_depth - 1.0f);
            this.calculateInversionMatrix(i_modelMatrix, inversion);
            result.transform((IMatrix4f)inversion);
            this.m_cachedProjection.update(result.getX(), result.getY(), result.getZ(), i_mx, i_my, i_depth, i_modelMatrix);
            vector3f = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{inversion});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{inversion});
        return vector3f;
    }

    private static class Projection {
        private float m_depth;
        private Point m_mLocation = new Point();
        private Matrix4f m_modelMatrix = new Matrix4fImpl();
        private boolean m_valid = false;
        private Vector3f m_wLocation = new Vector3fImpl();

        private Projection() {
        }

        public Point getMouseLocation(Point io_result) {
            Point result = io_result;
            if (result == null) {
                result = new Point();
            }
            result.setLocation(this.m_mLocation);
            return result;
        }

        public Vector3f getWorldLocation(Vector3f io_result) {
            Vector3f result = io_result;
            if (result == null) {
                result = new Vector3fImpl();
            }
            result.set((IVector3f)this.m_wLocation);
            return result;
        }

        public boolean hasMouseLocation(float i_wx, float i_wy, float i_wz, IMatrix4f i_modelMatrix) {
            if (!this.m_valid) {
                return false;
            }
            if (i_wx != this.m_wLocation.getX() || i_wy != this.m_wLocation.getY() || i_wz != this.m_wLocation.getY()) {
                return false;
            }
            return !(i_modelMatrix == null ? !this.m_modelMatrix.equals(IMatrix4f.IDENTITY) : !i_modelMatrix.equals((IMatrix4f)this.m_modelMatrix));
        }

        public boolean hasWorldLocation(int i_mx, int i_my, float i_depth, IMatrix4f i_modelMatrix) {
            if (!this.m_valid) {
                return false;
            }
            if (i_mx != this.m_mLocation.x || i_my != this.m_mLocation.y || i_depth != this.m_depth) {
                return false;
            }
            return !(i_modelMatrix == null ? !this.m_modelMatrix.equals(IMatrix4f.IDENTITY) : !i_modelMatrix.equals((IMatrix4f)this.m_modelMatrix));
        }

        public void invalidate() {
            this.m_valid = false;
        }

        public void update(float i_wx, float i_wy, float i_wz, int i_mx, int i_my, float i_depth, IMatrix4f i_modelMatrix) {
            this.m_wLocation.set(i_wx, i_wy, i_wz);
            this.m_mLocation.x = i_mx;
            this.m_mLocation.y = i_my;
            this.m_depth = i_depth;
            if (i_modelMatrix == null) {
                this.m_modelMatrix.setIdentity();
            } else {
                this.m_modelMatrix.set(i_modelMatrix);
            }
            this.m_valid = true;
        }
    }
}

