/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcSun14HttpTransport;

public class XmlRpcSun15HttpTransport
extends XmlRpcSun14HttpTransport {
    private Proxy proxy;

    public XmlRpcSun15HttpTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    public void setProxy(Proxy pProxy) {
        this.proxy = pProxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
        int replyTimeout;
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        int connectionTimeout = config.getConnectionTimeout();
        if (connectionTimeout > 0) {
            this.getURLConnection().setConnectTimeout(connectionTimeout);
        }
        if ((replyTimeout = config.getReplyTimeout()) > 0) {
            this.getURLConnection().setReadTimeout(replyTimeout);
        }
        super.initHttpHeaders(pRequest);
    }

    @Override
    protected URLConnection newURLConnection(URL pURL) throws IOException {
        Proxy prox = this.getProxy();
        URLConnection conn = prox == null ? pURL.openConnection() : pURL.openConnection(prox);
        SSLSocketFactory sslSockFactory = this.getSSLSocketFactory();
        if (sslSockFactory != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSockFactory);
        }
        return conn;
    }
}

