/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlrpc.common.ServerStreamConnection;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;

public class LocalStreamConnection {
    private final InputStream request;
    private final XmlRpcStreamRequestConfig config;
    private final ByteArrayOutputStream response = new ByteArrayOutputStream();
    private final ServerStreamConnection serverStreamConnection;

    public LocalStreamConnection(XmlRpcStreamRequestConfig pConfig, InputStream pRequest) {
        this.config = pConfig;
        this.request = pRequest;
        this.serverStreamConnection = new LocalServerStreamConnection();
    }

    public InputStream getRequest() {
        return this.request;
    }

    public XmlRpcStreamRequestConfig getConfig() {
        return this.config;
    }

    public ByteArrayOutputStream getResponse() {
        return this.response;
    }

    public ServerStreamConnection getServerStreamConnection() {
        return this.serverStreamConnection;
    }

    private class LocalServerStreamConnection
    implements ServerStreamConnection {
        private LocalServerStreamConnection() {
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return LocalStreamConnection.this.request;
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return LocalStreamConnection.this.response;
        }

        @Override
        public void close() throws IOException {
            if (LocalStreamConnection.this.response != null) {
                LocalStreamConnection.this.response.close();
            }
        }
    }
}

