/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.ws.commons.util.Base64;
import org.apache.xmlrpc.parser.TypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ByteArrayParser
extends TypeParserImpl {
    private int level;
    private ByteArrayOutputStream baos;
    private Base64.Decoder decoder;

    @Override
    public void startDocument() throws SAXException {
        this.level = 0;
    }

    @Override
    public void characters(char[] pChars, int pStart, int pLength) throws SAXException {
        if (this.baos == null) {
            if (!ByteArrayParser.isEmpty(pChars, pStart, pLength)) {
                throw new SAXParseException("Unexpected non-whitespace characters", this.getDocumentLocator());
            }
        } else {
            try {
                this.decoder.write(pChars, pStart, pLength);
            }
            catch (IOException e) {
                throw new SAXParseException("Failed to decode base64 stream.", this.getDocumentLocator(), e);
            }
        }
    }

    @Override
    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        if (--this.level == 0) {
            try {
                this.decoder.flush();
            }
            catch (IOException e) {
                throw new SAXParseException("Failed to decode base64 stream.", this.getDocumentLocator(), e);
            }
        } else {
            throw new SAXParseException("Unexpected end tag in atomic element: " + new QName(pURI, pLocalName), this.getDocumentLocator());
        }
        this.setResult(this.baos.toByteArray());
    }

    @Override
    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        if (this.level++ != 0) {
            throw new SAXParseException("Unexpected start tag in atomic element: " + new QName(pURI, pLocalName), this.getDocumentLocator());
        }
        this.baos = new ByteArrayOutputStream();
        this.decoder = new Base64.Decoder(1024){

            protected void writeBuffer(byte[] pBytes, int pOffset, int pLen) throws IOException {
                ByteArrayParser.this.baos.write(pBytes, pOffset, pLen);
            }
        };
    }
}

