/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import javax.xml.namespace.QName;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcExtensionException;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.parser.TypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class RecursiveTypeParserImpl
extends TypeParserImpl {
    private final NamespaceContextImpl context;
    protected final XmlRpcStreamConfig cfg;
    private final TypeFactory factory;
    private boolean inValueTag;
    private TypeParser typeParser;
    private StringBuffer text = new StringBuffer();

    protected RecursiveTypeParserImpl(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, TypeFactory pFactory) {
        this.cfg = pConfig;
        this.context = pContext;
        this.factory = pFactory;
    }

    protected void startValueTag() throws SAXException {
        this.inValueTag = true;
        this.text.setLength(0);
        this.typeParser = null;
    }

    protected abstract void addResult(Object var1) throws SAXException;

    protected void endValueTag() throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                this.addResult(this.text.toString());
                this.text.setLength(0);
            } else {
                this.typeParser.endDocument();
                try {
                    this.addResult(this.typeParser.getResult());
                }
                catch (XmlRpcException e) {
                    throw new SAXException(e);
                }
                this.typeParser = null;
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.inValueTag = false;
        this.text.setLength(0);
        this.typeParser = null;
    }

    @Override
    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                throw new SAXParseException("Invalid state: No type parser configured.", this.getDocumentLocator());
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
        this.typeParser.endElement(pURI, pLocalName, pQName);
    }

    @Override
    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                this.typeParser = this.factory.getParser(this.cfg, this.context, pURI, pLocalName);
                if (this.typeParser == null) {
                    if ("http://ws.apache.org/xmlrpc/namespaces/extensions".equals(pURI) && !this.cfg.isEnabledForExtensions()) {
                        String msg = "The tag " + new QName(pURI, pLocalName) + " is invalid, if isEnabledForExtensions() == false.";
                        throw new SAXParseException(msg, this.getDocumentLocator(), new XmlRpcExtensionException(msg));
                    }
                    throw new SAXParseException("Unknown type: " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.typeParser.setDocumentLocator(this.getDocumentLocator());
                this.typeParser.startDocument();
                if (this.text.length() > 0) {
                    this.typeParser.characters(this.text.toString().toCharArray(), 0, this.text.length());
                    this.text.setLength(0);
                }
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
        this.typeParser.startElement(pURI, pLocalName, pQName, pAttrs);
    }

    @Override
    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.typeParser == null) {
            if (this.inValueTag) {
                this.text.append(pChars, pOffset, pLength);
            } else {
                super.characters(pChars, pOffset, pLength);
            }
        } else {
            this.typeParser.characters(pChars, pOffset, pLength);
        }
    }

    @Override
    public void ignorableWhitespace(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.typeParser == null) {
            if (this.inValueTag) {
                this.text.append(pChars, pOffset, pLength);
            } else {
                super.ignorableWhitespace(pChars, pOffset, pLength);
            }
        } else {
            this.typeParser.ignorableWhitespace(pChars, pOffset, pLength);
        }
    }

    @Override
    public void processingInstruction(String pTarget, String pData) throws SAXException {
        if (this.typeParser == null) {
            super.processingInstruction(pTarget, pData);
        } else {
            this.typeParser.processingInstruction(pTarget, pData);
        }
    }

    @Override
    public void skippedEntity(String pEntity) throws SAXException {
        if (this.typeParser == null) {
            super.skippedEntity(pEntity);
        } else {
            this.typeParser.skippedEntity(pEntity);
        }
    }

    @Override
    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        if (this.typeParser == null) {
            super.startPrefixMapping(pPrefix, pURI);
        } else {
            this.context.startPrefixMapping(pPrefix, pURI);
        }
    }

    @Override
    public void endPrefixMapping(String pPrefix) throws SAXException {
        if (this.typeParser == null) {
            super.endPrefixMapping(pPrefix);
        } else {
            this.context.endPrefixMapping(pPrefix);
        }
    }
}

