/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.CompositeNotificationEffect;
import org.eclipse.apogy.addons.monitoring.EnumBasedNotificationEffect;
import org.eclipse.apogy.addons.monitoring.NotificationEffect;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeNotificationEffectEffectsComposite
extends EMFFormsEListComposite<CompositeNotificationEffect, CompositeNotificationEffect, NotificationEffect> {
    private static final Logger Logger = LoggerFactory.getLogger(CompositeNotificationEffectEffectsComposite.class);
    private ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    private Adapter apogyNotifierAdapter;
    private Adapter effectAdapter;
    protected EEnumLiteral activeLiteral;

    public CompositeNotificationEffectEffectsComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.COMPOSITE_NOTIFICATION_EFFECT__EFFECTS, settings);
    }

    public void setActiveEEnumLiteral(EEnumLiteral literal) {
        this.activeLiteral = literal;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CompositeNotificationEffectEffectsComposite.this.isDisposed()) {
                    CompositeNotificationEffectEffectsComposite.this.getViewer().refresh();
                }
            }
        });
    }

    public void setRootEObject(CompositeNotificationEffect rootEObject) {
        CompositeNotificationEffect oldCompositeNotificationEffect = (CompositeNotificationEffect)this.getRootEObject();
        super.setRootEObject((EObject)rootEObject);
        if (oldCompositeNotificationEffect != null) {
            oldCompositeNotificationEffect.eAdapters().remove((Object)this.getApogyNotifierAdapter());
            for (NotificationEffect effect : oldCompositeNotificationEffect.getEffects()) {
                effect.eAdapters().remove((Object)this.getEffectAdapter());
            }
        }
        if (rootEObject != null) {
            rootEObject.eAdapters().add((Object)this.getApogyNotifierAdapter());
            for (NotificationEffect effect : rootEObject.getEffects()) {
                effect.eAdapters().add((Object)this.getEffectAdapter());
            }
        }
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return ApogyAddonsMonitoringPackage.Literals.COMPOSITE_NOTIFICATION_EFFECT__EFFECTS;
            }

            public Object[] getElements(Object object) {
                EnumBasedNotificationEffect effect;
                List effects;
                if (object instanceof EnumBasedNotificationEffect && (effects = (List)(effect = (EnumBasedNotificationEffect)object).getLiteralToEffectsMap().get((Object)CompositeNotificationEffectEffectsComposite.this.activeLiteral)) != null) {
                    return effects.toArray();
                }
                return new Object[0];
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        Button enableButton = this.createActivateButton(parent, style);
        enableButton.setText("Enable");
        Button disableButton = this.createDeActivateButton(parent, style);
        disableButton.setText("Disable");
    }

    protected Button createDeActivateButton(Composite parent, int style) {
        Button btnDeActivate = CompositeNotificationEffectEffectsComposite.createButton((Composite)parent, (int)0, (String)"De-Activate", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doDeActivate(this.getViewer().getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createDeActivateButtonBindings(btnDeActivate);
        return btnDeActivate;
    }

    protected void createDeActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doActivate(List<NotificationEffect> list) {
        for (NotificationEffect effect : list) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)effect, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.NOTIFICATION_EFFECT__ENABLED, (Object)true, true);
            }
            catch (Exception e) {
                Logger.error("Failed to enable Effect <" + effect + ">!", (Throwable)e);
            }
        }
    }

    protected void doDeActivate(List<NotificationEffect> list) {
        for (NotificationEffect effect : list) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)effect, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.NOTIFICATION_EFFECT__ENABLED, (Object)false, true);
            }
            catch (Exception e) {
                Logger.error("Failed to disable Effect <" + effect + ">!", (Throwable)e);
            }
        }
    }

    protected void doNew() {
        CompositeNotificationEffect compositeNotificationEffect = (CompositeNotificationEffect)this.getRootEObject();
        AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
        settings.setName("Allo");
        settings.getUserDataMap().put("ApogyNotifier", compositeNotificationEffect.eContainer());
        EObjectWizard wizard = new EObjectWizard((EObject)compositeNotificationEffect, null, ApogyAddonsMonitoringPackage.Literals.COMPOSITE_NOTIFICATION_EFFECT__EFFECTS, ApogyAddonsMonitoringPackage.Literals.NOTIFICATION_EFFECT, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.getCreatedEObject() instanceof NotificationEffect) {
            NotificationEffect effect = (NotificationEffect)wizard.getCreatedEObject();
            effect.initialise();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)effect, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.NOTIFICATION_EFFECT__ENABLED, (Object)true, true);
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)effect), true);
        }
        this.refreshViewer();
    }

    protected void doDelete(NotificationEffect effect) {
        try {
            effect.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.doDelete((Object)effect);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Effect");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NotificationEffect) {
                    NotificationEffect effect = (NotificationEffect)element;
                    return CompositeNotificationEffectEffectsComposite.this.labelProvider.getText((Object)effect);
                }
                return "?";
            }

            public Image getImage(Object element) {
                if (element instanceof NotificationEffect) {
                    NotificationEffect effect = (NotificationEffect)element;
                    return CompositeNotificationEffectEffectsComposite.this.labelProvider.getImage((Object)effect);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof NotificationEffect) {
                    NotificationEffect effect = (NotificationEffect)element;
                    return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)effect.eClass());
                }
                return "";
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)300);
        TreeViewerColumn enableColumn = new TreeViewerColumn(viewer, 0);
        enableColumn.getColumn().setText("Enabled");
        enableColumn.getColumn().setAlignment(0x1000000);
        enableColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NotificationEffect) {
                    NotificationEffect notifier = (NotificationEffect)element;
                    return Boolean.toString(notifier.isEnabled());
                }
                return "?";
            }
        });
        enableColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)75);
    }

    private Adapter getApogyNotifierAdapter() {
        if (this.apogyNotifierAdapter == null) {
            this.apogyNotifierAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ApogyNotifier && (featureID = msg.getFeatureID(ApogyNotifier.class)) == 1) {
                        switch (msg.getEventType()) {
                            case 3: {
                                NotificationEffect notifier = (NotificationEffect)msg.getNewValue();
                                notifier.eAdapters().add((Object)CompositeNotificationEffectEffectsComposite.this.getEffectAdapter());
                                break;
                            }
                            case 5: {
                                List notifiers = (List)msg.getNewValue();
                                for (NotificationEffect notifier : notifiers) {
                                    notifier.eAdapters().add((Object)CompositeNotificationEffectEffectsComposite.this.getEffectAdapter());
                                }
                                break;
                            }
                            case 4: {
                                NotificationEffect notifier = (NotificationEffect)msg.getOldValue();
                                notifier.eAdapters().remove((Object)CompositeNotificationEffectEffectsComposite.this.getEffectAdapter());
                                break;
                            }
                            case 6: {
                                List notifiers = (List)msg.getOldValue();
                                for (NotificationEffect notifier : notifiers) {
                                    notifier.eAdapters().remove((Object)CompositeNotificationEffectEffectsComposite.this.getEffectAdapter());
                                }
                                break;
                            }
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!CompositeNotificationEffectEffectsComposite.this.isDisposed()) {
                                    CompositeNotificationEffectEffectsComposite.this.getViewer().refresh();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.apogyNotifierAdapter;
    }

    private Adapter getEffectAdapter() {
        if (this.effectAdapter == null) {
            this.effectAdapter = new EContentAdapter(){

                public void notifyChanged(final Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof NotificationEffect) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!CompositeNotificationEffectEffectsComposite.this.isDisposed()) {
                                    CompositeNotificationEffectEffectsComposite.this.getViewer().refresh(msg.getNotifier(), true);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.effectAdapter;
    }
}

