/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.wizards;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.CSVLoggingNotificationEffect;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractWizardPage;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CSVLoggingNotificationEffectFileURLWizardPage
extends AbstractWizardPage<CSVLoggingNotificationEffect, CSVLoggingNotificationEffect, CSVLoggingNotificationEffect> {
    public static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.monitoring.ui.wizards.CSVLoggingNotificationEffectFileURLWizardPage";
    private String urlString = null;
    private Text urlText;

    public CSVLoggingNotificationEffectFileURLWizardPage(String id, CSVLoggingNotificationEffect rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id, (EObject)rootEObject, featurePath, eStructuralFeature);
    }

    public CSVLoggingNotificationEffectFileURLWizardPage(CSVLoggingNotificationEffect rootEObject) {
        super(WIZARD_PAGE_ID, (EObject)rootEObject, null, null);
    }

    public void createControl(Composite parent) {
        final Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        this.urlText = new Text(top, 2112);
        GridData gd_txtUrltext = new GridData(4, 4, true, false, 1, 1);
        gd_txtUrltext.heightHint = 50;
        gd_txtUrltext.minimumHeight = 50;
        this.urlText.setLayoutData((Object)gd_txtUrltext);
        this.urlText.setText(((CSVLoggingNotificationEffect)this.getRootEObject()).getFileURL());
        Button btnSelect = new Button(top, 8);
        btnSelect.setText("Select...");
        btnSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String currentDir = System.getProperty("user.dir");
                FileDialog fileChooser = new FileDialog(top.getShell(), 8192);
                fileChooser.setText("Select a file:");
                fileChooser.setFilterPath(currentDir);
                String[] extensions = new String[]{"*.csv"};
                fileChooser.setFilterExtensions(extensions);
                String filename = fileChooser.open();
                if (filename != null) {
                    try {
                        String newURLString = CSVLoggingNotificationEffectFileURLWizardPage.this.convertFilenameToURL(filename);
                        CSVLoggingNotificationEffectFileURLWizardPage.this.setUrlString(newURLString);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet(CSVLoggingNotificationEffectFileURLWizardPage.this.getRootEObject(), (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.CSV_LOGGING_NOTIFICATION_EFFECT__FILE_URL, (Object)newURLString);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setControl((Control)top);
    }

    protected void validate() {
        boolean urlValid;
        this.setErrorMessage(null);
        boolean bl = urlValid = this.urlString != null && this.urlString.length() > 0;
        if (!urlValid) {
            this.setErrorMessage("Invalid URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public void setUrlString(String newURLString) {
        this.urlString = newURLString;
        this.urlText.setText(newURLString);
    }

    private String convertFilenameToURL(String filename) throws Exception {
        File tmpFile = new File(filename);
        URL url = tmpFile.toURI().toURL();
        return url.toString();
    }
}

