/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFactory;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.NotifierList;
import org.eclipse.apogy.addons.monitoring.ValueSourceList;
import org.eclipse.apogy.addons.monitoring.impl.ApogyAddonsMonitoringFacadeImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyAddonsMonitoringFacadeCustomImpl
extends ApogyAddonsMonitoringFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyAddonsMonitoringFacadeCustomImpl.class);
    private Adapter activeSessionAdapter = null;

    public ApogyAddonsMonitoringFacadeCustomImpl() {
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getActiveSessionAdapter());
    }

    @Override
    public NotifierList getNotifierList() {
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null) {
            NotifierList notifierList = this.getAlarmNotifierList(invocatorSession);
            if (notifierList == null) {
                notifierList = ApogyAddonsMonitoringFactory.eINSTANCE.createNotifierList();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)notifierList);
            }
            return notifierList;
        }
        return null;
    }

    @Override
    public boolean removeFromList(NotifierList notificationList, ApogyNotifier notifier) {
        if (notificationList.getNotifiers().contains((Object)notifier)) {
            notifier.dispose();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)notificationList, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.NOTIFIER_LIST__NOTIFIERS, (Object)notifier, true);
            return true;
        }
        return false;
    }

    @Override
    public ValueSourceList getValueSourceList() {
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null) {
            ValueSourceList valueSourceList = this.getValueSourceList(invocatorSession);
            if (valueSourceList == null) {
                valueSourceList = ApogyAddonsMonitoringFactory.eINSTANCE.createValueSourceList();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)valueSourceList);
            }
            return valueSourceList;
        }
        return null;
    }

    private ValueSourceList getValueSourceList(InvocatorSession invocatorSession) {
        if (invocatorSession != null && invocatorSession.getToolsList() != null) {
            for (AbstractToolsListContainer atlc : invocatorSession.getToolsList().getToolsListContainers()) {
                if (!(atlc instanceof ValueSourceList)) continue;
                return (ValueSourceList)atlc;
            }
        }
        return null;
    }

    private NotifierList getAlarmNotifierList(InvocatorSession invocatorSession) {
        if (invocatorSession != null && invocatorSession.getToolsList() != null) {
            for (AbstractToolsListContainer atlc : invocatorSession.getToolsList().getToolsListContainers()) {
                if (!(atlc instanceof NotifierList)) continue;
                return (NotifierList)atlc;
            }
        }
        return null;
    }

    private void initializeApogyNotifiers(InvocatorSession invocatorSession) {
        NotifierList alarmList = this.getAlarmNotifierList(invocatorSession);
        if (alarmList != null) {
            for (ApogyNotifier notifier : alarmList.getNotifiers()) {
                if (!notifier.isEnabled()) continue;
                try {
                    notifier.initialise();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void disposeOfApogyNotifiers(InvocatorSession invocatorSession) {
        NotifierList alarmList = this.getAlarmNotifierList(invocatorSession);
        if (alarmList != null) {
            for (ApogyNotifier notifier : alarmList.getNotifiers()) {
                try {
                    notifier.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Adapter getActiveSessionAdapter() {
        if (this.activeSessionAdapter == null) {
            this.activeSessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreInvocatorFacade.class);
                        switch (featureID) {
                            case 2: {
                                Logger.info("Active Session changed, initialising...");
                                if (msg.getOldValue() instanceof InvocatorSession) {
                                    InvocatorSession oldInvocatorSession = (InvocatorSession)msg.getOldValue();
                                    ApogyAddonsMonitoringFacadeCustomImpl.this.disposeOfApogyNotifiers(oldInvocatorSession);
                                    ValueSourceList previousValueSourceList = ApogyAddonsMonitoringFacadeCustomImpl.this.getValueSourceList(oldInvocatorSession);
                                    if (previousValueSourceList != null) {
                                        previousValueSourceList.dispose();
                                    }
                                }
                                if (!(msg.getNewValue() instanceof InvocatorSession)) break;
                                InvocatorSession newInvocatorSession = (InvocatorSession)msg.getNewValue();
                                ApogyAddonsMonitoringFacadeCustomImpl.this.initializeApogyNotifiers(newInvocatorSession);
                                ValueSourceList newValueSourceList = ApogyAddonsMonitoringFacadeCustomImpl.this.getValueSourceList(newInvocatorSession);
                                if (newValueSourceList == null) break;
                                newValueSourceList.initialise();
                                break;
                            }
                            case 3: {
                                Logger.info("Active Context changed, updating...");
                                ApogyAddonsMonitoringFacadeCustomImpl.this.updateActiveContext((Context)msg.getOldValue(), (Context)msg.getNewValue());
                            }
                        }
                    }
                }
            };
        }
        return this.activeSessionAdapter;
    }

    private void updateActiveContext(Context oldContext, Context newContext) {
        ValueSourceList newValueSourceList = this.getValueSourceList(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession());
        if (newValueSourceList != null) {
            newValueSourceList.initialise();
        }
    }
}

