/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.util.Collection;
import java.util.Set;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.NotificationEffect;
import org.eclipse.apogy.addons.monitoring.impl.EnumBasedNotificationEffectImpl;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumBasedNotificationEffectCustomImpl
extends EnumBasedNotificationEffectImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EnumBasedNotificationEffectCustomImpl.class);

    @Override
    public void initialise() {
        for (NotificationEffect effect : this.getEffects()) {
            try {
                effect.initialise();
            }
            catch (Exception e) {
                Logger.error("Sub-effect failed to initialise!", (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        for (NotificationEffect effect : this.getEffects()) {
            try {
                effect.dispose();
            }
            catch (Exception e) {
                Logger.error("Sub-effect failed to dispose!", (Throwable)e);
            }
        }
    }

    @Override
    public void activate(ApogyNotifier notifier, Object newValue) {
        if (newValue instanceof Enumerator) {
            Enumerator enumerator = (Enumerator)newValue;
            Set literals = this.getLiteralToEffectsMap().keySet();
            for (EEnumLiteral literal : literals) {
                Collection effects = (Collection)this.getLiteralToEffectsMap().get((Object)literal);
                if (literal.getValue() == enumerator.getValue()) {
                    this.activate(effects, notifier, newValue);
                    continue;
                }
                this.deactivate(effects);
            }
        } else {
            this.deactivate((Collection<NotificationEffect>)this.getEffects());
        }
    }

    @Override
    public void deactivate() {
        this.deactivate((Collection<NotificationEffect>)this.getEffects());
    }

    @Override
    public EEnum resolveEEnumerator() {
        return this.getEEnum();
    }

    protected void activate(Collection<NotificationEffect> effects, ApogyNotifier notifier, Object newValue) {
        for (NotificationEffect effect : effects) {
            try {
                effect.activate(notifier, newValue);
            }
            catch (Exception e) {
                Logger.error("Sub-effect failed to activate!", (Throwable)e);
            }
        }
    }

    protected void deactivate(Collection<NotificationEffect> effects) {
        for (NotificationEffect effect : effects) {
            try {
                effect.deactivate();
            }
            catch (Exception e) {
                Logger.error("Sub-effect failed to deactivate!", (Throwable)e);
            }
        }
    }
}

