/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.GearMotor;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class GearMotorListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, GearMotor> {
    protected static DecimalFormat percentFormat = new DecimalFormat("0.00");
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static final int POWER_CONSUMED_WIDTH = 170;
    protected static final int POWER_REQUIRED_WIDTH = 170;
    protected static final int ANGULAR_VEL_WIDTH = 170;
    protected static final int TORQUE_WIDTH = 100;

    public GearMotorListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn powerConsumedColumn = new TreeViewerColumn(viewer, 0);
        powerConsumedColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        powerConsumedColumn.getColumn().setText("Power Consumed (W)");
        powerConsumedColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GearMotor) {
                    GearMotor gearMotor = (GearMotor)element;
                    return decimalFormat.format(gearMotor.getPowerConsumed());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GearMotor) {
                    return GearMotorListComposite.this.getBackgroundColor((GearMotor)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof GearMotor) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONSUMER__POWER_CONSUMED);
                }
                return null;
            }
        });
        TreeViewerColumn powerRequiredColumn = new TreeViewerColumn(viewer, 0);
        powerRequiredColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        powerRequiredColumn.getColumn().setText("Required Power (W)");
        powerRequiredColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GearMotor) {
                    GearMotor gearMotor = (GearMotor)element;
                    return decimalFormat.format(gearMotor.getRequiredPower());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GearMotor) {
                    return GearMotorListComposite.this.getBackgroundColor((GearMotor)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof GearMotor) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONSUMER__REQUIRED_POWER);
                }
                return null;
            }
        });
        TreeViewerColumn angularVelocityColumn = new TreeViewerColumn(viewer, 0);
        angularVelocityColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        angularVelocityColumn.getColumn().setText("Angular Vel. (deg/s)");
        angularVelocityColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GearMotor) {
                    GearMotor gearMotor = (GearMotor)element;
                    return decimalFormat.format(Math.toDegrees(gearMotor.getAngularvelocity()));
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GearMotor) {
                    return GearMotorListComposite.this.getBackgroundColor((GearMotor)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof GearMotor) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.MOTOR__ANGULARVELOCITY);
                }
                return null;
            }
        });
        TreeViewerColumn torqueColumn = new TreeViewerColumn(viewer, 0);
        torqueColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        torqueColumn.getColumn().setText("Torque (N*m)");
        torqueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GearMotor) {
                    GearMotor gearMotor = (GearMotor)element;
                    return decimalFormat.format(gearMotor.getTorque());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof GearMotor) {
                    return GearMotorListComposite.this.getBackgroundColor((GearMotor)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof GearMotor) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.MOTOR__TORQUE);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof GearMotor)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(GearMotor gearMotor) {
        Color color = null;
        color = !gearMotor.isPowerStateValid() ? INVALID_COLOR : (gearMotor.getPowerConsumed() != 0.0 ? Display.getCurrent().getSystemColor(5) : Display.getCurrent().getSystemColor(15));
        return color;
    }
}

