/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.ChargingState;
import org.eclipse.apogy.addons.powersystems.impl.BatteryImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BatteryCustomImpl
extends BatteryImpl {
    public static final double SECONDS_IN_HOUR = 3600.0;
    protected Date lastChangeTime = null;

    @Override
    public boolean isPowerStateValid() {
        return super.isPowerStateValid();
    }

    @Override
    public double getStorageCapacity() {
        return this.getBatteryCapacity() * 3600.0 * this.getBatteryVoltage();
    }

    @Override
    public void update(Date time) {
        double powerFlow;
        super.update(time);
        ChargingState newChargingState = null;
        newChargingState = this.getSoc() == 0.0 ? ChargingState.EMPTY : (this.getSoc() == 100.0 ? ChargingState.FULL : ((powerFlow = this.getCurrentPowerFlow()) > 0.0 ? ChargingState.CHARGING : (powerFlow < 0.0 ? ChargingState.DISCHARGING : ChargingState.NEUTRAL)));
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.BATTERY__CHARGING_STATE, (Object)newChargingState, true);
    }

    @Override
    public double computeStorageEnergyDelta(double powerFlow, double duration) {
        double efficiency = 1.0;
        efficiency = powerFlow >= 0.0 ? this.getChargingEfficiency() / 100.0 : this.getDischargingEfficiency() / 100.0;
        return powerFlow * duration * efficiency;
    }

    @Override
    public double getMaximumPowerInput() {
        if (this.getSoc() < 100.0) {
            double minimumChargingPower = this.getBatteryCapacity() * this.getBatteryVoltage() * 0.01;
            double maximumChargePower = this.getBatteryCapacity() * 0.5 * this.getBatteryVoltage() * ((100.0 - this.getSoc()) / 100.0);
            if (maximumChargePower < minimumChargingPower) {
                return minimumChargingPower;
            }
            return maximumChargePower;
        }
        return 0.0;
    }

    @Override
    public double getMaximumPowerOuput() {
        if (this.getSoc() > 0.0) {
            return this.getBatteryCapacity() * 4.0 * this.getBatteryVoltage();
        }
        return 0.0;
    }
}

