/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.BreakerState;
import org.eclipse.apogy.addons.powersystems.PowerSystemFacade;
import org.eclipse.apogy.addons.powersystems.impl.BreakerImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakerCustomImpl
extends BreakerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(BreakerCustomImpl.class);

    @Override
    public boolean isPowerStateValid() {
        boolean result = super.isPowerStateValid();
        if (this.getBreakerState() == BreakerState.OFF || this.getBreakerState() == BreakerState.TRIPPED) {
            result &= this.getOutputPower() == 0.0;
        }
        return result;
    }

    @Override
    public void reset() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.BREAKER__BREAKER_STATE, (Object)BreakerState.ON, true);
        Logger.info("Breaker " + this.getName() + " reset.");
    }

    @Override
    public void switchOff() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.BREAKER__BREAKER_STATE, (Object)BreakerState.OFF, true);
        Logger.info("Breaker " + this.getName() + " switched OFF.");
    }

    @Override
    public void trip() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.BREAKER__BREAKER_STATE, (Object)BreakerState.TRIPPED, true);
        Logger.warn("Breaker " + this.getName() + " has tripped !");
    }

    @Override
    public void update(Date time) {
        double requiredPower = PowerSystemFacade.INSTANCE.findRequiredPowerFromConsumer(this.getPowerSystem().getSystemGraph(), this);
        switch (this.getBreakerState().getValue()) {
            case 0: {
                if (!(requiredPower > this.getTripPoint())) break;
                this.trip();
                break;
            }
            case 2: {
                if (!this.isAutoReset() || !(requiredPower <= this.getTripPoint())) break;
                this.reset();
                break;
            }
        }
    }

    @Override
    public double getEffectiveEfficiency() {
        if (this.getBreakerState() == BreakerState.ON) {
            return this.getEfficiency();
        }
        return 0.0;
    }
}

